/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.InheritsPrivileges;
import org.picketlink.idm.query.RelationshipQuery;

public class PrivilegeChainQuery {
    private Map<Class<? extends Relationship>, Map<Property<IdentityType>, Property<IdentityType>>> privilegeChains = new HashMap<Class<? extends Relationship>, Map<Property<IdentityType>, Property<IdentityType>>>();

    public void registerRelationshipType(Class<? extends Relationship> relationshipType) {
        if (!this.privilegeChains.containsKey(relationshipType)) {
            List properties = PropertyQueries.createQuery(relationshipType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(InheritsPrivileges.class)).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class)).getResultList();
            HashMap<Property, Property> inheritanceMapping = new HashMap<Property, Property>();
            for (Property p : properties) {
                InheritsPrivileges annotation = p.getAnnotatedElement().getAnnotation(InheritsPrivileges.class);
                String assigneeName = annotation.value();
                if (StringUtil.isNullOrEmpty((String)assigneeName)) {
                    throw new IllegalArgumentException(String.format("Specified relationshipType [%s] does not declare valid @InheritsPrivilege annotation on property [%s] - missing assignee property name", relationshipType.getName(), p.getName()));
                }
                Property assignee = PropertyQueries.createQuery(relationshipType).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{assigneeName})).getSingleResult();
                inheritanceMapping.put(p, assignee);
            }
            this.privilegeChains.put(relationshipType, inheritanceMapping);
        }
    }

    public Set<Class<? extends Relationship>> getRelationshipClasses() {
        return this.privilegeChains.keySet();
    }

    public boolean inheritsPrivileges(RelationshipManager relationshipManager, IdentityType identity, IdentityType assignee) {
        Set<Class<? extends Relationship>> classes = this.getRelationshipClasses();
        HashSet relationships = new HashSet();
        for (Class<? extends Relationship> relationshipClass : classes) {
            RelationshipQuery query = relationshipManager.createRelationshipQuery(relationshipClass);
            query.setParameter(Relationship.IDENTITY, new Object[]{identity});
            relationships.addAll(query.getResultList());
        }
        return false;
    }
}

