/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.DefaultIdGenerator;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JDBCIdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.file.internal.FileIdentityStore;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.internal.ContextualIdentityManager;
import org.picketlink.idm.internal.ContextualPermissionManager;
import org.picketlink.idm.internal.ContextualRelationshipManager;
import org.picketlink.idm.internal.PrivilegeChainQuery;
import org.picketlink.idm.internal.util.RelationshipMetadata;
import org.picketlink.idm.jdbc.internal.JDBCIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.IdentityPartition;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.permission.acl.spi.PermissionHandlerPolicy;
import org.picketlink.idm.permission.acl.spi.PermissionStore;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.util.IDMUtil;

public class DefaultPartitionManager
implements PartitionManager,
StoreSelector {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private static final Realm DEFAULT_REALM = new Realm("default");
    private final Collection<IdentityConfiguration> configurations;
    private final Map<Partition, IdentityConfiguration> partitionConfigurations = new ConcurrentHashMap<Partition, IdentityConfiguration>();
    private final Map<IdentityConfiguration, Map<IdentityStoreConfiguration, IdentityStore<?>>> stores;
    private final IdentityConfiguration partitionManagementConfig;
    private final IdentityConfiguration attributeManagementConfig;
    private EventBridge eventBridge;
    private IdGenerator idGenerator;
    private RelationshipMetadata relationshipMetadata = new RelationshipMetadata();
    private PrivilegeChainQuery privilegeChainQuery = new PrivilegeChainQuery();
    private PermissionHandlerPolicy permissionHandlerPolicy;

    public DefaultPartitionManager(IdentityConfiguration configuration) {
        this(Arrays.asList(configuration));
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations) {
        this(configurations, null, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge, Collection<PermissionHandler> permissionHandlers) {
        this(configurations, eventBridge, permissionHandlers, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge, Collection<PermissionHandler> permissionHandlers, IdGenerator idGenerator) {
        if (configurations == null || configurations.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.configNoIdentityConfigurationProvided();
        }
        IDMLog.ROOT_LOGGER.partitionManagerBootstrap();
        try {
            this.configurations = Collections.unmodifiableCollection(configurations);
            this.eventBridge = eventBridge != null ? eventBridge : new EventBridge(){

                public void raiseEvent(Object event) {
                }
            };
            this.idGenerator = idGenerator != null ? idGenerator : new DefaultIdGenerator();
            this.permissionHandlerPolicy = new PermissionHandlerPolicy(null);
            if (permissionHandlers != null) {
                for (PermissionHandler handler : permissionHandlers) {
                    this.permissionHandlerPolicy.registerHandler(handler);
                }
            }
            IdentityConfiguration partitionCfg = null;
            IdentityConfiguration attributeCfg = null;
            for (IdentityConfiguration config : configurations) {
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (storeConfig.supportsPartition()) {
                        partitionCfg = config;
                    }
                    if (!storeConfig.supportsAttribute()) continue;
                    attributeCfg = config;
                }
            }
            this.partitionManagementConfig = partitionCfg;
            this.attributeManagementConfig = attributeCfg;
            this.logConfiguration(this.configurations);
            HashMap configuredStores = new HashMap();
            for (IdentityConfiguration config : configurations) {
                HashMap storeMap = new HashMap();
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    storeMap.put(storeConfig, this.createIdentityStore(storeConfig));
                }
                configuredStores.put(config, Collections.unmodifiableMap(storeMap));
                for (Class relationshipType : config.getRegisteredRelationshipTypes()) {
                    this.privilegeChainQuery.registerRelationshipType(relationshipType);
                }
            }
            this.stores = Collections.unmodifiableMap(configuredStores);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionManagerInitializationFailed(this.getClass(), e);
        }
    }

    public IdentityManager createIdentityManager() throws IdentityManagementException {
        return this.createIdentityManager((Partition)DEFAULT_REALM);
    }

    public IdentityManager createIdentityManager(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        Partition storedPartition = this.getStoredPartition(partition);
        try {
            return new ContextualIdentityManager(storedPartition, this.eventBridge, this.idGenerator, this, this.createRelationshipManager());
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionCouldNotCreateIdentityManager(storedPartition);
        }
    }

    public PermissionManager createPermissionManager() {
        return this.createPermissionManager((Partition)DEFAULT_REALM);
    }

    public PermissionManager createPermissionManager(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        Partition storedPartition = this.getStoredPartition(partition);
        try {
            return new ContextualPermissionManager(storedPartition, this.eventBridge, this.idGenerator, this.permissionHandlerPolicy, this);
        }
        catch (Exception ex) {
            throw IDMInternalMessages.MESSAGES.partitionCouldNotCreatePermissionManager(storedPartition);
        }
    }

    public RelationshipManager createRelationshipManager() {
        return new ContextualRelationshipManager(this.eventBridge, this.idGenerator, this, this.privilegeChainQuery);
    }

    public <T extends Partition> T getPartition(Class<T> partitionClass, String name) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition name");
        }
        if (this.partitionManagementConfig == null) {
            return (T)this.createDefaultPartition();
        }
        try {
            IdentityContext context = this.createIdentityContext();
            Partition partition = this.getStoreForPartitionOperation(context, partitionClass).get(context, partitionClass, name);
            if (partition != null) {
                this.loadAttributes(context, partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, name, e);
        }
    }

    public <T extends Partition> List<T> getPartitions(Class<T> partitionClass) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (this.partitionManagementConfig == null) {
            partitions.add(this.createDefaultPartition());
        } else {
            try {
                IdentityContext context = this.createIdentityContext();
                partitions.addAll(this.getStoreForPartitionOperation(context, partitionClass).get(context, partitionClass));
                for (Partition partition : partitions) {
                    this.loadAttributes(context, partition);
                }
            }
            catch (Exception e) {
                throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, "not specified", e);
            }
        }
        return partitions;
    }

    public <T extends Partition> T lookupById(Class<T> partitionClass, String id) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition identifier");
        }
        if (this.partitionManagementConfig == null) {
            return (T)this.createDefaultPartition();
        }
        try {
            IdentityContext context = this.createIdentityContext();
            Partition partition = this.getStoreForPartitionOperation(context, partitionClass).lookupById(context, partitionClass, id);
            if (partition != null) {
                this.loadAttributes(context, partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, id, e);
        }
    }

    public void add(Partition partition) throws IdentityManagementException {
        this.add(partition, null);
    }

    public void add(Partition partition, String configurationName) throws IdentityManagementException {
        this.checkPartitionManagementSupported();
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        if (StringUtil.isNullOrEmpty((String)configurationName)) {
            configurationName = this.getDefaultConfigurationName();
        }
        if (this.getConfigurationByName(configurationName) != null) {
            if (this.getPartition(partition.getClass(), partition.getName()) != null) {
                throw IDMInternalMessages.MESSAGES.partitionAlreadyExistsWithName(partition.getClass(), partition.getName());
            }
            try {
                IdentityContext context = this.createIdentityContext();
                this.getStoreForPartitionOperation(context, partition.getClass()).add(context, partition, configurationName);
                Object attributeStore = this.getStoreForAttributeOperation(context);
                if (attributeStore != null) {
                    for (Attribute attribute : partition.getAttributes()) {
                        attributeStore.setAttribute(context, (AttributedType)partition, attribute);
                    }
                }
            }
            catch (Exception e) {
                throw IDMInternalMessages.MESSAGES.partitionAddFailed(partition, configurationName, e);
            }
        }
    }

    public void update(Partition partition) throws IdentityManagementException {
        this.checkPartitionManagementSupported();
        this.checkIfPartitionExists(partition);
        try {
            IdentityContext context = this.createIdentityContext();
            this.getStoreForPartitionOperation(context, partition.getClass()).update(context, partition);
            Object attributeStore = this.getStoreForAttributeOperation(context);
            if (attributeStore != null) {
                Object storedType = this.lookupById(partition.getClass(), partition.getId());
                for (Attribute attribute : storedType.getAttributes()) {
                    if (partition.getAttribute(attribute.getName()) != null) continue;
                    attributeStore.removeAttribute(context, (AttributedType)partition, attribute.getName());
                }
                for (Attribute attribute : partition.getAttributes()) {
                    attributeStore.setAttribute(context, (AttributedType)partition, attribute);
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionUpdateFailed(partition, e);
        }
    }

    public void remove(Partition partition) throws IdentityManagementException {
        this.checkPartitionManagementSupported();
        this.checkIfPartitionExists(partition);
        try {
            IdentityContext context = this.createIdentityContext();
            Object attributeStore = this.getStoreForAttributeOperation(context);
            if (attributeStore != null) {
                Object storedType = this.lookupById(partition.getClass(), partition.getId());
                IdentityManager identityManager = this.createIdentityManager((Partition)storedType);
                IdentityQuery query = identityManager.createIdentityQuery(IdentityType.class);
                for (IdentityType identityType : query.getResultList()) {
                    identityManager.remove(identityType);
                }
                for (Attribute attribute : storedType.getAttributes()) {
                    attributeStore.removeAttribute(context, storedType, attribute.getName());
                }
            }
            this.getStoreForPartitionOperation(context, partition.getClass()).remove(context, partition);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionRemoveFailed(partition, e);
        }
    }

    public Collection<IdentityConfiguration> getConfigurations() {
        return this.configurations;
    }

    public <T extends IdentityStore<?>> T getStoreForIdentityOperation(IdentityContext context, Class<T> storeType, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        this.checkSupportedTypes(context.getPartition(), type);
        IdentityConfiguration identityConfiguration = null;
        if (this.partitionManagementConfig != null) {
            identityConfiguration = this.getConfigurationForPartition(context.getPartition());
        } else if (this.configurations.size() == 1) {
            identityConfiguration = this.configurations.iterator().next();
        }
        T identityStore = null;
        if (identityConfiguration == null) {
            IdentityConfiguration configuration;
            Iterator<IdentityConfiguration> i$ = this.configurations.iterator();
            while (i$.hasNext() && (identityStore = (T)this.lookupStore(context, configuration = i$.next(), type, operation)) == null) {
            }
        } else {
            identityStore = this.lookupStore(context, identityConfiguration, type, operation);
        }
        if (identityStore == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(type, operation, type, operation);
        }
        return identityStore;
    }

    public Set<IdentityStore<?>> getStoresForIdentityQuery(IdentityContext context, Class<? extends IdentityType> identityType) {
        HashSet identityStores = new HashSet();
        for (IdentityConfiguration configuration : this.configurations) {
            for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                if (!storeConfig.supportsType(identityType, IdentityStoreConfiguration.IdentityOperation.read) && !IdentityType.class.equals(identityType)) continue;
                identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, configuration, storeConfig));
            }
        }
        if (identityStores.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(identityType, IdentityStoreConfiguration.IdentityOperation.read, identityType, IdentityStoreConfiguration.IdentityOperation.read);
        }
        return identityStores;
    }

    public <T extends IdentityStore<?>> T lookupStore(IdentityContext context, IdentityConfiguration configuration, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
            if (!storeConfig.supportsType(type, operation)) continue;
            return this.getIdentityStoreAndInitializeContext(context, configuration, storeConfig);
        }
        return null;
    }

    public <T extends CredentialStore<?>> T getStoreForCredentialOperation(IdentityContext context, Class<?> credentialClass) {
        CredentialStore store = null;
        IdentityConfiguration identityConfiguration = null;
        if (this.partitionManagementConfig != null) {
            identityConfiguration = this.getConfigurationForPartition(context.getPartition());
        } else {
            for (IdentityConfiguration configuration : this.configurations) {
                for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                    if (!storeConfig.supportsCredential()) continue;
                    identityConfiguration = configuration;
                }
            }
        }
        if (identityConfiguration != null && identityConfiguration.supportsCredential()) {
            for (IdentityStoreConfiguration storeConfig : identityConfiguration.getStoreConfiguration()) {
                if (!storeConfig.supportsCredential()) continue;
                for (Class handlerClass : storeConfig.getCredentialHandlers()) {
                    if (!handlerClass.isAnnotationPresent(SupportsCredentials.class)) continue;
                    for (Class cls : handlerClass.getAnnotation(SupportsCredentials.class).credentialClass()) {
                        if (!cls.isAssignableFrom(credentialClass)) continue;
                        Object identityStore = null;
                        try {
                            store = (CredentialStore)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig);
                        }
                        catch (ClassCastException cce) {
                            throw IDMInternalMessages.MESSAGES.storeUnexpectedType(identityStore.getClass(), CredentialStore.class);
                        }
                        if (!cls.equals(credentialClass)) continue;
                        return (T)store;
                    }
                }
            }
        }
        if (store == null) {
            throw IDMInternalMessages.MESSAGES.credentialNoStoreForCredentials(credentialClass);
        }
        return (T)store;
    }

    public IdentityStore<?> getStoreForRelationshipOperation(IdentityContext context, Class<? extends Relationship> relationshipClass, Relationship relationship, IdentityStoreConfiguration.IdentityOperation operation) {
        Set<Partition> partitions = this.relationshipMetadata.getRelationshipPartitions(relationship);
        IdentityStore<?> store = null;
        if (partitions.size() == 1) {
            IdentityConfiguration config = this.partitionManagementConfig != null ? this.getConfigurationForPartition(partitions.iterator().next()) : this.configurations.iterator().next();
            if (config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) {
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig);
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig);
                }
            }
        }
        if (store == null) {
            for (IdentityConfiguration cfg : this.configurations) {
                if (!cfg.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : cfg.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, cfg, storeConfig);
                }
            }
        }
        if (store == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(relationshipClass, operation, relationshipClass, operation);
        }
        return store;
    }

    public Set<IdentityStore<?>> getStoresForRelationshipQuery(IdentityContext context, Class<? extends Relationship> relationshipClass, Set<Partition> partitions) {
        HashSet identityStores = new HashSet();
        if (partitions.isEmpty()) {
            for (IdentityConfiguration config : this.configurations) {
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass) && !config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create) && !Relationship.class.equals(relationshipClass)) continue;
                    identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig));
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create) && !Relationship.class.equals(relationshipClass)) continue;
                    identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig));
                }
            }
        }
        if (identityStores.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(relationshipClass, IdentityStoreConfiguration.IdentityOperation.read, relationshipClass, IdentityStoreConfiguration.IdentityOperation.read);
        }
        return identityStores;
    }

    public <T extends PartitionStore<?>> T getStoreForPartitionOperation(IdentityContext context, Class<? extends Partition> partitionClass) {
        Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(this.partitionManagementConfig);
        for (IdentityStoreConfiguration cfg : configStores.keySet()) {
            if (!cfg.supportsType(partitionClass, IdentityStoreConfiguration.IdentityOperation.create)) continue;
            PartitionStore store = (PartitionStore)this.getIdentityStoreAndInitializeContext(context, this.partitionManagementConfig, cfg);
            if (!PartitionStore.class.isInstance(store)) {
                throw IDMInternalMessages.MESSAGES.storeUnexpectedType(store.getClass(), PartitionStore.class);
            }
            return (T)store;
        }
        throw IDMInternalMessages.MESSAGES.storeNotFound(PartitionStore.class);
    }

    public <T extends AttributeStore<?>> T getStoreForAttributeOperation(IdentityContext context) {
        if (this.attributeManagementConfig != null) {
            Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(this.attributeManagementConfig);
            for (IdentityStoreConfiguration cfg : configStores.keySet()) {
                if (!cfg.supportsAttribute()) continue;
                AttributeStore store = (AttributeStore)this.getIdentityStoreAndInitializeContext(context, this.attributeManagementConfig, cfg);
                if (!AttributeStore.class.isInstance(store)) {
                    throw IDMInternalMessages.MESSAGES.storeUnexpectedType(store.getClass(), AttributeStore.class);
                }
                return (T)store;
            }
        }
        return null;
    }

    public Set<CredentialStore<?>> getStoresForCredentialStorage(IdentityContext context, Class<? extends CredentialStorage> storageClass) {
        Map<IdentityStoreConfiguration, IdentityStore<?>> storesConfig = this.stores.get(this.getConfigurationForPartition(context.getPartition()));
        HashSet credentialStores = new HashSet();
        if (storesConfig != null) {
            for (IdentityStore<?> identityStore : storesConfig.values()) {
                if (!CredentialStore.class.isInstance(identityStore) || !identityStore.getConfig().supportsCredential()) continue;
                CredentialStore credentialStore = (CredentialStore)identityStore;
                for (Class credentialHandler : credentialStore.getConfig().getCredentialHandlers()) {
                    SupportsCredentials supportedCredentials = credentialHandler.getAnnotation(SupportsCredentials.class);
                    if (supportedCredentials == null || !supportedCredentials.credentialStorage().equals(storageClass)) continue;
                    credentialStores.add(credentialStore);
                }
            }
        }
        return credentialStores;
    }

    public PermissionStore getStoreForPermissionOperation(IdentityContext context) {
        IdentityConfiguration identityConfiguration = null;
        if (this.partitionManagementConfig != null) {
            identityConfiguration = this.getConfigurationForPartition(context.getPartition());
        } else if (this.configurations.size() == 1) {
            identityConfiguration = this.configurations.iterator().next();
        }
        if (identityConfiguration == null) {
            for (IdentityConfiguration configuration : this.configurations) {
                for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                    if (!storeConfig.supportsPermissions()) continue;
                    return (PermissionStore)this.getIdentityStoreAndInitializeContext(context, configuration, storeConfig);
                }
            }
        } else {
            for (IdentityStoreConfiguration storeConfig : identityConfiguration.getStoreConfiguration()) {
                if (!storeConfig.supportsPermissions()) continue;
                return (PermissionStore)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig);
            }
        }
        throw IDMInternalMessages.MESSAGES.permissionUnsupportedOperation();
    }

    private <T extends IdentityStore> T createIdentityStore(IdentityStoreConfiguration storeConfiguration) {
        Class storeClass = storeConfiguration.getIdentityStoreType();
        if (storeClass == null) {
            if (FileIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = FileIdentityStore.class;
            } else if (JPAIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = JPAIdentityStore.class;
            } else if (LDAPIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = LDAPIdentityStore.class;
            } else if (JDBCIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = JDBCIdentityStore.class;
            }
        }
        if (storeClass == null) {
            throw IDMInternalMessages.MESSAGES.configUnknownStoreForConfiguration(storeConfiguration);
        }
        try {
            if (storeConfiguration instanceof AbstractIdentityStoreConfiguration) {
                ((AbstractIdentityStoreConfiguration)storeConfiguration).setIdentityStoreType(storeClass);
            }
            IdentityStore store = (IdentityStore)storeClass.newInstance();
            store.setup(storeConfiguration);
            return (T)store;
        }
        catch (Exception ex) {
            throw IDMInternalMessages.MESSAGES.configCouldNotCreateStore(storeClass, storeConfiguration, ex);
        }
    }

    private IdentityConfiguration getConfigurationByName(String name) {
        for (IdentityConfiguration config : this.configurations) {
            if (!name.equals(config.getName())) continue;
            return config;
        }
        throw IDMInternalMessages.MESSAGES.partitionNoConfigurationFound(name);
    }

    private IdentityConfiguration getConfigurationForPartition(Partition partition) {
        IdentityConfiguration identityConfiguration;
        if (!this.partitionConfigurations.containsKey(partition)) {
            IdentityContext context = this.createIdentityContext();
            Object store = this.getStoreForPartitionOperation(context, partition.getClass());
            this.partitionConfigurations.put(partition, this.getConfigurationByName(store.getConfigurationName(context, partition)));
        }
        if ((identityConfiguration = this.partitionConfigurations.get(partition)) == null) {
            throw IDMInternalMessages.MESSAGES.partitionReferencesInvalidConfiguration(partition);
        }
        return identityConfiguration;
    }

    private IdentityContext createIdentityContext() {
        return new AbstractIdentityContext(null, this.eventBridge, this.idGenerator){

            @Override
            public EventBridge getEventBridge() {
                return DefaultPartitionManager.this.eventBridge;
            }

            @Override
            public IdGenerator getIdGenerator() {
                return DefaultPartitionManager.this.idGenerator;
            }

            @Override
            public Partition getPartition() {
                return null;
            }
        };
    }

    private String getDefaultConfigurationName() {
        for (IdentityConfiguration config : this.configurations) {
            if (!DEFAULT_CONFIGURATION_NAME.equals(config.getName())) continue;
            return DEFAULT_CONFIGURATION_NAME;
        }
        return this.configurations.iterator().next().getName();
    }

    private void checkPartitionManagementSupported() throws OperationNotSupportedException {
        if (this.partitionManagementConfig == null) {
            throw IDMInternalMessages.MESSAGES.partitionManagementNoSupported(Partition.class, IdentityStoreConfiguration.IdentityOperation.create);
        }
    }

    private void checkSupportedTypes(Partition partition, Class<? extends AttributedType> type) {
        IdentityPartition identityPartition;
        if (partition != null && IdentityType.class.isAssignableFrom(type) && (identityPartition = partition.getClass().getAnnotation(IdentityPartition.class)) != null && IDMUtil.isTypeSupported(type, (Set)IDMUtil.toSet((Object[])identityPartition.supportedTypes()), (Set)IDMUtil.toSet((Object[])identityPartition.unsupportedTypes())) == -1) {
            throw IDMInternalMessages.MESSAGES.partitionUnsupportedType(partition, type);
        }
    }

    private void checkIfPartitionExists(Partition partition) {
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        if (this.lookupById(partition.getClass(), partition.getId()) == null) {
            throw IDMInternalMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
    }

    private Partition createDefaultPartition() {
        Realm storedPartition = new Realm(DEFAULT_CONFIGURATION_NAME);
        storedPartition.setId(DEFAULT_CONFIGURATION_NAME);
        return storedPartition;
    }

    private Partition getStoredPartition(Partition partition) {
        Object storedPartition = this.partitionManagementConfig != null ? this.getPartition(partition.getClass(), partition.getName()) : this.createDefaultPartition();
        if (storedPartition == null) {
            throw IDMInternalMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
        return storedPartition;
    }

    private <T extends IdentityStore<?>> T getIdentityStoreAndInitializeContext(IdentityContext context, IdentityConfiguration configuration, IdentityStoreConfiguration storeConfig) {
        IdentityStore<?> store = this.stores.get(configuration).get(storeConfig);
        storeConfig.initializeContext(context, store);
        return (T)store;
    }

    private <T extends Partition> void loadAttributes(IdentityContext context, T partition) {
        T attributeStore = this.getStoreForAttributeOperation(context);
        if (attributeStore != null) {
            attributeStore.loadAttributes(context, partition);
        }
    }

    private void logConfiguration(Collection<IdentityConfiguration> configurations) {
        for (IdentityConfiguration identityConfiguration : configurations) {
            if (!IDMLog.ROOT_LOGGER.isDebugEnabled()) continue;
            IDMLog.ROOT_LOGGER.debug((Object)"  Identity Management Configuration: [");
            IDMLog.ROOT_LOGGER.debugf("    Name: %s", (Object)identityConfiguration.getName());
            IDMLog.ROOT_LOGGER.debugf("    Identity Store Configuration: %s", (Object)identityConfiguration.getStoreConfiguration());
            IDMLog.ROOT_LOGGER.debugf("    Supports Partition: %s", (Object)(this.partitionManagementConfig != null && this.partitionManagementConfig.equals((Object)identityConfiguration) ? 1 : 0));
            IDMLog.ROOT_LOGGER.debugf("    Supports Attribute: %s", (Object)(this.attributeManagementConfig != null && this.attributeManagementConfig.equals((Object)identityConfiguration) ? 1 : 0));
            IDMLog.ROOT_LOGGER.debugf("    Supports Credential: %s", (Object)identityConfiguration.supportsCredential());
            ArrayList supportedTypes = new ArrayList();
            for (IdentityStoreConfiguration storeConfiguration : identityConfiguration.getStoreConfiguration()) {
                supportedTypes.addAll(storeConfiguration.getSupportedTypes().keySet());
            }
            IDMLog.ROOT_LOGGER.debugf("    Supported Types: %s", supportedTypes);
            IDMLog.ROOT_LOGGER.debug((Object)"  ]");
        }
    }
}

