/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;

public class IDMInternalMessages_$bundle
implements Serializable,
IDMInternalMessages,
IDMMessages {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "PLIDM";
    public static final IDMInternalMessages_$bundle INSTANCE = new IDMInternalMessages_$bundle();
    private static final String attributedUndefinedPartition = "Undefined partition for identity type [%s].";
    private static final String credentialNoAccountTypeProvided = "No Account type provided. You must provide at least one Account type in order to support credential management.";
    private static final String configUnknownStoreForConfiguration = "Unknown IdentityStore class for configuration [%s].";
    private static final String configJpaStoreRequiredMappingAnnotation = "Entity [%s] must have a field annotated with %s.";
    private static final String configStoreMultiplePartitionConfigExists = "Only a single identity store config can support partitions. Found [%s] and [%s].";
    private static final String permissionUnsupportedOperation = "No PermissionStore configuration found for requested permission operation.";
    private static final String storeLdapCouldNotCreateContext = "Could not create context.";
    private static final String configJpaStoreMappedPropertyNotFound = "Mapped attribute [%s.%s] does not map to any field for type [%s].";
    private static final String partitionManagerInitializationFailed = "Could not initialize Partition Manager [%s].";
    private static final String partitionFoundWithSameNameAndType = "More than one partitions have been found with the given name [%s] and type [%s].";
    private static final String attributedTypeAddFailed = "Could not add AttributedType [%s].";
    private static final String storeLdapEntryNotFoundWithId = "Entry not found with ID [%s] using baseDN [%s].";
    private static final String credentialValidationFailed = "Credential validation failed [%s].";
    private static final String marshallingError = "Error marshalling object.";
    private static final String permissionRevokeFailed = "Could not revoke permission granted to [%s] for resource [%s], operation [%s].";
    private static final String unmarshallingError = "Error unmarshalling object.";
    private static final String attributedTypeUpdateFailed = "Could not update AttributedType [%s].";
    private static final String nullArgument = "Null argument: [%s].";
    private static final String configMultipleConfigurationsFoundWithCredentialSupport = "Multiple configuration with credential support.";
    private static final String credentialMultipleAccountsFoundForType = "Multiple Account objects found with same login name [%s] for account type [%s].";
    private static final String configBuildMultipleConfigurationExists = "You have provided more than one configuration. Use the buildAll method instead.";
    private static final String partitionManagementNoSupported = "Partition management is not supported by the current configuration.";
    private static final String storeLdapCouldNotLoadAttributesForEntry = "Could not load attributes for entry with ID [%s] using baseDN [%s].";
    private static final String queryRelationshipFailed = "Could not query Relationship using query [%s].";
    private static final String queryIdentityTypeFailed = "Could not query IdentityType using query [%s].";
    private static final String credentialInvalidPassword = "Invalid Password or it was not provided.";
    private static final String partitionUnsupportedType = "Partition [%s] does not support type [%s].";
    private static final String configMultipleConfigurationsFoundWithSameName = "Multiple configuration with the same name [%s].";
    private static final String unexpectedType = "Unexpected type [%s].";
    private static final String credentialInvalidAccountType = "The IdentityType returned is not an Account: [%s]";
    private static final String permissionsRevokeFailed = "Could not revoke Permissions [%s].";
    private static final String credentialHandlerNotFoundForCredentialType = "No suitable CredentialHandler available for validating Credentials of type [%s].";
    private static final String configStoreNoIdentityStoreConfigProvided = "You must configure at least one identity store.";
    private static final String credentialDigestInvalidRealm = "Invalid Realm or it was not provided.";
    private static final String permissionsGrantFailed = "Could not grant Permissions [%s].";
    private static final String partitionReferencesInvalidConfiguration = "Partition [%s] references an invalid or non-existent configuration.";
    private static final String identityTypeAlreadyExists = "IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].";
    private static final String partitionGetFailed = "Could not load partition for type [%s] and name [%s].";
    private static final String instantiationError = "Error creating instance for type [%s].";
    private static final String credentialCouldNotEncodePassword = "Could not encode password.";
    private static final String attributedTypeAmbiguosFoundWithId = "Ambiguous AttributedType found with identifier [%s].";
    private static final String permissionGrantFailed = "Could not grant permission to [%s] for resource [%s], operation [%s].";
    private static final String storeNotFound = "No store found with type [%s].";
    private static final String storeUnexpectedType = "Unexpected IdentityStore type. Expected [%s]. Actual [%s].";
    private static final String configStoreDuplicatedSupportedType = "Duplicated supported types [%s] found for identity store configuration. Check your identity store configuration for duplicated types, considering their hierarchy.";
    private static final String attributedTypeUnsupportedOperation = "No identity store configuration found for requested type operation [%s.%s].";
    private static final String configCouldNotCreateStore = "Error while creating IdentityStore [%s] instance for configuration [%s].";
    private static final String configJpaStoreNoEntityClassesProvided = "Error initializing JpaIdentityStore - no entity classes configured.";
    private static final String configInvalidConfiguration = "Invalid configuration [%s].";
    private static final String credentialInvalidEncodingAlgorithm = "No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].";
    private static final String configNoConfigurationProvided = "You must provide at least one configuration.";
    private static final String attributedTypeNotFoundWithId = "Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]";
    private static final String partitionUpdateFailed = "Could not update partition [%s].";
    private static final String permissionRevokeAllFailed = "Failed to revoke all permissions for resource [%s].";
    private static final String configNoIdentityConfigurationProvided = "At least one IdentityConfiguration must be provided";
    private static final String attributedTypeRemoveFailed = "Could not remove AttributedType [%s].";
    private static final String partitionRemoveFailed = "Could not remove partition [%s].";
    private static final String configJpaStoreNoPermissionEntityClassProvided = "No @Entity class found to store permissions. Check if you have an @Entity class annotated with @PermissionManaged.";
    private static final String partitionNoConfigurationFound = "No configuration found with the given name [%s].";
    private static final String credentialNoStoreForCredentials = "No IdentityStore found for credential class [%s]";
    private static final String configCouldNotCreateConfiguration = "Could not create configuration.";
    private static final String credentialRetrievalFailed = "Credentials could not be retrieved for account [%s] and storage [%s].";
    private static final String queryUnsupportedParameterValue = "Unsupported value for Query Parameter [%s]. Value: %s.";
    private static final String credentialUpdateFailed = "Credential update failed for account [%s] and type [%s].";
    private static final String partitionAlreadyExistsWithName = "A Partition [%s] with name [%s] already exists.";
    private static final String partitionCouldNotCreateIdentityManager = "Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.";
    private static final String credentialUnsupportedType = "Credentials class [%s] not supported by this handler [%s].";
    private static final String partitionCouldNotCreatePermissionManager = "Could not create contextual PermissionManager for Partition [%s].";
    private static final String partitionAddFailed = "Could not create partition [%s] using configuration [%s].";
    private static final String partitionWithNoConfigurationName = "No configuration name defined for partition [%s].";
    private static final String partitionNotFoundWithName = "Partition [%s] not found with the given name [%s].";
    private static final String storeJpaCouldNotGetEntityManagerFromStoreContext = "Error while trying to determine EntityManager - context parameter not set.";

    protected IDMInternalMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IdentityManagementException attributedUndefinedPartition(IdentityType identityType) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000605: " + this.attributedUndefinedPartition$str(), identityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedUndefinedPartition$str() {
        return attributedUndefinedPartition;
    }

    public final IdentityManagementException credentialNoAccountTypeProvided() {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000207: " + this.credentialNoAccountTypeProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoAccountTypeProvided$str() {
        return credentialNoAccountTypeProvided;
    }

    public final SecurityConfigurationException configUnknownStoreForConfiguration(IdentityStoreConfiguration arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configUnknownStoreForConfiguration$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configUnknownStoreForConfiguration$str() {
        return configUnknownStoreForConfiguration;
    }

    public final SecurityConfigurationException configJpaStoreRequiredMappingAnnotation(Class arg0, Class arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreRequiredMappingAnnotation$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreRequiredMappingAnnotation$str() {
        return configJpaStoreRequiredMappingAnnotation;
    }

    public final SecurityConfigurationException configStoreMultiplePartitionConfigExists(IdentityStoreConfiguration arg0, IdentityStoreConfiguration arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configStoreMultiplePartitionConfigExists$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreMultiplePartitionConfigExists$str() {
        return configStoreMultiplePartitionConfigExists;
    }

    @Override
    public final IdentityManagementException permissionUnsupportedOperation() {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000800: " + this.permissionUnsupportedOperation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionUnsupportedOperation$str() {
        return permissionUnsupportedOperation;
    }

    @Override
    public final IdentityManagementException storeLdapCouldNotCreateContext(Throwable e) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000302: " + this.storeLdapCouldNotCreateContext$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotCreateContext$str() {
        return storeLdapCouldNotCreateContext;
    }

    public final SecurityConfigurationException configJpaStoreMappedPropertyNotFound(Class arg0, String arg1, Class arg2) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreMappedPropertyNotFound$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreMappedPropertyNotFound$str() {
        return configJpaStoreMappedPropertyNotFound;
    }

    public final IdentityManagementException partitionManagerInitializationFailed(Class partitionManagerType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000006: " + this.partitionManagerInitializationFailed$str(), partitionManagerType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagerInitializationFailed$str() {
        return partitionManagerInitializationFailed;
    }

    public final IdentityManagementException partitionFoundWithSameNameAndType(String name, Class partitionClass) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000412: " + this.partitionFoundWithSameNameAndType$str(), name, partitionClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionFoundWithSameNameAndType$str() {
        return partitionFoundWithSameNameAndType;
    }

    @Override
    public final IdentityManagementException attributedTypeAddFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000600: " + this.attributedTypeAddFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAddFailed$str() {
        return attributedTypeAddFailed;
    }

    @Override
    public final IdentityManagementException storeLdapEntryNotFoundWithId(String entryUUID, String baseDN) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeLdapEntryNotFoundWithId$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapEntryNotFoundWithId$str() {
        return storeLdapEntryNotFoundWithId;
    }

    public final IdentityManagementException credentialValidationFailed(Credentials arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000200: " + this.credentialValidationFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialValidationFailed$str() {
        return credentialValidationFailed;
    }

    public final IdentityManagementException marshallingError(Throwable arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000004: " + this.marshallingError$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String marshallingError$str() {
        return marshallingError;
    }

    public final IdentityManagementException permissionRevokeFailed(IdentityType arg0, Object arg1, String arg2, Throwable arg3) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionRevokeFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeFailed$str() {
        return permissionRevokeFailed;
    }

    public final IdentityManagementException unmarshallingError(Throwable arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000003: " + this.unmarshallingError$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unmarshallingError$str() {
        return unmarshallingError;
    }

    @Override
    public final IdentityManagementException attributedTypeUpdateFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000602: " + this.attributedTypeUpdateFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUpdateFailed$str() {
        return attributedTypeUpdateFailed;
    }

    public final IdentityManagementException nullArgument(String arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000002: " + this.nullArgument$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArgument$str() {
        return nullArgument;
    }

    public final SecurityConfigurationException configMultipleConfigurationsFoundWithCredentialSupport() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000707: " + this.configMultipleConfigurationsFoundWithCredentialSupport$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithCredentialSupport$str() {
        return configMultipleConfigurationsFoundWithCredentialSupport;
    }

    public final IdentityManagementException credentialMultipleAccountsFoundForType(String arg0, Class arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000206: " + this.credentialMultipleAccountsFoundForType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialMultipleAccountsFoundForType$str() {
        return credentialMultipleAccountsFoundForType;
    }

    public final SecurityConfigurationException configBuildMultipleConfigurationExists() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000703: " + this.configBuildMultipleConfigurationExists$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configBuildMultipleConfigurationExists$str() {
        return configBuildMultipleConfigurationExists;
    }

    public final OperationNotSupportedException partitionManagementNoSupported(Class partitionClass, IdentityStoreConfiguration.IdentityOperation create) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format("PLIDM000409: " + this.partitionManagementNoSupported$str(), new Object[0]), partitionClass, create);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionManagementNoSupported$str() {
        return partitionManagementNoSupported;
    }

    @Override
    public final IdentityManagementException storeLdapCouldNotLoadAttributesForEntry(String entryUUID, String baseDN) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeLdapCouldNotLoadAttributesForEntry$str(), entryUUID, baseDN));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeLdapCouldNotLoadAttributesForEntry$str() {
        return storeLdapCouldNotLoadAttributesForEntry;
    }

    public final IdentityManagementException queryRelationshipFailed(RelationshipQuery query, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000500: " + this.queryRelationshipFailed$str(), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryRelationshipFailed$str() {
        return queryRelationshipFailed;
    }

    public final IdentityManagementException queryIdentityTypeFailed(IdentityQuery query, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000501: " + this.queryIdentityTypeFailed$str(), query), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryIdentityTypeFailed$str() {
        return queryIdentityTypeFailed;
    }

    public final IdentityManagementException credentialInvalidPassword() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialInvalidPassword$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidPassword$str() {
        return credentialInvalidPassword;
    }

    public final IdentityManagementException partitionUnsupportedType(Partition partition, Class type) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000411: " + this.partitionUnsupportedType$str(), partition, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUnsupportedType$str() {
        return partitionUnsupportedType;
    }

    public final SecurityConfigurationException configMultipleConfigurationsFoundWithSameName(String arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configMultipleConfigurationsFoundWithSameName$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configMultipleConfigurationsFoundWithSameName$str() {
        return configMultipleConfigurationsFoundWithSameName;
    }

    public final IdentityManagementException unexpectedType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000005: " + this.unexpectedType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedType$str() {
        return unexpectedType;
    }

    public final IdentityManagementException credentialInvalidAccountType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000205: " + this.credentialInvalidAccountType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidAccountType$str() {
        return credentialInvalidAccountType;
    }

    public final IdentityManagementException permissionsRevokeFailed(String arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionsRevokeFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsRevokeFailed$str() {
        return permissionsRevokeFailed;
    }

    public final IdentityManagementException credentialHandlerNotFoundForCredentialType(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialHandlerNotFoundForCredentialType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialHandlerNotFoundForCredentialType$str() {
        return credentialHandlerNotFoundForCredentialType;
    }

    public final SecurityConfigurationException configStoreNoIdentityStoreConfigProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000705: " + this.configStoreNoIdentityStoreConfigProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreNoIdentityStoreConfigProvided$str() {
        return configStoreNoIdentityStoreConfigProvided;
    }

    public final IdentityManagementException credentialDigestInvalidRealm() {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialDigestInvalidRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialDigestInvalidRealm$str() {
        return credentialDigestInvalidRealm;
    }

    public final IdentityManagementException permissionsGrantFailed(String arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionsGrantFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionsGrantFailed$str() {
        return permissionsGrantFailed;
    }

    @Override
    public final IdentityManagementException partitionReferencesInvalidConfiguration(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000408: " + this.partitionReferencesInvalidConfiguration$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionReferencesInvalidConfiguration$str() {
        return partitionReferencesInvalidConfiguration;
    }

    public final IdentityManagementException identityTypeAlreadyExists(Class type, String identifier, Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.identityTypeAlreadyExists$str(), type, identifier, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String identityTypeAlreadyExists$str() {
        return identityTypeAlreadyExists;
    }

    public final IdentityManagementException partitionGetFailed(Class partitionClass, String name, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000404: " + this.partitionGetFailed$str(), partitionClass, name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionGetFailed$str() {
        return partitionGetFailed;
    }

    public final IdentityManagementException instantiationError(Class arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000001: " + this.instantiationError$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String instantiationError$str() {
        return instantiationError;
    }

    public final IdentityManagementException credentialCouldNotEncodePassword(UnsupportedEncodingException arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialCouldNotEncodePassword$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialCouldNotEncodePassword$str() {
        return credentialCouldNotEncodePassword;
    }

    @Override
    public final IdentityManagementException attributedTypeAmbiguosFoundWithId(String id) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000603: " + this.attributedTypeAmbiguosFoundWithId$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeAmbiguosFoundWithId$str() {
        return attributedTypeAmbiguosFoundWithId;
    }

    public final IdentityManagementException permissionGrantFailed(IdentityType arg0, Object arg1, String arg2, Throwable arg3) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionGrantFailed$str(), arg0, arg1, arg2), arg3);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionGrantFailed$str() {
        return permissionGrantFailed;
    }

    public final IdentityManagementException storeNotFound(Class partitionStoreClass) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000300: " + this.storeNotFound$str(), partitionStoreClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeNotFound$str() {
        return storeNotFound;
    }

    public final IdentityManagementException storeUnexpectedType(Class expectedType, Class actualType) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.storeUnexpectedType$str(), expectedType, actualType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeUnexpectedType$str() {
        return storeUnexpectedType;
    }

    public final SecurityConfigurationException configStoreDuplicatedSupportedType(Class arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000706: " + this.configStoreDuplicatedSupportedType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configStoreDuplicatedSupportedType$str() {
        return configStoreDuplicatedSupportedType;
    }

    public final OperationNotSupportedException attributedTypeUnsupportedOperation(Class type, IdentityStoreConfiguration.IdentityOperation operation, Class typeToDisplay, IdentityStoreConfiguration.IdentityOperation operationToDisplay) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format("PLIDM000604: " + this.attributedTypeUnsupportedOperation$str(), typeToDisplay, operationToDisplay), type, operation);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeUnsupportedOperation$str() {
        return attributedTypeUnsupportedOperation;
    }

    public final SecurityConfigurationException configCouldNotCreateStore(Class arg0, IdentityStoreConfiguration arg1, Exception arg2) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configCouldNotCreateStore$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateStore$str() {
        return configCouldNotCreateStore;
    }

    public final SecurityConfigurationException configJpaStoreNoEntityClassesProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format(this.configJpaStoreNoEntityClassesProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoEntityClassesProvided$str() {
        return configJpaStoreNoEntityClassesProvided;
    }

    public final SecurityConfigurationException configInvalidConfiguration(String arg0, Throwable arg1) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000701: " + this.configInvalidConfiguration$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configInvalidConfiguration$str() {
        return configInvalidConfiguration;
    }

    public final IdentityManagementException credentialInvalidEncodingAlgorithm(String arg0, PasswordEncoder arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.credentialInvalidEncodingAlgorithm$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialInvalidEncodingAlgorithm$str() {
        return credentialInvalidEncodingAlgorithm;
    }

    public final SecurityConfigurationException configNoConfigurationProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000702: " + this.configNoConfigurationProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoConfigurationProvided$str() {
        return configNoConfigurationProvided;
    }

    public final IdentityManagementException attributedTypeNotFoundWithId(Class type, String id, Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.attributedTypeNotFoundWithId$str(), type, id, partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeNotFoundWithId$str() {
        return attributedTypeNotFoundWithId;
    }

    @Override
    public final IdentityManagementException partitionUpdateFailed(Partition partition, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000402: " + this.partitionUpdateFailed$str(), partition), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionUpdateFailed$str() {
        return partitionUpdateFailed;
    }

    public final IdentityManagementException permissionRevokeAllFailed(Object arg0, Throwable arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.permissionRevokeAllFailed$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionRevokeAllFailed$str() {
        return permissionRevokeAllFailed;
    }

    public final SecurityConfigurationException configNoIdentityConfigurationProvided() {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000704: " + this.configNoIdentityConfigurationProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configNoIdentityConfigurationProvided$str() {
        return configNoIdentityConfigurationProvided;
    }

    @Override
    public final IdentityManagementException attributedTypeRemoveFailed(AttributedType identityType, Throwable t) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000601: " + this.attributedTypeRemoveFailed$str(), identityType), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributedTypeRemoveFailed$str() {
        return attributedTypeRemoveFailed;
    }

    @Override
    public final IdentityManagementException partitionRemoveFailed(Partition partition, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000403: " + this.partitionRemoveFailed$str(), partition), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionRemoveFailed$str() {
        return partitionRemoveFailed;
    }

    @Override
    public final IdentityManagementException configJpaStoreNoPermissionEntityClassProvided() {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000801: " + this.configJpaStoreNoPermissionEntityClassProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configJpaStoreNoPermissionEntityClassProvided$str() {
        return configJpaStoreNoPermissionEntityClassProvided;
    }

    @Override
    public final IdentityManagementException partitionNoConfigurationFound(String name) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000407: " + this.partitionNoConfigurationFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNoConfigurationFound$str() {
        return partitionNoConfigurationFound;
    }

    public final IdentityManagementException credentialNoStoreForCredentials(Class arg0) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000202: " + this.credentialNoStoreForCredentials$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialNoStoreForCredentials$str() {
        return credentialNoStoreForCredentials;
    }

    public final SecurityConfigurationException configCouldNotCreateConfiguration(Exception arg0) {
        SecurityConfigurationException result = new SecurityConfigurationException(String.format("PLIDM000700: " + this.configCouldNotCreateConfiguration$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configCouldNotCreateConfiguration$str() {
        return configCouldNotCreateConfiguration;
    }

    public final IdentityManagementException credentialRetrievalFailed(Account arg0, Class arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000204: " + this.credentialRetrievalFailed$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialRetrievalFailed$str() {
        return credentialRetrievalFailed;
    }

    @Override
    public final IdentityManagementException queryUnsupportedParameterValue(String parameterName, Object parameterValue) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.queryUnsupportedParameterValue$str(), parameterName, parameterValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryUnsupportedParameterValue$str() {
        return queryUnsupportedParameterValue;
    }

    public final IdentityManagementException credentialUpdateFailed(Account arg0, Object arg1, Throwable arg2) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000201: " + this.credentialUpdateFailed$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUpdateFailed$str() {
        return credentialUpdateFailed;
    }

    public final IdentityManagementException partitionAlreadyExistsWithName(Class type, String name) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionAlreadyExistsWithName$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAlreadyExistsWithName$str() {
        return partitionAlreadyExistsWithName;
    }

    @Override
    public final IdentityManagementException partitionCouldNotCreateIdentityManager(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000405: " + this.partitionCouldNotCreateIdentityManager$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreateIdentityManager$str() {
        return partitionCouldNotCreateIdentityManager;
    }

    public final IdentityManagementException credentialUnsupportedType(Class arg0, CredentialHandler arg1) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000203: " + this.credentialUnsupportedType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialUnsupportedType$str() {
        return credentialUnsupportedType;
    }

    @Override
    public final IdentityManagementException partitionCouldNotCreatePermissionManager(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000410: " + this.partitionCouldNotCreatePermissionManager$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionCouldNotCreatePermissionManager$str() {
        return partitionCouldNotCreatePermissionManager;
    }

    @Override
    public final IdentityManagementException partitionAddFailed(Partition partition, String configurationName, Exception e) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000401: " + this.partitionAddFailed$str(), partition, configurationName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionAddFailed$str() {
        return partitionAddFailed;
    }

    @Override
    public final IdentityManagementException partitionWithNoConfigurationName(Partition partition) {
        IdentityManagementException result = new IdentityManagementException(String.format(this.partitionWithNoConfigurationName$str(), partition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionWithNoConfigurationName$str() {
        return partitionWithNoConfigurationName;
    }

    public final IdentityManagementException partitionNotFoundWithName(Class type, String name) {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000406: " + this.partitionNotFoundWithName$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String partitionNotFoundWithName$str() {
        return partitionNotFoundWithName;
    }

    @Override
    public final IdentityManagementException storeJpaCouldNotGetEntityManagerFromStoreContext() {
        IdentityManagementException result = new IdentityManagementException(String.format("PLIDM000301: " + this.storeJpaCouldNotGetEntityManagerFromStoreContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String storeJpaCouldNotGetEntityManagerFromStoreContext$str() {
        return storeJpaCouldNotGetEntityManagerFromStoreContext;
    }
}

