/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RelationshipCreatedEvent;
import org.picketlink.idm.event.RelationshipDeletedEvent;
import org.picketlink.idm.event.RelationshipUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStore;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FileIdentityQueryHelper;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FilePartitionStore;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.file.internal.FileSortingComparator;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.RelationshipAttribute;
import org.picketlink.idm.model.annotation.RelationshipIdentity;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class})
public class FileBasedIdentityStore
implements IdentityStore<FileIdentityStoreConfiguration>,
CredentialStore,
PartitionStore {
    private FileIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;
    private FileCredentialStore credentialStore;
    private FilePartitionStore partitionStore;

    public void setup(FileIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
        this.credentialStore = new FileCredentialStore(this);
        this.partitionStore = new FilePartitionStore(this);
        if (this.context.getRealm() == null) {
            Realm defaultRealm = this.getRealm("default");
            if (defaultRealm == null) {
                defaultRealm = new Realm("default");
                this.createPartition((Partition)defaultRealm);
            }
            this.context.setRealm(defaultRealm);
        }
    }

    public FileIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(AttributedType attributedType) {
        attributedType.setId(this.getContext().getIdGenerator().generate());
        if (IdentityType.class.isInstance(attributedType)) {
            try {
                Class<?> identityTypeClass = attributedType.getClass();
                if (IDMUtil.isAgentType(identityTypeClass)) {
                    Agent agent = (Agent)attributedType;
                    if (IDMUtil.isUserType(identityTypeClass)) {
                        this.addUser((User)agent);
                    }
                    this.addAgent(agent);
                }
                if (IDMUtil.isGroupType(identityTypeClass)) {
                    this.addGroup((Group)attributedType);
                }
                if (IDMUtil.isRoleType(identityTypeClass)) {
                    this.addRole((Role)attributedType);
                }
                throw this.createUnsupportedIdentityTypeException(identityTypeClass);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Exception while creating IdentityType [" + attributedType + "].", (Throwable)e);
            }
        } else if (Relationship.class.isInstance(attributedType)) {
            Relationship relationship = (Relationship)attributedType;
            try {
                this.addRelationship(relationship);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Exception while creating Relationship [" + relationship + "].", (Throwable)e);
            }
        } else {
            throw this.createUnsupportedAttributedType(attributedType.getClass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(AttributedType attributedType) {
        this.checkNotNulId(attributedType);
        if (IdentityType.class.isInstance(attributedType)) {
            Class<?> identityTypeClass = attributedType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                this.updateUser((User)attributedType);
                return;
            } else if (IDMUtil.isAgentType(identityTypeClass)) {
                this.updateAgent((Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                this.updateGroup((Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(identityTypeClass)) throw this.createUnsupportedIdentityTypeException(identityTypeClass);
                this.updateRole((Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
            this.updateRelationship((Relationship)attributedType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(AttributedType attributedType) {
        Class<?> attributedTypeClass = attributedType.getClass();
        if (IdentityType.class.isInstance(attributedType)) {
            this.checkNotNulId(attributedType);
            if (IDMUtil.isAgentType(attributedTypeClass)) {
                this.removeAgent((Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(attributedTypeClass)) {
                this.removeGroup((Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(attributedTypeClass)) throw this.createUnsupportedIdentityTypeException(attributedTypeClass);
                this.removeRole((Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedTypeClass);
            this.removeRelationship((Relationship)attributedType);
        }
    }

    public Agent getAgent(String loginName) {
        Realm realm = this.getContext().getRealm();
        Agent agent = this.getAgentsForCurrentRealm().get(loginName);
        if (agent != null) {
            this.configurePartition((IdentityType)agent);
            this.getContext().getCache().putAgent(realm, agent);
        }
        return agent;
    }

    public User getUser(String loginName) {
        Agent agent = this.getAgent(loginName);
        if (!User.class.isInstance(agent)) {
            return null;
        }
        return (User)agent;
    }

    public Role getRole(String roleName) {
        return this.lookupRole(roleName, this.getCurrentPartition());
    }

    public Group getGroup(String groupPath) {
        Group group = null;
        if (groupPath != null) {
            Group parentGroup;
            if (!groupPath.startsWith("/")) {
                groupPath = "/" + groupPath;
            }
            if ((group = this.lookupGroup(groupPath, this.getCurrentPartition())) != null && (parentGroup = group.getParentGroup()) != null) {
                group.setParentGroup(this.getGroup(parentGroup.getPath()));
            }
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        String path = "/" + name;
        if (parent != null) {
            if (parent.getId() == null) {
                throw new IdentityManagementException("No identifier specified for the parent group.");
            }
            IdentityType identityType = this.lookupIdentityTypeById(parent.getId());
            if (!Group.class.isInstance(identityType)) {
                throw new IdentityManagementException("No parent group found with the given id [" + parent.getId() + "]");
            }
            Group parentGroup = (Group)identityType;
            path = parentGroup.getPath() + path;
        }
        return this.getGroup(path);
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        return this.fetchQueryResults(query, false);
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        throw this.createNotImplementedYetException();
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        Class identityTypeClass = identityQuery.getIdentityType();
        Collection<Object> entries = new ArrayList<Object>();
        Object[] partitionParameters = identityQuery.getParameter(IdentityType.PARTITION);
        Partition partition = null;
        if (partitionParameters != null && partitionParameters.length > 0) {
            partition = (Partition)partitionParameters[0];
        }
        if (IdentityType.class.equals((Object)identityTypeClass)) {
            if (partition == null) {
                entries.addAll(this.getAgentsForCurrentRealm().values());
                entries.addAll(this.getRolesForCurrentPartition().values());
                entries.addAll(this.getGroupsForCurrentPartition().values());
            } else {
                entries.addAll(this.getAgentsForPartition(partition).values());
                entries.addAll(this.getRolesForPartition(partition).values());
                entries.addAll(this.getGroupsForPartition(partition).values());
            }
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            entries = partition == null ? this.getAgentsForCurrentRealm().values() : this.getAgentsForPartition(partition).values();
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            entries = partition == null ? this.getRolesForCurrentPartition().values() : this.getRolesForPartition(partition).values();
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            entries = partition == null ? this.getGroupsForCurrentPartition().values() : this.getGroupsForPartition(partition).values();
        } else {
            throw this.createUnsupportedIdentityTypeException(identityTypeClass);
        }
        List<IdentityType> result = new ArrayList();
        FileIdentityQueryHelper queryHelper = new FileIdentityQueryHelper(identityQuery, this);
        for (IdentityType identityType : entries) {
            Role role;
            User user;
            Agent agent;
            if (!identityTypeClass.isAssignableFrom(identityType.getClass()) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ID, (Serializable)((Object)identityType.getId())) || IDMUtil.isAgentType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Agent.LOGIN_NAME, (Serializable)((Object)(agent = (Agent)identityType).getLoginName())) || IDMUtil.isUserType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.EMAIL, (Serializable)((Object)(user = (User)identityType).getEmail())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.FIRST_NAME, (Serializable)((Object)user.getFirstName())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.LAST_NAME, (Serializable)((Object)user.getLastName())))) || IDMUtil.isRoleType(identityTypeClass) && !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Role.NAME, (Serializable)((Object)(role = (Role)identityType).getName()))) continue;
            if (IDMUtil.isGroupType(identityTypeClass)) {
                Group group = (Group)identityType;
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.NAME, (Serializable)((Object)group.getName()))) continue;
                String parentGroupName = null;
                if (group.getParentGroup() != null) {
                    parentGroupName = group.getParentGroup().getName();
                }
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.PARENT, (Serializable)((Object)parentGroupName))) continue;
            }
            if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ENABLED, Boolean.valueOf(identityType.isEnabled())) || !queryHelper.matchCreatedDateParameters(identityType) || !queryHelper.matchExpiryDateParameters(identityType) || !queryHelper.matchAttributes(identityType) || !queryHelper.matchHasRole(identityType) || !queryHelper.matchMemberOf(identityType) || !queryHelper.matchHasGroupRole(identityType) || !queryHelper.matchRolesOf(identityType) || !queryHelper.matchHasMember(identityType)) continue;
            this.configurePartition(identityType);
            result.add(identityType);
        }
        Collections.sort(result, new FileSortingComparator(identityQuery));
        if (identityQuery.getLimit() > 0) {
            int numberOfItems = Math.min(identityQuery.getLimit(), result.size() - identityQuery.getOffset());
            result = result.subList(identityQuery.getOffset(), identityQuery.getOffset() + numberOfItems);
        }
        return result;
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        this.credentialStore.storeCredential(agent, storage);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCredentials(agent, storageClass);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCurrentCredential(agent, storageClass);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        this.credentialStore.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public void validateCredentials(Credentials credentials) {
        this.credentialStore.validateCredentials(credentials);
    }

    public void createPartition(Partition partition) {
        this.partitionStore.createPartition(partition);
    }

    public Realm getRealm(String realmName) {
        return this.partitionStore.getRealm(realmName);
    }

    public Tier getTier(String tierName) {
        return this.partitionStore.getTier(tierName);
    }

    public void removePartition(Partition partition) {
        this.partitionStore.removePartition(partition);
    }

    protected <T extends Relationship> T convertToRelationship(FileRelationship fileRelationship) {
        Class<?> relationshipType = null;
        try {
            relationshipType = Class.forName(fileRelationship.getType());
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not find relationship type.");
        }
        return this.cloneRelationship(fileRelationship, relationshipType);
    }

    protected Map<String, List<FileRelationship>> getRelationshipsForCurrentPartition() {
        return this.getDataSource().getRelationships();
    }

    protected boolean hasParentGroup(Group childGroup, Group parentGroup) {
        if (childGroup.getParentGroup() != null && parentGroup != null) {
            if (childGroup.getParentGroup().getId().equals(parentGroup.getId())) {
                return true;
            }
        } else {
            return false;
        }
        return this.hasParentGroup(childGroup.getParentGroup(), parentGroup);
    }

    private <T extends Relationship> T cloneRelationship(FileRelationship fileRelationship, Class<?> relationshipType) {
        Relationship clonedRelationship = null;
        try {
            clonedRelationship = (Relationship)relationshipType.newInstance();
            Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
            clonedRelationship.setId(storedRelationship.getId());
            List relationshipIdentityTypes = PropertyQueries.createQuery(clonedRelationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipIdentity.class)).getResultList();
            for (Property annotatedProperty : relationshipIdentityTypes) {
                IdentityType identityType = this.lookupIdentityTypeById(fileRelationship.getIdentityTypeId(annotatedProperty.getName()));
                if (identityType == null) {
                    return null;
                }
                annotatedProperty.setValue((Object)clonedRelationship, (Object)identityType);
            }
            this.updateAttributedType((AttributedType)storedRelationship, (AttributedType)clonedRelationship);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not create relationship instance.", (Throwable)e);
        }
        return (T)clonedRelationship;
    }

    private Role lookupRole(Role role) throws IdentityManagementException {
        if (role.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        Role storedRole = this.getRole(role.getName());
        if (storedRole == null) {
            throw new IdentityManagementException("No Role found with the given name [" + role.getName() + "] for the current Partition [" + this.getCurrentPartition().getName() + "].");
        }
        return storedRole;
    }

    private Group lookupGroup(Group group) throws IdentityManagementException {
        if (group.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        Group storedGroup = this.getGroup(group.getPath());
        if (storedGroup == null) {
            throw new IdentityManagementException("No Group found with the given name [" + group.getName() + "] for the current Partition [" + this.getCurrentPartition().getName() + "].");
        }
        return storedGroup;
    }

    private Agent lookupAgent(Agent agent) throws IdentityManagementException {
        if (agent.getLoginName() == null) {
            throw new IdentityManagementException("No loginName was provided.");
        }
        Agent storedAgent = this.getAgent(agent.getLoginName());
        if (storedAgent == null) {
            throw new IdentityManagementException("No Agent found with the given loginName [" + agent.getLoginName() + "] for the current Partition [" + this.getContext().getRealm().getName() + "]");
        }
        return storedAgent;
    }

    private User lookupUser(User user) throws IdentityManagementException {
        if (user.getLoginName() == null) {
            throw new IdentityManagementException("No login name was provided.");
        }
        User storedUser = this.getUser(user.getLoginName());
        if (storedUser == null) {
            throw new IdentityManagementException("No User found with the given login name [" + user.getLoginName() + "] for the current Partition [" + this.getContext().getRealm().getName() + "]");
        }
        return storedUser;
    }

    private void addRole(Role role) {
        SimpleRole fileRole = new SimpleRole(role.getName());
        fileRole.setPartition(this.getCurrentPartition());
        this.updateIdentityType((IdentityType)role, (IdentityType)fileRole);
        this.storeRole((Role)fileRole);
        this.getContext().getEventBridge().raiseEvent((Object)new RoleCreatedEvent(role));
    }

    private void storeRole(Role role) {
        FilePartition filePartition = this.getDataSource().getPartition(role.getPartition().getId());
        filePartition.getRoles().put(role.getName(), new FileRole(role));
        this.getDataSource().flushRoles(filePartition);
    }

    private void addGroup(Group group) {
        SimpleGroup fileGroup = null;
        fileGroup = group.getParentGroup() != null ? new SimpleGroup(group.getName(), this.lookupGroup(group.getParentGroup())) : new SimpleGroup(group.getName());
        fileGroup.setPartition(this.getCurrentPartition());
        this.updateIdentityType((IdentityType)group, (IdentityType)fileGroup);
        this.storeGroup((Group)fileGroup);
        this.getContext().getEventBridge().raiseEvent((Object)new GroupCreatedEvent(group));
    }

    private void storeGroup(Group fileGroup) {
        FilePartition partition = this.getDataSource().getPartition(fileGroup.getPartition().getId());
        partition.getGroups().put(fileGroup.getPath(), new FileGroup(fileGroup));
        this.getDataSource().flushGroups(partition);
    }

    private void addUser(User user) {
        SimpleUser storedUser = new SimpleUser(user.getLoginName());
        storedUser.setFirstName(user.getFirstName());
        storedUser.setLastName(user.getLastName());
        storedUser.setEmail(user.getEmail());
        storedUser.setPartition((Partition)this.getContext().getRealm());
        this.updateIdentityType((IdentityType)user, (IdentityType)storedUser);
        this.storeAgent((Agent)storedUser);
        this.getContext().getEventBridge().raiseEvent((Object)new UserCreatedEvent((User)storedUser));
    }

    private void addAgent(Agent agent) {
        SimpleAgent storedAgent = new SimpleAgent(agent.getLoginName());
        storedAgent.setPartition((Partition)this.getContext().getRealm());
        this.updateIdentityType((IdentityType)agent, (IdentityType)storedAgent);
        this.storeAgent((Agent)storedAgent);
        this.getContext().getEventBridge().raiseEvent((Object)new AgentCreatedEvent((Agent)storedAgent));
    }

    private void storeAgent(Agent storedAgent) {
        FilePartition filePartition = this.getDataSource().getPartition(storedAgent.getPartition().getId());
        filePartition.getAgents().put(storedAgent.getLoginName(), new FileAgent(storedAgent));
        this.getDataSource().flushAgents(filePartition);
    }

    private void addRelationship(Relationship relationship) {
        if (relationship.getId() == null) {
            relationship.setId(this.getContext().getIdGenerator().generate());
        }
        Relationship newRelationship = null;
        try {
            newRelationship = (Relationship)relationship.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newRelationship.setId(relationship.getId());
        List relationshipIdentityTypes = PropertyQueries.createQuery(newRelationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipIdentity.class)).getResultList();
        for (Property annotatedProperty : relationshipIdentityTypes) {
            annotatedProperty.setValue((Object)newRelationship, annotatedProperty.getValue((Object)relationship));
        }
        this.updateAttributedType((AttributedType)relationship, (AttributedType)newRelationship);
        FileRelationship fileRelationship = new FileRelationship(newRelationship);
        Map<String, List<FileRelationship>> relationshipsMap = this.getDataSource().getRelationships();
        List<FileRelationship> relationships = relationshipsMap.get(newRelationship.getClass().getName());
        if (relationships == null) {
            relationships = new ArrayList<FileRelationship>();
            relationshipsMap.put(newRelationship.getClass().getName(), relationships);
        }
        relationships.add(fileRelationship);
        this.getDataSource().flushRelationships();
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipCreatedEvent(relationship));
    }

    private void updateRole(Role updatedRole) {
        Role storedRole = this.lookupRole(updatedRole);
        if (storedRole != updatedRole) {
            this.updateIdentityType((IdentityType)updatedRole, (IdentityType)storedRole);
        }
        this.storeRole(storedRole);
        this.getContext().getEventBridge().raiseEvent((Object)new RoleUpdatedEvent(updatedRole));
    }

    private void updateGroup(Group updatedGroup) {
        Group storedGroup = this.lookupGroup(updatedGroup);
        if (storedGroup != updatedGroup) {
            this.updateIdentityType((IdentityType)updatedGroup, (IdentityType)storedGroup);
        }
        this.storeGroup(storedGroup);
        this.getContext().getEventBridge().raiseEvent((Object)new GroupUpdatedEvent(updatedGroup));
    }

    private void updateUser(User updatedUser) {
        User storedUser = this.lookupUser(updatedUser);
        if (storedUser != updatedUser) {
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setEmail(updatedUser.getEmail());
            this.updateIdentityType((IdentityType)updatedUser, (IdentityType)storedUser);
        }
        this.storeAgent((Agent)storedUser);
        this.getContext().getEventBridge().raiseEvent((Object)new UserUpdatedEvent(updatedUser));
    }

    private void updateAgent(Agent updatedAgent) {
        Agent storedAgent = this.lookupAgent(updatedAgent);
        if (storedAgent != updatedAgent) {
            this.updateIdentityType((IdentityType)updatedAgent, (IdentityType)storedAgent);
        }
        this.storeAgent(storedAgent);
        this.getContext().getEventBridge().raiseEvent((Object)new AgentUpdatedEvent(updatedAgent));
    }

    private void updateRelationship(Relationship relationship) {
        List<FileRelationship> relationships = this.getDataSource().getRelationships().get(relationship.getClass().getName());
        for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
            Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            for (Object object : storedRelationship.getAttributes().toArray()) {
                Attribute attribute = (Attribute)object;
                storedRelationship.removeAttribute(attribute.getName());
            }
            for (Attribute attrib : relationship.getAttributes()) {
                storedRelationship.setAttribute(attrib);
            }
        }
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipUpdatedEvent(relationship));
    }

    private void updateIdentityType(IdentityType fromIdentityType, IdentityType toIdentityType) {
        toIdentityType.setEnabled(fromIdentityType.isEnabled());
        toIdentityType.setCreatedDate(fromIdentityType.getCreatedDate());
        toIdentityType.setExpirationDate(fromIdentityType.getExpirationDate());
        this.updateAttributedType((AttributedType)fromIdentityType, (AttributedType)toIdentityType);
        fromIdentityType.setId(toIdentityType.getId());
        fromIdentityType.setPartition(toIdentityType.getPartition());
    }

    private void updateAttributedType(AttributedType fromIdentityType, AttributedType toIdentityType) {
        toIdentityType.setId(fromIdentityType.getId());
        for (Object object : toIdentityType.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            toIdentityType.removeAttribute(attribute.getName());
        }
        List attributeProperties = PropertyQueries.createQuery(fromIdentityType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipAttribute.class)).getResultList();
        for (Property attributeProperty : attributeProperties) {
            attributeProperty.setValue((Object)toIdentityType, attributeProperty.getValue((Object)fromIdentityType));
        }
        for (Attribute attrib : fromIdentityType.getAttributes()) {
            toIdentityType.setAttribute(attrib);
        }
    }

    private Role lookupRole(String roleName, Partition partition) {
        Tier tier;
        Role role = this.getRolesForPartition(partition).get(roleName);
        if (role == null && Tier.class.isInstance(partition) && (tier = (Tier)partition).getParent() != null) {
            role = this.lookupRole(roleName, (Partition)tier.getParent());
        }
        this.configurePartition((IdentityType)role);
        return role;
    }

    private Group lookupGroup(String groupPath, Partition partition) {
        Tier tier;
        Group group = this.getGroupsForPartition(partition).get(groupPath);
        if (group == null && Tier.class.isInstance(partition) && (tier = (Tier)partition).getParent() != null) {
            group = this.lookupGroup(groupPath, (Partition)tier.getParent());
        }
        this.configurePartition((IdentityType)group);
        return group;
    }

    private void removeRelationship(Relationship relationship) {
        if (relationship.getId() == null) {
            DefaultRelationshipQuery<GroupRole> query = null;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                query = new DefaultRelationshipQuery<GroupRole>(GroupRole.class, this);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, groupRole.getAssignee());
                query.setParameter((QueryParameter)GroupRole.GROUP, groupRole.getGroup());
                query.setParameter((QueryParameter)GroupRole.ROLE, groupRole.getRole());
            } else if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                query = new DefaultRelationshipQuery<Grant>(Grant.class, this);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, grant.getAssignee());
                query.setParameter((QueryParameter)Grant.ROLE, grant.getRole());
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                query = new DefaultRelationshipQuery<GroupMembership>(GroupMembership.class, this);
                query.setParameter((QueryParameter)GroupMembership.MEMBER, groupMembership.getMember());
                query.setParameter((QueryParameter)GroupMembership.GROUP, groupMembership.getGroup());
            }
            List<GroupRole> result = this.fetchQueryResults(query, true);
            if (result.isEmpty()) {
                throw new IdentityManagementException("No relationship found to remove.");
            }
            if (result.size() > 1) {
                throw new IdentityManagementException("Ambiguos relationship found.");
            }
            relationship = (Relationship)result.get(0);
        }
        List<FileRelationship> relationships = this.getDataSource().getRelationships().get(relationship.getClass().getName());
        for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
            Relationship storedRelationship = (Relationship)fileRelationship.getEntry();
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            relationships.remove(fileRelationship);
        }
        this.getDataSource().flushRelationships();
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipDeletedEvent(relationship));
    }

    private void removeRole(Role role) {
        Role storedRole = this.lookupRole(role);
        FilePartition partition = this.getDataSource().getPartition(storedRole.getPartition().getId());
        partition.getRoles().remove(storedRole.getName());
        this.getDataSource().flushRoles(partition);
        this.removeRelationships((IdentityType)storedRole);
        this.getContext().getEventBridge().raiseEvent((Object)new RoleDeletedEvent(role));
    }

    private void removeGroup(Group group) {
        Group storedGroup = this.lookupGroup(group);
        FilePartition partition = this.getDataSource().getPartition(storedGroup.getPartition().getId());
        partition.getGroups().remove(storedGroup.getPath());
        this.getDataSource().flushGroups(partition);
        this.removeRelationships((IdentityType)storedGroup);
        this.getContext().getEventBridge().raiseEvent((Object)new GroupDeletedEvent(group));
    }

    private void removeAgent(Agent agent) {
        Agent storedAgent = this.lookupAgent(agent);
        FilePartition partition = this.getDataSource().getPartition(storedAgent.getPartition().getId());
        partition.getAgents().remove(storedAgent.getLoginName());
        this.getDataSource().flushAgents(partition);
        this.removeRelationships((IdentityType)storedAgent);
        this.credentialStore.removeCredentials(storedAgent);
        if (IDMUtil.isUserType(agent.getClass())) {
            this.getContext().getEventBridge().raiseEvent((Object)new UserDeletedEvent((User)agent));
        }
        this.getContext().getEventBridge().raiseEvent((Object)new AgentDeletedEvent(agent));
    }

    private void removeRelationships(IdentityType identityType) {
        Set<Map.Entry<String, List<FileRelationship>>> allRelationships = this.getDataSource().getRelationships().entrySet();
        for (Map.Entry<String, List<FileRelationship>> entry : allRelationships) {
            List<FileRelationship> relationships = entry.getValue();
            for (FileRelationship fileRelationship : new ArrayList<FileRelationship>(relationships)) {
                if (!fileRelationship.hasIdentityType(identityType.getId())) continue;
                relationships.remove(fileRelationship);
            }
        }
        this.getDataSource().flushRelationships();
    }

    private Map<String, Group> getGroupsForPartition(Partition partition) {
        return this.getDataSource().getGroups(partition);
    }

    private Map<String, Role> getRolesForPartition(Partition partition) {
        return this.getDataSource().getRoles(partition);
    }

    private Map<String, Agent> getAgentsForPartition(Partition partition) {
        return this.getDataSource().getAgents(partition);
    }

    private Map<String, Role> getRolesForCurrentPartition() {
        return this.getDataSource().getRoles(this.getCurrentPartition());
    }

    private Map<String, Group> getGroupsForCurrentPartition() {
        return this.getDataSource().getGroups(this.getCurrentPartition());
    }

    private Map<String, Agent> getAgentsForCurrentRealm() {
        return this.getDataSource().getAgents((Partition)this.getContext().getRealm());
    }

    private IdentityManagementException createNotImplementedYetException() {
        return new IdentityManagementException("Not implemented yet.");
    }

    private IdentityManagementException createUnsupportedIdentityTypeException(Class<? extends IdentityType> identityTypeClass) {
        return new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
    }

    private IdentityManagementException createUnsupportedAttributedType(Class<? extends AttributedType> type) {
        return new IdentityManagementException("Unsupported AttributedType [" + type.getName() + "].");
    }

    private void checkNotNulId(AttributedType attributedType) throws IdentityManagementException {
        if (attributedType.getId() == null) {
            throw new IdentityManagementException("No identifier provided.");
        }
    }

    private FileDataSource getDataSource() {
        return this.getConfig().getDataSource();
    }

    private void configurePartition(IdentityType identityType) {
        if (identityType != null && identityType.getPartition() != null) {
            Partition partition = this.partitionStore.lookupById(identityType.getPartition().getId());
            if (partition == null) {
                throw new IdentityManagementException("IdentityType is associated with a non-existent partition with id [" + identityType.getPartition().getId() + "]");
            }
            identityType.setPartition(partition);
        }
    }

    private <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query, boolean matchExactGroup) {
        ArrayList<T> result = new ArrayList<T>();
        Class relationshipType = query.getRelationshipType();
        ArrayList<FileRelationship> relationships = new ArrayList<FileRelationship>();
        if (Relationship.class.equals((Object)query.getRelationshipType())) {
            Collection<List<FileRelationship>> allRelationships = this.getRelationshipsForCurrentPartition().values();
            for (List<FileRelationship> partitionRelationships : allRelationships) {
                relationships.addAll(partitionRelationships);
            }
        } else {
            List<FileRelationship> currentRealmRelationships = this.getRelationshipsForCurrentPartition().get(relationshipType.getName());
            if (currentRealmRelationships != null) {
                relationships.addAll(currentRealmRelationships);
            }
        }
        if (relationships.isEmpty()) {
            return result;
        }
        for (FileRelationship storedRelationship : relationships) {
            boolean match = false;
            Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
            if (identityParameterValues != null && identityParameterValues.length > 0) {
                for (Object parameterValue : identityParameterValues) {
                    String identityId = null;
                    if (String.class.isInstance(parameterValue)) {
                        identityId = (String)parameterValue;
                    } else if (IdentityType.class.isInstance(parameterValue)) {
                        IdentityType identityType = (IdentityType)parameterValue;
                        identityId = identityType.getId();
                    } else {
                        throw new IdentityManagementException("Unsupported type for QueryParameter Relationship.IDENTITY. You should specify the id or a IdentityType instance.");
                    }
                    match = storedRelationship.hasIdentityType(identityId);
                }
            } else if (query.getRelationshipType().getName().equals(storedRelationship.getType())) {
                for (Map.Entry entry : query.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    Object[] values = (Object[])entry.getValue();
                    if (queryParameter instanceof RelationshipQueryParameter) {
                        RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)queryParameter;
                        match = this.matchIdentityType(storedRelationship, query, identityTypeParameter, matchExactGroup);
                    }
                    if (AttributedType.AttributeParameter.class.isInstance(queryParameter) && values != null) {
                        AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                        Attribute userAttribute = ((Relationship)storedRelationship.getEntry()).getAttribute(customParameter.getName());
                        Serializable userAttributeValue = null;
                        if (userAttribute != null) {
                            userAttributeValue = userAttribute.getValue();
                        }
                        if (userAttributeValue != null) {
                            int count = values.length;
                            for (Object value : values) {
                                if (userAttributeValue.getClass().isArray()) {
                                    Object[] userValues;
                                    for (Object object : userValues = (Object[])userAttributeValue) {
                                        if (!object.equals(value)) continue;
                                        --count;
                                    }
                                    continue;
                                }
                                if (!value.equals(userAttributeValue)) continue;
                                --count;
                            }
                            boolean bl = match = count <= 0;
                        }
                    }
                    if (match) continue;
                    break;
                }
            }
            if (!match) continue;
            result.add(this.convertToRelationship(storedRelationship));
        }
        return result;
    }

    private boolean matchIdentityType(FileRelationship storedRelationship, RelationshipQuery<?> query, RelationshipQueryParameter identityTypeParameter, boolean matchExactGroup) {
        Object[] values = query.getParameter((QueryParameter)identityTypeParameter);
        int valuesMathCount = values.length;
        IdentityType identityTypeRel = this.lookupIdentityTypeById(storedRelationship.getIdentityTypeId(identityTypeParameter.getName()));
        boolean match = false;
        if (identityTypeRel != null) {
            for (Object object : values) {
                IdentityType identityType = (IdentityType)object;
                if (!identityTypeRel.getClass().isInstance(identityType)) continue;
                if (identityTypeRel.getId().equals(identityType.getId())) {
                    --valuesMathCount;
                    continue;
                }
                if (!GroupMembership.class.isInstance(storedRelationship.getEntry()) && !GroupRole.class.isInstance(storedRelationship.getEntry()) || matchExactGroup || !Group.class.isInstance(identityTypeRel)) continue;
                Group groupParameter = (Group)identityType;
                Group groupFromRel = (Group)identityTypeRel;
                if (!groupParameter.getPath().contains(groupFromRel.getPath()) || !this.hasParentGroup(groupParameter, (Group)identityTypeRel)) continue;
                --valuesMathCount;
            }
            match = valuesMathCount <= 0;
        }
        return match;
    }

    private IdentityType lookupIdentityTypeById(String identityTypeId) {
        DefaultIdentityQuery<IdentityType> query = new DefaultIdentityQuery<IdentityType>(IdentityType.class, this);
        query.setParameter(IdentityType.ID, new Object[]{identityTypeId});
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return (IdentityType)results.get(0);
    }

    private Partition getCurrentPartition() {
        return this.getContext().getPartition();
    }
}

