/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FilePartition;
import org.picketlink.idm.file.internal.FileRelationship;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.file.internal.FileUtils;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;

public class FileDataSource {
    private static final String DEFAULT_WORKING_DIR = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "pl-idm";
    private static final String GROUPS_FILE_NAME = "pl-idm-groups.db";
    private static final String CREDENTIALS_FILE_NAME = "pl-idm-credentials.db";
    private static final String RELATIONSHIPS_FILE_NAME = "pl-idm-relationships.db";
    private static final String PARTITIONS_FILE_NAME = "pl-idm-partitions.db";
    private static final String ROLES_FILE_NAME = "pl-idm-roles.db";
    private static final String AGENTS_FILE_NAME = "pl-idm-agents.db";
    private String workingDir = DEFAULT_WORKING_DIR;
    private boolean alwaysCreateFiles = true;
    private Map<String, FilePartition> partitions = new HashMap<String, FilePartition>();
    private Map<String, List<FileRelationship>> relationships = new HashMap<String, List<FileRelationship>>();
    private boolean initialized;

    private void initWorkingDirectory() {
        String workingDir = this.getWorkingDir();
        File workingDirectoryFile = new File(workingDir);
        if (workingDirectoryFile.exists() && this.isAlwaysCreateFiles()) {
            FileUtils.delete(workingDirectoryFile);
        }
        workingDirectoryFile.mkdirs();
    }

    public void init() {
        if (!this.initialized) {
            this.initWorkingDirectory();
            File partitionsFile = FileUtils.createFileIfNotExists(new File(this.getWorkingDir() + File.separator + PARTITIONS_FILE_NAME));
            this.loadPartitions(partitionsFile);
            File relationshipsFile = FileUtils.createFileIfNotExists(new File(this.getWorkingDir() + File.separator + RELATIONSHIPS_FILE_NAME));
            this.relationships = (Map)FileUtils.readObject(relationshipsFile);
            if (this.relationships == null) {
                this.relationships = new HashMap<String, List<FileRelationship>>();
            }
            this.initialized = true;
        }
    }

    private void loadPartitions(File partitionsFile) {
        this.partitions = (Map)FileUtils.readObject(partitionsFile);
        if (this.partitions == null) {
            this.partitions = new HashMap<String, FilePartition>();
        } else {
            Set<Map.Entry<String, FilePartition>> entrySet = this.partitions.entrySet();
            for (Map.Entry<String, FilePartition> entry : entrySet) {
                this.initPartition(entry.getKey());
            }
        }
    }

    protected void initPartition(String partitionId) {
        FilePartition filePartition = this.partitions.get(partitionId);
        String agentsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + AGENTS_FILE_NAME;
        File agentsFile = FileUtils.createFileIfNotExists(new File(agentsPath));
        HashMap agents = (HashMap)FileUtils.readObject(agentsFile);
        if (agents == null) {
            agents = new HashMap();
        }
        filePartition.setAgents(agents);
        String rolesPath = this.getWorkingDir() + File.separator + partitionId + File.separator + ROLES_FILE_NAME;
        File rolesFile = FileUtils.createFileIfNotExists(new File(rolesPath));
        HashMap roles = (HashMap)FileUtils.readObject(rolesFile);
        if (roles == null) {
            roles = new HashMap();
        }
        filePartition.setRoles(roles);
        String groupsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + GROUPS_FILE_NAME;
        File groupsFile = FileUtils.createFileIfNotExists(new File(groupsPath));
        HashMap groups = (HashMap)FileUtils.readObject(groupsFile);
        if (groups == null) {
            groups = new HashMap();
        }
        filePartition.setGroups(groups);
        String credentialsPath = this.getWorkingDir() + File.separator + partitionId + File.separator + CREDENTIALS_FILE_NAME;
        File credentialsFile = FileUtils.createFileIfNotExists(new File(credentialsPath));
        HashMap credentials = (HashMap)FileUtils.readObject(credentialsFile);
        if (credentials == null) {
            credentials = new HashMap();
        }
        filePartition.setCredentials(credentials);
    }

    protected void flushAgents(FilePartition partition) {
        this.flush(partition, AGENTS_FILE_NAME, partition.getAgents());
    }

    protected void flushRoles(FilePartition partition) {
        this.flush(partition, ROLES_FILE_NAME, partition.getRoles());
    }

    protected void flushGroups(FilePartition partition) {
        this.flush(partition, GROUPS_FILE_NAME, partition.getGroups());
    }

    protected synchronized void flushPartitions() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.getWorkingDir() + File.separator + PARTITIONS_FILE_NAME));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getPartitions());
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing partitions changes to file system.", (Throwable)e);
        }
    }

    protected void flushCredentials(Realm realm) {
        FilePartition filePartition = this.getPartitions().get(realm.getId());
        this.flush(filePartition, CREDENTIALS_FILE_NAME, filePartition.getCredentials());
    }

    protected void flushRelationships() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.getWorkingDir() + File.separator + RELATIONSHIPS_FILE_NAME));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getRelationships());
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing partitions changes to file system.", (Throwable)e);
        }
    }

    private void flush(FilePartition partition, String fileName, Object object) {
        try {
            String filePath = this.getWorkingDir() + File.separator + partition.getId() + File.separator + fileName;
            FileOutputStream fos = new FileOutputStream(filePath);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.close();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error flushing changes to file system.", (Throwable)e);
        }
    }

    protected Map<String, Agent> getAgents(Partition partition) {
        Map<String, FileAgent> fileAgents = this.getPartition(partition.getId()).getAgents();
        HashMap<String, Agent> agents = new HashMap<String, Agent>();
        for (Map.Entry<String, FileAgent> fileAgent : fileAgents.entrySet()) {
            agents.put(fileAgent.getKey(), (Agent)fileAgent.getValue().getEntry());
        }
        return agents;
    }

    protected FilePartition getPartition(String id) {
        return this.partitions.get(id);
    }

    protected Map<String, Role> getRoles(Partition partition) {
        Map<String, FileRole> fileRoles = this.getPartition(partition.getId()).getRoles();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        for (Map.Entry<String, FileRole> fileRole : fileRoles.entrySet()) {
            roles.put(fileRole.getKey(), (Role)fileRole.getValue().getEntry());
        }
        return roles;
    }

    protected Map<String, List<FileRelationship>> getRelationships() {
        return this.relationships;
    }

    protected Map<String, Map<String, List<FileCredentialStorage>>> getCredentials(Realm realm) {
        return this.getPartition(realm.getId()).getCredentials();
    }

    protected Map<String, Group> getGroups(Partition partition) {
        Map<String, FileGroup> fileGroups = this.getPartition(partition.getId()).getGroups();
        HashMap<String, Group> groups = new HashMap<String, Group>();
        for (Map.Entry<String, FileGroup> fileRole : fileGroups.entrySet()) {
            groups.put(fileRole.getKey(), (Group)fileRole.getValue().getEntry());
        }
        return groups;
    }

    public Map<String, FilePartition> getPartitions() {
        return this.partitions;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isAlwaysCreateFiles() {
        return this.alwaysCreateFiles;
    }

    public void setAlwaysCreateFiles(boolean alwaysCreateFiles) {
        this.alwaysCreateFiles = alwaysCreateFiles;
    }
}

