/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.file.internal.AbstractFileEntry;
import org.picketlink.idm.file.internal.FileAgent;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileGroup;
import org.picketlink.idm.file.internal.FileRole;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Tier;

public class FilePartition
extends AbstractFileEntry<Partition> {
    private static final long serialVersionUID = 1L;
    private static final transient String FILE_PARTITION_VERSION = "1";
    private transient Map<String, FileAgent> agents = new HashMap<String, FileAgent>();
    private transient Map<String, FileRole> roles = new HashMap<String, FileRole>();
    private transient Map<String, FileGroup> groups = new HashMap<String, FileGroup>();
    private transient Map<String, Map<String, List<FileCredentialStorage>>> credentials = new HashMap<String, Map<String, List<FileCredentialStorage>>>();

    public FilePartition(Partition partition) {
        super(FILE_PARTITION_VERSION, partition);
    }

    public Map<String, FileAgent> getAgents() {
        return this.agents;
    }

    public void setAgents(Map<String, FileAgent> agents) {
        this.agents = agents;
    }

    public Map<String, FileRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, FileRole> roles) {
        this.roles = roles;
    }

    public Map<String, FileGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, FileGroup> groups) {
        this.groups = groups;
    }

    public Map<String, Map<String, List<FileCredentialStorage>>> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, Map<String, List<FileCredentialStorage>>> credentials) {
        this.credentials = credentials;
    }

    public Partition getPartition() {
        return (Partition)super.getEntry();
    }

    public String getId() {
        return this.getPartition().getId();
    }

    public String getName() {
        return this.getPartition().getName();
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        Tier tier;
        Partition partition = this.getPartition();
        properties.put("id", (Serializable)((Object)partition.getId()));
        properties.put("name", (Serializable)((Object)partition.getName()));
        if (Tier.class.isInstance(partition) && (tier = (Tier)partition).getParent() != null) {
            properties.put("parentId", (Serializable)((Object)tier.getParent().getId()));
            properties.put("parentName", (Serializable)((Object)tier.getParent().getName()));
        }
    }

    @Override
    protected Partition doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        String id = properties.get("id").toString();
        String name = properties.get("name").toString();
        Partition partition = (Partition)Class.forName(this.getType()).getConstructor(String.class).newInstance(name);
        partition.setId(id);
        partition.setName(name);
        if (Tier.class.isInstance(partition)) {
            Tier tier = (Tier)partition;
            Serializable parentName = properties.get("parentName");
            if (parentName != null) {
                Tier parentTier = new Tier(parentName.toString());
                parentTier.setId(properties.get("parentId").toString());
                tier.setParent(parentTier);
            }
        }
        return partition;
    }
}

