/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.internal.DefaultStoreFactory;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -2835518073812662628L;
    private Map<String, Set<IdentityStoreConfiguration>> realmStores = new HashMap<String, Set<IdentityStoreConfiguration>>();
    private StoreFactory storeFactory = new DefaultStoreFactory();
    private IdentityStoreInvocationContextFactory contextFactory;
    private ThreadLocal<Realm> currentRealm = new ThreadLocal();
    private ThreadLocal<Tier> currentTier = new ThreadLocal();

    public IdentityManager forRealm(Realm realm) {
        if (realm == null) {
            throw new IdentityManagementException("You can not create a contextual IdentityManager with a null Realm.");
        }
        final Realm storedRealm = this.getRealm(realm.getName());
        if (storedRealm == null) {
            throw new IdentityManagementException("You can not create a contextual IdentityManager with a null Realm.");
        }
        final DefaultIdentityManager proxied = this;
        final Tier tier = this.currentTier.get();
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                try {
                    DefaultIdentityManager.this.currentRealm.set(storedRealm);
                    DefaultIdentityManager.this.currentTier.set(tier);
                    result = method.invoke((Object)proxied, args);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
                finally {
                    DefaultIdentityManager.this.currentRealm.remove();
                    DefaultIdentityManager.this.currentTier.remove();
                }
                return result;
            }
        });
    }

    public IdentityManager forTier(Tier tier) {
        if (tier == null) {
            throw new IdentityManagementException("You can not create a contextual IdentityManager with a null Tier.");
        }
        final Tier storedTier = this.getTier(tier.getName());
        if (storedTier == null) {
            throw new IdentityManagementException("You can not create a contextual IdentityManager with a null Tier.");
        }
        final DefaultIdentityManager proxied = this;
        final Realm realm = this.currentRealm.get();
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                try {
                    DefaultIdentityManager.this.currentRealm.set(realm);
                    DefaultIdentityManager.this.currentTier.set(storedTier);
                    result = method.invoke((Object)proxied, args);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
                finally {
                    DefaultIdentityManager.this.currentRealm.remove();
                    DefaultIdentityManager.this.currentTier.remove();
                }
                return result;
            }
        });
    }

    public void bootstrap(IdentityConfiguration identityConfig, IdentityStoreInvocationContextFactory contextFactory) {
        if (identityConfig == null) {
            throw new SecurityConfigurationException("The IdentityConfiguration cannot be null.");
        }
        if (contextFactory == null) {
            throw new SecurityConfigurationException("The IdentityStoreInvocationContextFactory cannot be null.");
        }
        for (IdentityStoreConfiguration config : identityConfig.getConfiguredStores()) {
            config.init();
            HashSet<String> realms = new HashSet<String>();
            if (config.getRealms().isEmpty()) {
                realms.add("default");
            } else {
                realms.addAll(config.getRealms());
            }
            for (String realm : realms) {
                Set<Object> configs;
                if (this.realmStores.containsKey(realm)) {
                    configs = this.realmStores.get(realm);
                } else {
                    configs = new HashSet();
                    this.realmStores.put(realm, configs);
                }
                configs.add(config);
            }
        }
        this.contextFactory = contextFactory;
    }

    public void setIdentityStoreFactory(StoreFactory factory) {
        this.storeFactory = factory;
    }

    public void add(IdentityType identityType) {
        FeatureSet.FeatureGroup feature;
        if (identityType == null) {
            throw new IdentityManagementException("You can not add a null IdentityType instance.");
        }
        IdentityStoreInvocationContext ctx = this.createContext();
        Partition currentPartition = this.getCurrentPartition(ctx);
        if (Agent.class.isInstance(identityType)) {
            feature = FeatureSet.FeatureGroup.agent;
            Agent newAgent = (Agent)identityType;
            if (newAgent.getLoginName() == null) {
                throw new IdentityManagementException("No login name was provided.");
            }
            if (User.class.isInstance(newAgent)) {
                feature = FeatureSet.FeatureGroup.user;
                if (this.getUser(newAgent.getLoginName()) != null) {
                    throw new IdentityManagementException("User already exists with the given login name [" + newAgent.getLoginName() + "] for the given Partition [" + currentPartition.getName() + "]");
                }
            } else if (this.getAgent(newAgent.getLoginName()) != null) {
                throw new IdentityManagementException("Agent already exists with the given login name [" + newAgent.getLoginName() + "] for the given Realm [" + currentPartition.getName() + "]");
            }
        } else if (Group.class.isInstance(identityType)) {
            Group newGroup = (Group)identityType;
            if (newGroup.getName() == null) {
                throw new IdentityManagementException("No name was provided.");
            }
            if (this.getGroup(newGroup.getPath()) != null) {
                throw new IdentityManagementException("Group already exists with the given name [" + newGroup.getName() + "] for the given Partition [" + currentPartition.getName() + "]");
            }
            if (newGroup.getParentGroup() != null && this.lookupIdentityById(Group.class, newGroup.getParentGroup().getId()) == null) {
                throw new IdentityManagementException("No parent group found with the given id [" + newGroup.getParentGroup().getId() + "] for the given Partition [" + currentPartition.getName() + "].");
            }
            feature = FeatureSet.FeatureGroup.group;
        } else if (Role.class.isInstance(identityType)) {
            Role newRole = (Role)identityType;
            if (newRole.getName() == null) {
                throw new IdentityManagementException("No name was provided.");
            }
            if (this.getRole(newRole.getName()) != null) {
                throw new IdentityManagementException("Role already exists with the given name [" + newRole.getName() + "] for the given Partition [" + currentPartition.getName() + "]");
            }
            feature = FeatureSet.FeatureGroup.role;
        } else if (Relationship.class.isInstance(identityType)) {
            feature = FeatureSet.FeatureGroup.relationship;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType:" + identityType.getClass().getName());
        }
        this.getContextualStoreForFeature(ctx, feature, FeatureSet.FeatureOperation.create).add((AttributedType)identityType);
    }

    public void add(Relationship relationship) {
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.create, relationship.getClass()).add((AttributedType)relationship);
    }

    public void update(IdentityType identityType) {
        this.checkIfIdentityTypeExists(identityType);
        this.getContextualStoreForFeature(this.createContext(), IDMUtil.getFeatureGroup(identityType), FeatureSet.FeatureOperation.update).update((AttributedType)identityType);
    }

    public void update(Relationship relationship) {
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.update, relationship.getClass()).update((AttributedType)relationship);
    }

    public void remove(IdentityType identityType) {
        this.checkIfIdentityTypeExists(identityType);
        FeatureSet.FeatureGroup feature = IDMUtil.getFeatureGroup(identityType);
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, feature, FeatureSet.FeatureOperation.delete).remove((AttributedType)identityType);
    }

    public void remove(Relationship relationship) {
        this.checkNotNull((AttributedType)relationship);
        IdentityStoreInvocationContext ctx = this.createContext();
        this.getContextualStoreForFeature(ctx, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, relationship.getClass()).remove((AttributedType)relationship);
    }

    public Agent getAgent(String loginName) {
        return this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.agent, FeatureSet.FeatureOperation.read).getAgent(loginName);
    }

    public User getUser(String loginName) {
        return this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read).getUser(loginName);
    }

    public Group getGroup(String name) {
        if (name == null) {
            return null;
        }
        IdentityStoreInvocationContext ctx = this.createContext();
        return this.getContextualStoreForFeature(ctx, FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read).getGroup(name);
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        if (this.lookupIdentityById(Group.class, parent.getId()) == null) {
            throw new IdentityManagementException("No parent group found with the given id [" + parent.getId() + "]");
        }
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read).getGroup(name, parent);
    }

    public boolean isMember(IdentityType identityType, Group group) {
        this.checkNotNull((AttributedType)identityType);
        this.checkNotNull((AttributedType)group);
        boolean isMember = false;
        if (Agent.class.isInstance(identityType)) {
            isMember = this.getGroupMembership(identityType, group) != null;
        } else if (Group.class.isInstance(identityType)) {
            Group memberGroup = (Group)identityType;
            if (memberGroup.getId() != null && (memberGroup = this.lookupIdentityById(Group.class, memberGroup.getId())) != null) {
                isMember = memberGroup.getPath().contains(group.getPath());
            }
        } else {
            throw new IdentityManagementException("Unsupported IdentityType. Group members are only Agent or Group instances.");
        }
        return isMember;
    }

    public void addToGroup(Agent member, Group group) {
        this.checkIfIdentityTypeExists((IdentityType)member);
        this.checkIfIdentityTypeExists((IdentityType)group);
        if (this.getGroupMembership((IdentityType)member, group) == null) {
            this.add((Relationship)new GroupMembership(member, group));
        }
    }

    public void removeFromGroup(Agent member, Group group) {
        this.checkIfIdentityTypeExists((IdentityType)member);
        this.checkIfIdentityTypeExists((IdentityType)group);
        this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, GroupMembership.class).remove((AttributedType)new GroupMembership(member, group));
    }

    public Role getRole(String name) {
        return this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.read).getRole(name);
    }

    public boolean hasGroupRole(IdentityType assignee, Role role, Group group) {
        this.checkNotNull((AttributedType)assignee);
        this.checkNotNull((AttributedType)role);
        this.checkNotNull((AttributedType)group);
        return this.getGroupRole(assignee, role, group) != null;
    }

    public void grantGroupRole(IdentityType assignee, Role role, Group group) {
        this.checkIfIdentityTypeExists(assignee);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.checkIfIdentityTypeExists((IdentityType)group);
        if (this.getGroupRole(assignee, role, group) == null) {
            this.add((Relationship)new GroupRole(assignee, group, role));
        }
    }

    public void revokeGroupRole(IdentityType assignee, Role role, Group group) {
        this.checkIfIdentityTypeExists(assignee);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.checkIfIdentityTypeExists((IdentityType)group);
        this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, GroupRole.class).remove((AttributedType)new GroupRole(assignee, group, role));
    }

    public boolean hasRole(IdentityType identityType, Role role) {
        this.checkNotNull((AttributedType)identityType);
        this.checkNotNull((AttributedType)role);
        if (Role.class.isInstance(identityType)) {
            throw new IdentityManagementException("Unsupported type for the Grant relationship. Roles are granted for Agent and Group only.");
        }
        return this.getGrant(identityType, role) != null;
    }

    public void grantRole(IdentityType identityType, Role role) {
        if (Role.class.isInstance(identityType)) {
            throw new IdentityManagementException("Unsupported type for the Grant relationship. Roles are granted for Agent and Group only.");
        }
        this.checkIfIdentityTypeExists(identityType);
        this.checkIfIdentityTypeExists((IdentityType)role);
        if (this.getGrant(identityType, role) == null) {
            this.add((Relationship)new Grant(identityType, role));
        }
    }

    public void revokeRole(IdentityType identityType, Role role) {
        this.checkIfIdentityTypeExists(identityType);
        this.checkIfIdentityTypeExists((IdentityType)role);
        this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete, Grant.class).remove((AttributedType)new Grant(identityType, role));
    }

    public void validateCredentials(Credentials credentials) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.validate);
        store.validateCredentials(credentials);
    }

    public void updateCredential(Agent agent, Object value) {
        this.updateCredential(agent, value, new Date(), null);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.update);
        store.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        return new DefaultIdentityQuery<T>(identityType, this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read));
    }

    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipType) {
        return new DefaultRelationshipQuery<T>(relationshipType, this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.read, relationshipType));
    }

    public void createRealm(Realm realm) {
        this.checkCreateNullPartition((Partition)realm);
        this.checkCreateNullPartitionName((Partition)realm);
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.realm, FeatureSet.FeatureOperation.create);
        if (store != null) {
            ((PartitionStore)store).createPartition((Partition)realm);
        }
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        if (identityType == null) {
            throw new IdentityManagementException("You must provide the IdentityType class.");
        }
        if (id == null) {
            throw new IdentityManagementException("Could not lookup with a null identifier.");
        }
        IdentityQuery<T> query = this.createIdentityQuery(identityType);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw new IdentityManagementException("Ambiguous IdentityType for identifier [" + id + "].");
            }
            identity = (IdentityType)result.get(0);
        }
        return (T)identity;
    }

    public void removeRealm(Realm realm) {
        if (realm == null) {
            throw new IdentityManagementException("You must provide a non-nul Realm instance.");
        }
        if (this.getRealm(realm.getName()) == null) {
            throw new IdentityManagementException("No Realm with the given name [" + realm.getName() + "] was found.");
        }
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.realm, FeatureSet.FeatureOperation.delete);
        if (store != null) {
            ((PartitionStore)store).removePartition((Partition)realm);
        }
    }

    public Realm getRealm(String name) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.realm, FeatureSet.FeatureOperation.read);
        return store != null ? ((PartitionStore)store).getRealm(name) : null;
    }

    public void createTier(Tier tier) {
        this.checkCreateNullPartition((Partition)tier);
        this.checkCreateNullPartitionName((Partition)tier);
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.tier, FeatureSet.FeatureOperation.create);
        if (store != null) {
            ((PartitionStore)store).createPartition((Partition)tier);
        }
    }

    public void removeTier(Tier tier) {
        if (tier == null) {
            throw new IdentityManagementException("You must provide a non-nul Tier instance.");
        }
        if (this.getTier(tier.getName()) == null) {
            throw new IdentityManagementException("No Tier with the given name [" + tier.getName() + "] was found.");
        }
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.tier, FeatureSet.FeatureOperation.delete);
        if (store != null) {
            ((PartitionStore)store).removePartition((Partition)tier);
        }
    }

    public Tier getTier(String id) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), FeatureSet.FeatureGroup.tier, FeatureSet.FeatureOperation.read);
        return store != null ? ((PartitionStore)store).getTier(id) : null;
    }

    public void loadAttribute(IdentityType identityType, String attributeName) {
    }

    private GroupRole getGroupRole(IdentityType identityType, Role role, Group group) {
        RelationshipQuery<GroupRole> query = this.createRelationshipQuery(GroupRole.class);
        query.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role});
        query.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupRole groupRole = null;
        if (!result.isEmpty()) {
            groupRole = (GroupRole)result.get(0);
        }
        return groupRole;
    }

    private GroupMembership getGroupMembership(IdentityType identityType, Group group) {
        RelationshipQuery<GroupMembership> query = this.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{identityType});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
        List result = query.getResultList();
        GroupMembership groupMembership = null;
        if (!result.isEmpty()) {
            groupMembership = (GroupMembership)result.get(0);
        }
        return groupMembership;
    }

    private void checkCreateNullPartitionName(Partition partition) {
        if (partition.getName() == null) {
            throw new IdentityManagementException("Realm name must not be null");
        }
    }

    private void checkCreateNullPartition(Partition partition) {
        if (partition == null) {
            throw new IdentityManagementException("Partition must not be null.");
        }
    }

    private IdentityStore<?> getContextualStoreForFeature(IdentityStoreInvocationContext ctx, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation) {
        return this.getContextualStoreForFeature(ctx, feature, operation, null);
    }

    private IdentityStore<?> getContextualStoreForFeature(IdentityStoreInvocationContext ctx, FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation, Class<? extends Relationship> relationshipClass) {
        String realm;
        String string = realm = ctx.getRealm() != null ? ctx.getRealm().getName() : "default";
        if (!this.realmStores.containsKey(realm)) {
            if (this.realmStores.isEmpty()) {
                throw new SecurityException("No identity stores have been configured.");
            }
            throw new SecurityException("The specified realm '" + realm + "' has not been configured.");
        }
        Set<IdentityStoreConfiguration> configs = this.realmStores.get(realm);
        IdentityStoreConfiguration config = null;
        boolean supportedRelationshipClass = true;
        for (IdentityStoreConfiguration cfg : configs) {
            if (relationshipClass != null) {
                if (cfg.getFeatureSet().supportsRelationship(relationshipClass)) {
                    if (!cfg.getFeatureSet().supportsRelationshipFeature(relationshipClass, operation)) continue;
                    config = cfg;
                    break;
                }
                supportedRelationshipClass = false;
                continue;
            }
            if (!cfg.getFeatureSet().supports(feature, operation)) continue;
            config = cfg;
            break;
        }
        if (config == null) {
            if (!supportedRelationshipClass) {
                throw new SecurityConfigurationException("No identity store configuration found that supports the relationship type [" + relationshipClass.getName() + "]");
            }
            throw new SecurityConfigurationException("No identity store configuration found for requested operation [" + feature.toString() + "." + operation.toString() + "]");
        }
        IdentityStore store = this.storeFactory.createIdentityStore(config, ctx);
        this.contextFactory.initContextForStore(ctx, store);
        store.setup(config, ctx);
        return store;
    }

    private IdentityStoreInvocationContext createContext() {
        IdentityStoreInvocationContext context = this.contextFactory.createContext((IdentityManager)this);
        context.setRealm(this.currentRealm.get());
        context.setTier(this.currentTier.get());
        return context;
    }

    private void checkIfIdentityTypeExists(IdentityType identityType) {
        this.checkNotNull((AttributedType)identityType);
        if (this.lookupIdentityById(identityType.getClass(), identityType.getId()) == null) {
            throw new IdentityManagementException("No IdentityType [" + identityType.getClass().getName() + "] found with the given id [" + identityType.getId() + "]");
        }
    }

    private void checkNotNull(AttributedType relationship) {
        if (relationship == null) {
            throw new IdentityManagementException("You must provide a not null instance.");
        }
    }

    private Partition getCurrentPartition(IdentityStoreInvocationContext ctx) {
        Realm realm = ctx.getRealm();
        if (realm == null) {
            realm = new Realm("default");
        }
        Realm currentPartition = realm;
        if (ctx.getTier() != null) {
            currentPartition = ctx.getTier();
        }
        return currentPartition;
    }

    private Grant getGrant(IdentityType identityType, Role role) {
        RelationshipQuery<Grant> query = this.createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{identityType});
        query.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
        List result = query.getResultList();
        Grant grant = null;
        if (!result.isEmpty()) {
            grant = (Grant)result.get(0);
        }
        return grant;
    }
}

