/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.RelationshipAttribute;
import org.picketlink.idm.model.annotation.RelationshipIdentity;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class})
public class JPAIdentityStore
implements IdentityStore<JPAIdentityStoreConfiguration>,
CredentialStore,
PartitionStore {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    public static final String EVENT_CONTEXT_USER_ENTITY = "USER_ENTITY";
    public static final String EVENT_CONTEXT_GROUP_ENTITY = "GROUP_ENTITY";
    public static final String EVENT_CONTEXT_ROLE_ENTITY = "ROLE_ENTITY";
    private JPAIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;

    public void setup(JPAIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
        if (this.getRealm("default") == null) {
            this.createDefaultRealm();
        }
        if (this.context.getRealm() == null) {
            this.context.setRealm(this.getRealm("default"));
        }
    }

    public JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void add(AttributedType value) {
        if (value instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            IdentityType identityType = (IdentityType)value;
            try {
                IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
                Object entity = handler.createEntity(identityType, this);
                EntityManager em = this.getEntityManager();
                em.persist(entity);
                em.flush();
                this.updateIdentityTypeAttributes(identityType, entity);
                AbstractBaseEvent event = handler.raiseCreatedEvent(identityType);
                event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
            catch (Exception ex) {
                throw new IdentityManagementException("Exception while creating IdentityType [" + identityType + "].", (Throwable)ex);
            }
        }
        if (value instanceof Relationship) {
            this.checkRelationshipClassProvided();
            Relationship relationship = (Relationship)value;
            try {
                this.addRelationship(relationship);
            }
            catch (Exception ex) {
                throw new IdentityManagementException("Exception while creating Relationship [" + relationship + "].", (Throwable)ex);
            }
        }
    }

    public void createPartition(Partition partition) {
        this.checkPartitionClassProvided();
        try {
            Tier tier;
            Tier parentTier;
            Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
            Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
            Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
            Class<?> partitionClass = this.getConfig().getPartitionClass();
            Object partitionObject = null;
            try {
                partitionObject = partitionClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate Partition class [" + partitionClass.getName() + "]");
            }
            partition.setId(this.getContext().getIdGenerator().generate());
            idProperty.setValue(partitionObject, (Object)partition.getId());
            nameProperty.setValue(partitionObject, (Object)partition.getName());
            typeProperty.setValue(partitionObject, (Object)partition.getClass().getName());
            if (Tier.class.isInstance(partition) && (parentTier = (tier = (Tier)partition).getParent()) != null) {
                Property<Object> parentProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT);
                parentProperty.setValue(partitionObject, this.lookupPartitionObject((Partition)parentTier));
            }
            EntityManager em = this.getEntityManager();
            em.persist(partitionObject);
            em.flush();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating partition [" + partition + "]", (Throwable)e);
        }
    }

    public Realm getRealm(String realmName) {
        this.checkPartitionClassProvided();
        return this.convertPartitionEntityToRealm(this.lookupPartitionEntityByName(Realm.class, realmName));
    }

    public Tier getTier(String tierName) {
        this.checkPartitionClassProvided();
        return this.convertPartitionEntityToTier(this.lookupPartitionEntityByName(Tier.class, tierName));
    }

    public void removePartition(Partition partition) {
        this.checkPartitionClassProvided();
        try {
            Object partitionObject = this.lookupPartitionObject(partition);
            if (partitionObject == null) {
                throw new IdentityManagementException("No Partition found with the given id [" + partition.getId() + "].");
            }
            EntityManager entityManager = this.getEntityManager();
            List<?> associatedIdentityTypes = this.getIdentityTypesForPartition(partitionObject);
            if (!associatedIdentityTypes.isEmpty()) {
                throw new IdentityManagementException("Partition could not be removed. There are IdentityTypes associated with it. Remove them first.");
            }
            List<?> childPartitions = this.getChildPartitions(partitionObject);
            if (!childPartitions.isEmpty()) {
                throw new IdentityManagementException("Partition could not be removed. There are child partitions associated with it. Remove them first.");
            }
            entityManager.remove(partitionObject);
            entityManager.flush();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error removing partition [" + partition + "]", (Throwable)e);
        }
    }

    public void update(AttributedType attributedType) {
        if (attributedType instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            IdentityType identityType = (IdentityType)attributedType;
            try {
                Object entity = this.lookupIdentityObjectById(identityType.getId());
                if (entity == null) {
                    throw new IdentityManagementException("The specified identity object [" + identityType.getId() + "] does not exist.");
                }
                IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
                handler.populateEntity(entity, identityType, this);
                this.updateIdentityTypeAttributes(identityType, entity);
                EntityManager em = this.getEntityManager();
                em.merge(entity);
                em.flush();
                Object updatedIdentityType = this.convertToIdentityType(entity);
                this.cacheIdentityType((IdentityType)updatedIdentityType);
                AbstractBaseEvent event = handler.raiseUpdatedEvent(identityType);
                event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)identityType);
                this.getContext().getEventBridge().raiseEvent((Object)event);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating identity type [" + identityType + "]", (Throwable)e);
            }
        }
        if (attributedType instanceof Relationship) {
            this.checkRelationshipClassProvided();
            Relationship relationship = (Relationship)attributedType;
            try {
                Object entity = this.lookupRelationshipObjectById(relationship.getId());
                if (entity == null) {
                    throw new IdentityManagementException("The specified relationship object [" + relationship.getId() + "] does not exist.");
                }
                this.updateRelationshipAttributes(relationship, entity);
                EntityManager em = this.getEntityManager();
                em.merge(entity);
                em.flush();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating relationship type [" + relationship + "]", (Throwable)e);
            }
        }
    }

    public void remove(AttributedType attributedType) {
        if (attributedType instanceof IdentityType) {
            this.checkIdentityTypeClassProvided();
            try {
                this.removeIdentityType(attributedType);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error removing identity type [" + attributedType + "]", (Throwable)e);
            }
        }
        if (attributedType instanceof Relationship) {
            this.checkRelationshipClassProvided();
            Relationship relationship = (Relationship)attributedType;
            try {
                this.removeRelationship(relationship);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error removing relationship type [" + attributedType + "]", (Throwable)e);
            }
        }
    }

    public User getUser(String loginName) {
        if (loginName == null) {
            return null;
        }
        Realm realm = this.getContext().getRealm();
        User user = this.getContext().getCache().lookupUser(realm, loginName);
        if (user == null) {
            DefaultIdentityQuery<User> defaultIdentityQuery = new DefaultIdentityQuery<User>(User.class, this);
            defaultIdentityQuery.setParameter(User.LOGIN_NAME, loginName);
            List<User> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                user = resultList.get(0);
            }
        }
        return user;
    }

    public Group getGroup(String groupPath) {
        if (groupPath == null) {
            return null;
        }
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        Partition partition = this.getContext().getPartition();
        Group group = this.getContext().getCache().lookupGroup(partition, groupPath);
        if (group == null) {
            DefaultIdentityQuery<Group> defaultIdentityQuery = new DefaultIdentityQuery<Group>(Group.class, this);
            defaultIdentityQuery.setParameter(Group.PATH, groupPath);
            List<Group> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                group = resultList.get(0);
            }
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        String path = "/" + name;
        if (parent != null) {
            if (parent.getId() == null) {
                throw new IdentityManagementException("No identifier specified for the parent group.");
            }
            Object storedParent = this.lookupIdentityObjectById(parent.getId());
            if (storedParent == null) {
                throw new IdentityManagementException("No parent group found with the given identifier [" + parent.getId() + "]");
            }
            path = this.getConfig().getModelProperty(PropertyType.GROUP_PATH).getValue(storedParent) + path;
        }
        return this.getGroup(path);
    }

    public Role getRole(String name) {
        if (name == null) {
            return null;
        }
        Partition partition = this.getContext().getPartition();
        Role role = this.getContext().getCache().lookupRole(partition, name);
        if (role == null) {
            DefaultIdentityQuery<Role> defaultIdentityQuery = new DefaultIdentityQuery<Role>(Role.class, this);
            defaultIdentityQuery.setParameter(Role.NAME, name);
            List<Role> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                role = resultList.get(0);
            }
        }
        return role;
    }

    public Agent getAgent(String loginName) {
        if (loginName == null) {
            return null;
        }
        Realm partition = this.getContext().getRealm();
        Object agent = this.getContext().getCache().lookupAgent(partition, loginName);
        if (agent == null) {
            DefaultIdentityQuery<Agent> defaultIdentityQuery = new DefaultIdentityQuery<Agent>(Agent.class, this);
            defaultIdentityQuery.setParameter(Agent.LOGIN_NAME, loginName);
            List<Agent> resultList = defaultIdentityQuery.getResultList();
            agent = !resultList.isEmpty() ? resultList.get(0) : this.getUser(loginName);
        }
        return agent;
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        return this.fetchQueryResults(query, false);
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            EntityManager em = this.getEntityManager();
            JPACriteriaQueryBuilder criteriaBuilder = new JPACriteriaQueryBuilder(this, identityQuery);
            List<Predicate> predicates = criteriaBuilder.getPredicates();
            CriteriaQuery<?> criteria = criteriaBuilder.getCriteria();
            List<Order> orders = criteriaBuilder.getOrders();
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            criteria.orderBy(orders);
            TypedQuery query = em.createQuery(criteria);
            if (identityQuery.getLimit() > 0) {
                query.setMaxResults(identityQuery.getLimit());
                if (identityQuery.getOffset() > 0) {
                    query.setFirstResult(identityQuery.getOffset());
                }
            }
            List queryResult = query.getResultList();
            for (Object identity : queryResult) {
                T identityType = this.convertToIdentityType(identity);
                this.cacheIdentityType((IdentityType)identityType);
                result.add(identityType);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error executing query.", (Throwable)e);
        }
        return result;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> attribute) {
        Serializable value = attribute.getValue();
        if (value == null) {
            return;
        }
        Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME);
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY);
        Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_VALUE);
        List<?> storedAttributes = this.findIdentityTypeAttributes(identity, attribute.getName());
        if (storedAttributes.isEmpty()) {
            Object[] values = null;
            values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
            Object entity = this.lookupIdentityObjectById(identity.getId());
            try {
                for (Object attribValue : values) {
                    Object newAttribute = this.getConfig().getAttributeClass().newInstance();
                    attributeNameProperty.setValue(newAttribute, (Object)attribute.getName());
                    attributeValueProperty.setValue(newAttribute, attribValue);
                    attributeIdentityProperty.setValue(newAttribute, entity);
                    this.getEntityManager().persist(newAttribute);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
            }
        } else {
            this.removeAttribute(identity, attribute.getName());
            this.setAttribute(identity, attribute);
        }
    }

    public void removeAttribute(IdentityType identity, String name) {
        List<?> storedAttributes = this.findIdentityTypeAttributes(identity, name);
        for (Object storedAttribute : storedAttributes) {
            this.getEntityManager().remove(storedAttribute);
        }
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        List<?> attributes = this.findIdentityTypeAttributes(identityType, attributeName);
        Attribute attribute = null;
        for (Object object : attributes) {
            Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_VALUE);
            Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
            if (attribute == null) {
                attribute = new Attribute(attributeName, attribValue);
                continue;
            }
            if (attribute == null) continue;
            String[] values = null;
            values = attribute.getValue().getClass().isArray() ? (String[])attribute.getValue() : new String[]{attribute.getValue().toString()};
            String[] newValues = Arrays.copyOf(values, values.length + 1);
            newValues[newValues.length - 1] = attribValue.toString();
            attribute.setValue((Serializable)newValues);
        }
        identityType.setAttribute(attribute);
        return attribute;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById(agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List result = em.createQuery(criteria).getResultList();
        ArrayList<T> storages = new ArrayList<T>();
        for (Object object : result) {
            storages.add(this.convertToCredentialStorage(object, storageClass));
        }
        return storages;
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        this.checkCredentialClassProvided();
        return this.convertToCredentialStorage(this.retrieveLastCredentialEntity(agent, storageClass), storageClass);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        this.checkCredentialClassProvided();
        Property<Object> expiryProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE);
        Object newCredential = null;
        try {
            newCredential = this.getConfig().getCredentialClass().newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not instantiate credential class [" + this.getConfig().getCredentialClass().getName() + "].", (Throwable)e);
        }
        Date effectiveDate = storage.getEffectiveDate();
        if (effectiveDate == null) {
            effectiveDate = new Date();
        }
        Object agentInstance = this.lookupIdentityObjectById(agent.getId());
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        identityTypeProperty.setValue(newCredential, agentInstance);
        typeProperty.setValue(newCredential, (Object)storage.getClass().getName());
        effectiveProperty.setValue(newCredential, (Object)effectiveDate);
        expiryProperty.setValue(newCredential, (Object)storage.getExpiryDate());
        EntityManager em = this.getEntityManager();
        em.persist(newCredential);
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        Property<Object> attributeName = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
        Property<Object> attributeValue = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
        Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
        for (Property property : annotatedTypes) {
            Object newCredentialAttribute = null;
            try {
                newCredentialAttribute = this.getConfig().getCredentialAttributeClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate credential attribute class [" + this.getConfig().getCredentialAttributeClass().getName() + "].", (Throwable)e);
            }
            attributeName.setValue(newCredentialAttribute, (Object)property.getName());
            attributeValue.setValue(newCredentialAttribute, (Object)Base64.encodeObject((Serializable)((Serializable)property.getValue((Object)storage))));
            attributeCredential.setValue(newCredentialAttribute, newCredential);
            em.persist(newCredentialAttribute);
        }
        em.flush();
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    protected Partition convertPartitionEntityToPartition(Object partitionObject) {
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
        String type = typeProperty.getValue(partitionObject).toString();
        Realm partition = null;
        if (Realm.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToRealm(partitionObject);
        } else if (Tier.class.getName().equals(type)) {
            partition = this.convertPartitionEntityToTier(partitionObject);
        } else {
            throw new IdentityManagementException("Unsupported Partition type [" + type + "].");
        }
        return partition;
    }

    protected Realm getCurrentRealm() {
        return this.getContext().getRealm();
    }

    protected Partition getCurrentPartition() {
        return this.getContext().getPartition();
    }

    protected EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }

    protected Object lookupIdentityObjectById(String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Object> predicates = new ArrayList<Object>();
        Join join = root.join(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName());
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)id));
        List<String> partitionIds = this.getAllowedPartitionIds(this.getCurrentPartition());
        predicates.add(builder.in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.PARTITION_ID).getName())).value(partitionIds));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    protected Object lookupPartitionObject(Partition partition) {
        return this.getEntityManager().find(this.getConfig().getPartitionClass(), (Object)partition.getId());
    }

    protected List<String> getAllowedPartitionIds(Partition currentPartition) {
        ArrayList<String> partitionIds = new ArrayList<String>();
        partitionIds.add(this.getCurrentRealm().getId());
        if (currentPartition == null) {
            return partitionIds;
        }
        partitionIds.add(currentPartition.getId());
        if (Tier.class.isInstance(currentPartition)) {
            Tier tier = (Tier)currentPartition;
            partitionIds.add(currentPartition.getId());
            if (tier != null) {
                partitionIds.addAll(this.getAllowedPartitionIds((Partition)tier.getParent()));
            }
        }
        return partitionIds;
    }

    private <T extends Relationship> T convertToRelationshipType(Object relationshipObject) {
        Relationship relationshipType;
        Class<?> relationshipClass;
        Property<Object> identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID);
        Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID);
        Property<Object> descriptorProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS);
        String typeName = typeProperty.getValue(relationshipObject).toString();
        try {
            relationshipClass = Class.forName(typeName);
            relationshipType = (Relationship)relationshipClass.newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating Relationship instance for type [" + typeName + "]");
        }
        List identityTypeIdProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"id"})).getResultList();
        ((Property)identityTypeIdProperty.get(0)).setValue((Object)relationshipType, idProperty.getValue(relationshipObject));
        List<?> identities = this.findChildRelationships(relationshipType);
        for (Object object : identities) {
            String descriptor = descriptorProperty.getValue(object).toString();
            List identityTypeProperty = PropertyQueries.createQuery(relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getResultList();
            IdentityType identityType = this.getContext().getIdentityManager().lookupIdentityById(IdentityType.class, identityProperty.getValue(object).toString());
            ((Property)identityTypeProperty.get(0)).setValue((Object)relationshipType, (Object)identityType);
        }
        this.populateRelationshipAttributes(relationshipType, relationshipObject);
        return (T)relationshipType;
    }

    private <T extends IdentityType> T convertToIdentityType(Object entity) {
        String discriminator = this.getConfig().getModelProperty(PropertyType.IDENTITY_DISCRIMINATOR).getValue(entity).toString();
        IdentityTypeHandler<? extends IdentityType> identityTypeManager = this.getConfig().getIdentityTypeStores().get(discriminator);
        IdentityType identityType = identityTypeManager.createIdentityType(entity, this);
        this.populateIdentityTypeAttributes(identityType);
        return (T)identityType;
    }

    private void storeRelationshipAttribute(Object identity, Attribute<? extends Serializable> userAttribute) {
        Serializable value = userAttribute.getValue();
        Object[] values = null;
        values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP);
        Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
        try {
            for (Object attribValue : values) {
                Object newInstance = this.getConfig().getRelationshipAttributeClass().newInstance();
                attributeNameProperty.setValue(newInstance, (Object)userAttribute.getName());
                attributeValueProperty.setValue(newInstance, attribValue);
                attributeIdentityProperty.setValue(newInstance, identity);
                this.getEntityManager().persist(newInstance);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
        }
    }

    private void removeAttributes(Relationship relationship, Object identity) {
        List<?> storedAttributes = this.findRelationshipAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getValue(attribute).toString();
            if (relationship.getAttribute(attributeName) != null) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private void removeAttributes(IdentityType identityType, Object identity) {
        List<?> storedAttributes = this.findAllIdentityTypeAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME).getValue(attribute).toString();
            if (identityType.getAttribute(attributeName) != null) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private List<?> findIdentityTypeAttributes(IdentityType identityType, String name) {
        if (identityType.getId() == null) {
            throw new IdentityManagementException("No identifier provided for IdentityType.");
        }
        Object entity = this.lookupIdentityObjectById(identityType.getId());
        if (entity == null) {
            throw new IdentityManagementException("No IdentityType found with the tiven identifier [" + identityType.getId() + "]");
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY);
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)identityType.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME).getName()), (Object)name));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(Relationship relationship, Attribute<? extends Serializable> attribute) {
        Property<Object> attributeIdentityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipAttributeClass());
        Root root = criteria.from(this.getConfig().getRelationshipAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(attributeIdentityProperty.getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)attribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findAllIdentityTypeAttributes(Object object) {
        Class<?> attributeClass = this.getConfig().getAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_IDENTITY).getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findRelationshipAttributes(Object object) {
        Class<?> attributeClass = this.getConfig().getRelationshipAttributeClass();
        String identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(attributeClass);
        Root root = criteria.from(attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityProperty), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private Object lookupRelationshipObjectById(String id) {
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
        Root root = criteria.from(this.getConfig().getRelationshipClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)id));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private void removeIdentityTypeRelationships(Object entity) {
        if (this.getConfig().getRelationshipClass() != null) {
            List<?> relationshipsToRemove = this.findIdentityTypeRelationships(this.getConfig().getModelPropertyValue(String.class, entity, PropertyType.IDENTITY_ID));
            for (Object relationship : relationshipsToRemove) {
                this.remove((AttributedType)this.convertToRelationshipType(relationship));
            }
        }
    }

    private List<?> findIdentityTypeRelationships(String identityTypeId) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        criteria.where((Expression)builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).getName()), (Object)identityTypeId));
        ArrayList<Object> relationships = new ArrayList<Object>();
        List result = em.createQuery(criteria).getResultList();
        for (Object object : result) {
            relationships.add(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getValue(object));
        }
        return relationships;
    }

    private void removeIdentityTypeAttributes(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getAttributeClass() != null) {
            List<?> results = this.findAllIdentityTypeAttributes(object);
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void updateIdentityTypeAttributes(IdentityType identityType, Object entity) {
        if (this.getConfig().getFeatureSet().supports(FeatureSet.FeatureGroup.attribute)) {
            Collection attributes = identityType.getAttributes();
            if (attributes != null) {
                for (Attribute attribute : attributes) {
                    this.setAttribute(identityType, (Attribute<? extends Serializable>)attribute);
                }
            }
            this.removeAttributes(identityType, entity);
        }
    }

    private void updateRelationshipAttributes(Relationship relationship, Object identity) {
        List attributeProperties = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipAttribute.class)).getResultList();
        for (Property attributeProperty : attributeProperties) {
            relationship.setAttribute(new Attribute(attributeProperty.getName(), (Serializable)attributeProperty.getValue((Object)relationship)));
        }
        Collection attributes = relationship.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            EntityManager em = this.getEntityManager();
            for (Attribute attribute : attributes) {
                try {
                    List<?> results = this.findRelationshipAttributes(relationship, (Attribute<? extends Serializable>)attribute);
                    for (Object object : results) {
                        em.remove(object);
                    }
                    this.storeRelationshipAttribute(identity, (Attribute<? extends Serializable>)attribute);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Error setting attribute [" + attribute + "] for [" + identity + "]", (Throwable)e);
                }
            }
            this.removeAttributes(relationship, identity);
        }
    }

    private void populateIdentityTypeAttributes(IdentityType identityType) {
        Object entity = this.lookupIdentityObjectById(identityType.getId());
        if (entity == null) {
            throw new IdentityManagementException("No IdentityType found with the tiven identifier [" + identityType.getId() + "]");
        }
        try {
            for (JPAIdentityStoreConfiguration.MappedAttribute attrib : this.getConfig().getAttributeProperties().values()) {
                if (attrib.getIdentityProperty() != null && attrib.getIdentityProperty().getValue(entity) == null) continue;
                Member member = attrib.getAttributeProperty().getMember();
                String mappedName = null;
                Object value = null;
                if (member instanceof Field) {
                    Field field = (Field)member;
                    IDMAttribute annotation = field.getAnnotation(IDMAttribute.class);
                    field.setAccessible(true);
                    mappedName = annotation.name();
                    value = field.get(entity);
                }
                identityType.setAttribute(new Attribute(mappedName, (Serializable)value));
            }
            if (this.getConfig().getAttributeClass() != null) {
                for (JPAIdentityStoreConfiguration.MappedAttribute object : this.findAllIdentityTypeAttributes(entity)) {
                    Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.ATTRIBUTE_NAME);
                    String attribName = (String)attributeNameProperty.getValue((Object)object);
                    identityType.setAttribute(this.getAttribute(identityType, attribName));
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    private void populateRelationshipAttributes(Relationship relationshipType, Object relationship) {
        try {
            List<?> results;
            if (this.getConfig().getRelationshipAttributeClass() != null && !(results = this.findRelationshipAttributes(relationship)).isEmpty()) {
                for (Object object : results) {
                    Property<Object> attributeNameProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME);
                    Property<Object> attributeValueProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE);
                    String attribName = (String)attributeNameProperty.getValue(object);
                    Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
                    List attributeProperties = PropertyQueries.createQuery(relationshipType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipAttribute.class)).getResultList();
                    Property relationshipAttributeProperty = null;
                    for (Property attributeProperty : attributeProperties) {
                        String propertyName = attributeProperty.getName();
                        if (!propertyName.equals(attribName)) continue;
                        relationshipAttributeProperty = attributeProperty;
                        break;
                    }
                    if (relationshipAttributeProperty != null) {
                        relationshipAttributeProperty.setValue((Object)relationshipType, (Object)attribValue);
                        continue;
                    }
                    Attribute identityTypeAttribute = relationshipType.getAttribute(attribName);
                    if (identityTypeAttribute == null) {
                        identityTypeAttribute = new Attribute(attribName, attribValue);
                        relationshipType.setAttribute(identityTypeAttribute);
                        continue;
                    }
                    if (identityTypeAttribute.getValue() == null) continue;
                    String[] values = null;
                    values = identityTypeAttribute.getValue().getClass().isArray() ? (String[])identityTypeAttribute.getValue() : new String[]{identityTypeAttribute.getValue().toString()};
                    String[] newValues = Arrays.copyOf(values, values.length + 1);
                    newValues[newValues.length - 1] = attribValue.toString();
                    identityTypeAttribute.setValue((Serializable)newValues);
                    relationshipType.setAttribute(identityTypeAttribute);
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    private void addRelationship(Relationship relationship) {
        relationship.setId(this.getContext().getIdGenerator().generate());
        Object entity = null;
        try {
            entity = this.getConfig().getRelationshipClass().newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error instantiating relationship class [" + this.getConfig().getRelationshipClass().getName() + "]", (Throwable)e);
        }
        this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).setValue(entity, (Object)relationship.getId());
        this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS).setValue(entity, (Object)relationship.getClass().getName());
        List props = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipIdentity.class)).getResultList();
        EntityManager em = this.getEntityManager();
        em.persist(entity);
        for (Property prop : props) {
            Object relationshipIdentity = null;
            try {
                relationshipIdentity = this.getConfig().getRelationshipIdentityClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error instantiating relationship identity class [" + this.getConfig().getRelationshipIdentityClass().getName() + "]", (Throwable)e);
            }
            IdentityType identityType = (IdentityType)prop.getValue((Object)relationship);
            if (identityType != null) {
                Object identityObject = this.lookupIdentityObjectById(identityType.getId());
                if (identityObject != null) {
                    this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY).setValue(relationshipIdentity, identityObject);
                }
                this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).setValue(relationshipIdentity, (Object)identityType.getId());
                this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).setValue(relationshipIdentity, (Object)prop.getName());
                this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).setValue(relationshipIdentity, entity);
            }
            em.persist(relationshipIdentity);
        }
        this.updateRelationshipAttributes(relationship, entity);
    }

    private void removeIdentityType(AttributedType value) {
        IdentityType identityType = (IdentityType)value;
        Object entity = this.lookupIdentityObjectById(identityType.getId());
        EntityManager em = this.getEntityManager();
        IdentityTypeHandler<IdentityType> handler = this.getConfig().getHandler(identityType.getClass());
        handler.remove(entity, identityType, this);
        this.removeCredentials(entity);
        this.removeIdentityTypeAttributes(entity);
        this.removeIdentityTypeRelationships(entity);
        em.remove(entity);
        em.flush();
        IdentityType removedIdentityType = handler.createIdentityType(entity, this);
        this.invalidateCache(removedIdentityType);
        AbstractBaseEvent event = handler.raiseDeletedEvent(identityType);
        event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, entity);
        this.getContext().getEventBridge().raiseEvent((Object)event);
    }

    private void removeRelationship(Relationship relationship) {
        EntityManager em;
        Object entity;
        if (relationship.getId() == null) {
            DefaultRelationshipQuery<GroupRole> query = null;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                query = new DefaultRelationshipQuery<GroupRole>(GroupRole.class, this);
                query.setParameter((QueryParameter)GroupRole.ASSIGNEE, groupRole.getAssignee());
                query.setParameter((QueryParameter)GroupRole.GROUP, groupRole.getGroup());
                query.setParameter((QueryParameter)GroupRole.ROLE, groupRole.getRole());
            } else if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                query = new DefaultRelationshipQuery<Grant>(Grant.class, this);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, grant.getAssignee());
                query.setParameter((QueryParameter)Grant.ROLE, grant.getRole());
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                query = new DefaultRelationshipQuery<GroupMembership>(GroupMembership.class, this);
                query.setParameter((QueryParameter)GroupMembership.MEMBER, groupMembership.getMember());
                query.setParameter((QueryParameter)GroupMembership.GROUP, groupMembership.getGroup());
            }
            List<GroupRole> result = this.fetchQueryResults(query, true);
            if (result.size() == 1) {
                relationship = (Relationship)result.get(0);
            } else if (result.size() > 1) {
                throw new IdentityManagementException("Ambiguous relationship found.");
            }
        }
        if ((entity = this.lookupRelationshipObjectById(relationship.getId())) != null) {
            Object[] attributes;
            List<?> childRelationships = this.findChildRelationships(relationship);
            em = this.getEntityManager();
            for (Object object : childRelationships) {
                em.remove(object);
            }
            for (Object object : attributes = relationship.getAttributes().toArray()) {
                Attribute attribute = (Attribute)object;
                relationship.removeAttribute(attribute.getName());
            }
        } else {
            throw new IdentityManagementException("No relationship found to remove.");
        }
        this.removeAttributes(relationship, entity);
        em.remove(entity);
        em.flush();
    }

    private List<?> findChildRelationships(Relationship relationship) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipIdentityClass());
        Root root = criteria.from(this.getConfig().getRelationshipIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName()), (Object)relationship.getId()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query, boolean matchExactGroup) {
        ArrayList<T> result = new ArrayList<T>();
        EntityManager em = this.getEntityManager();
        List<Object> queryResult = new ArrayList();
        Object[] identityParameterValues = query.getParameter(Relationship.IDENTITY);
        if (identityParameterValues != null) {
            for (Object parameterValue : identityParameterValues) {
                String identityId = null;
                if (String.class.isInstance(parameterValue)) {
                    identityId = (String)parameterValue;
                } else if (IdentityType.class.isInstance(parameterValue)) {
                    IdentityType identityType = (IdentityType)parameterValue;
                    identityId = identityType.getId();
                } else {
                    throw new IdentityManagementException("Unsupported type for QueryParameter Relationship.IDENTITY. You should specify the id or a IdentityType instance.");
                }
                queryResult = this.findIdentityTypeRelationships(identityId);
            }
        } else {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getRelationshipClass());
            Root root = criteria.from(this.getConfig().getRelationshipClass());
            ArrayList<Object> predicates = new ArrayList<Object>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_CLASS).getName()), (Object)query.getRelationshipType().getName()));
            Property<Object> identityProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID);
            Property<Object> descriptorProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR);
            Property<Object> relationshipProperty = this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP);
            Set parameters = query.getParameters().entrySet();
            for (Map.Entry entry : parameters) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] values = (Object[])entry.getValue();
                if (entry.getKey() instanceof RelationshipQueryParameter) {
                    RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                    for (Object object : values) {
                        ArrayList<String> objects;
                        IdentityType identityType = (IdentityType)object;
                        identityType = this.getContext().getIdentityManager().lookupIdentityById(identityType.getClass(), identityType.getId());
                        if (identityType != null) {
                            objects = new ArrayList<String>();
                            objects.add(identityType.getId());
                            if (Group.class.isInstance(identityType) && !matchExactGroup) {
                                List<Group> groupParents = this.getParentGroups((Group)identityType);
                                for (Group group : groupParents) {
                                    objects.add(group.getId());
                                }
                            }
                        } else {
                            return result;
                        }
                        Subquery subquery = criteria.subquery(this.getConfig().getRelationshipIdentityClass());
                        Root fromProject = subquery.from(this.getConfig().getRelationshipIdentityClass());
                        subquery.select((Expression)fromProject.get(relationshipProperty.getName()));
                        Predicate conjunction = builder.conjunction();
                        conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(descriptorProperty.getName()), (Object)identityTypeParameter.getName()));
                        conjunction.getExpressions().add(builder.in((Expression)fromProject.get(identityProperty.getName())).value(objects));
                        subquery.where((Expression)conjunction);
                        predicates.add(builder.in((Expression)root).value((Expression)subquery));
                    }
                }
                if (!(queryParameter instanceof AttributedType.AttributeParameter)) continue;
                AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                Subquery subquery = criteria.subquery(this.getConfig().getRelationshipAttributeClass());
                Root fromProject = subquery.from(this.getConfig().getRelationshipAttributeClass());
                subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_RELATIONSHIP).getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_NAME).getName()), (Object)customParameter.getName()));
                conjunction.getExpressions().add(fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ATTRIBUTE_VALUE).getName()).in(values));
                subquery.where((Expression)conjunction);
                subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)builder.equal(builder.count(subquery.getSelection()), (Object)values.length));
                predicates.add(builder.in((Expression)root).value((Expression)subquery));
            }
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            queryResult = em.createQuery(criteria).getResultList();
        }
        for (Object relationshipObject : queryResult) {
            result.add(this.convertToRelationshipType(relationshipObject));
        }
        return result;
    }

    private List<Group> getParentGroups(Group identityType) {
        IdentityQuery query = this.getContext().getIdentityManager().createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{identityType});
        return query.getResultList();
    }

    private void createDefaultRealm() {
        this.createPartition((Partition)new Realm("default"));
    }

    private Realm convertPartitionEntityToRealm(Object partitionObject) {
        Realm realm = null;
        if (partitionObject != null) {
            Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
            if (Realm.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
                Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
                realm = new Realm(nameProperty.getValue(partitionObject).toString());
                realm.setId(idProperty.getValue(partitionObject).toString());
            }
        }
        return realm;
    }

    private Object lookupPartitionEntityByName(Class<? extends Partition> partitionType, String name) {
        if (name == null) {
            throw new IdentityManagementException("Partition name was not provided.");
        }
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        Class<?> partitionClass = this.getConfig().getPartitionClass();
        CriteriaQuery criteria = builder.createQuery(partitionClass);
        Root root = criteria.from(partitionClass);
        Predicate whereType = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE).getName()), (Object)partitionType.getName());
        Predicate whereName = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_NAME).getName()), (Object)name);
        criteria.where(new Predicate[]{whereName, whereType});
        Object partitionObject = null;
        try {
            partitionObject = entityManager.createQuery(criteria).getSingleResult();
        }
        catch (NonUniqueResultException nuoe) {
            throw new IdentityManagementException("Abiguous Tier found with the given name [" + name + "]");
        }
        catch (NoResultException ignore) {
            // empty catch block
        }
        return partitionObject;
    }

    private List<?> getChildPartitions(Object partitionObject) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getPartitionClass());
        Root root = criteria.from(this.getConfig().getPartitionClass());
        Predicate wherePartition = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT).getName()), partitionObject);
        criteria.where((Expression)wherePartition);
        return entityManager.createQuery(criteria).getResultList();
    }

    private List<?> getIdentityTypesForPartition(Object partitionObject) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        Predicate wherePartition = builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.IDENTITY_PARTITION).getName()), partitionObject);
        criteria.where((Expression)wherePartition);
        return entityManager.createQuery(criteria).getResultList();
    }

    private Tier convertPartitionEntityToTier(Object partitionObject) {
        Tier tier = null;
        if (partitionObject != null) {
            Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_TYPE);
            if (Tier.class.getName().equals(typeProperty.getValue(partitionObject).toString())) {
                Property<Object> idProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_ID);
                Property<Object> nameProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_NAME);
                Property<Object> parentProperty = this.getConfig().getModelProperty(PropertyType.PARTITION_PARENT);
                Object parentTierObject = parentProperty.getValue(partitionObject);
                tier = parentTierObject != null ? new Tier(nameProperty.getValue(partitionObject).toString(), this.convertPartitionEntityToTier(parentTierObject)) : new Tier(nameProperty.getValue(partitionObject).toString());
                tier.setId(idProperty.getValue(partitionObject).toString());
            }
        }
        return tier;
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Object instance, Class<T> storageClass) {
        CredentialStorage storage = null;
        if (instance != null) {
            try {
                storage = (CredentialStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not instantiate storage class [" + storageClass.getName() + "].", (Throwable)e);
            }
            Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
            Property<Object> expiryProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EXPIRY_DATE);
            List effectiveDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"effectiveDate"})).getResultList();
            ((Property)effectiveDateProperty.get(0)).setValue((Object)storage, effectiveProperty.getValue(instance));
            List expiryDateProperty = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"expiryDate"})).getResultList();
            ((Property)expiryDateProperty.get(0)).setValue((Object)storage, expiryProperty.getValue(instance));
            EntityManager em = this.getEntityManager();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
            Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
            ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
            Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
            attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), instance));
            attributeCriteria.where(attributePredicates.toArray(new Predicate[attributePredicates.size()]));
            List attributes = em.createQuery(attributeCriteria).getResultList();
            Property<Object> attributeName = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_NAME);
            Property<Object> attributeValue = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_VALUE);
            for (Object attribute : attributes) {
                String name = attributeName.getValue(attribute).toString();
                String value = attributeValue.getValue(attribute).toString();
                List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{name})).getResultList();
                if (annotatedTypes.isEmpty()) {
                    throw new IdentityManagementException("Could not find property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                if (annotatedTypes.size() > 1) {
                    throw new IdentityManagementException("Ambiguos property [" + attributeName.getName() + "] on CredentialStorage [" + storageClass.getName() + "].");
                }
                Property property = (Property)annotatedTypes.get(0);
                property.setValue((Object)storage, Base64.decodeToObject((String)value));
            }
        }
        return (T)storage;
    }

    private <T> Object retrieveLastCredentialEntity(Agent agent, Class<T> storageClass) {
        Property<Object> identityTypeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY);
        Property<Object> typeProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_TYPE);
        Property<Object> effectiveProperty = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_EFFECTIVE_DATE);
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
        Root root = criteria.from(this.getConfig().getCredentialClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object agentInstance = this.lookupIdentityObjectById(agent.getId());
        predicates.add(builder.equal((Expression)root.get(identityTypeProperty.getName()), agentInstance));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), (Object)storageClass.getName()));
        Predicate conjunction = builder.conjunction();
        conjunction.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get(effectiveProperty.getName()), (Comparable)new Date()));
        predicates.add(conjunction);
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get(effectiveProperty.getName()))});
        Object lastCredential = null;
        try {
            List result = em.createQuery(criteria).getResultList();
            if (!result.isEmpty()) {
                lastCredential = result.get(0);
            }
        }
        catch (NoResultException ignore) {
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not query credentials.", (Throwable)e);
        }
        return lastCredential;
    }

    private void checkCredentialClassProvided() {
        if (this.getConfig().getCredentialClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store credentials.");
        }
    }

    private void checkIdentityTypeClassProvided() {
        if (this.getConfig().getIdentityClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store identity types.");
        }
    }

    private void checkPartitionClassProvided() {
        if (this.getConfig().getPartitionClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store partitions.");
        }
    }

    private void checkRelationshipClassProvided() {
        if (this.getConfig().getRelationshipClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships.");
        }
        if (this.getConfig().getRelationshipIdentityClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships identity types.");
        }
        if (this.getConfig().getRelationshipAttributeClass() == null) {
            throw new IdentityManagementException("No class Entity class provided to store relationships attributes.");
        }
    }

    private void removeCredentials(Object object) {
        if (this.getConfig().getCredentialClass() != null) {
            EntityManager em = this.getEntityManager();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
            Root root = criteria.from(this.getConfig().getCredentialClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty(PropertyType.CREDENTIAL_IDENTITY).getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object credential : results) {
                CriteriaQuery attributeCriteria = builder.createQuery(this.getConfig().getCredentialAttributeClass());
                Root attributeRoot = attributeCriteria.from(this.getConfig().getCredentialAttributeClass());
                ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
                Property<Object> attributeCredential = this.getConfig().getModelProperty(PropertyType.CREDENTIAL_ATTRIBUTE_CREDENTIAL);
                attributePredicates.add(builder.equal((Expression)attributeRoot.get(attributeCredential.getName()), credential));
                List attributes = em.createQuery(attributeCriteria).getResultList();
                for (Object attribute : attributes) {
                    em.remove(attribute);
                }
                em.remove(credential);
            }
        }
    }

    private void cacheIdentityType(IdentityType updatedIdentityType) {
        if (User.class.isInstance(updatedIdentityType)) {
            this.getContext().getCache().putUser((Realm)updatedIdentityType.getPartition(), (User)updatedIdentityType);
        } else if (Agent.class.isInstance(updatedIdentityType)) {
            this.getContext().getCache().putAgent((Realm)updatedIdentityType.getPartition(), (Agent)updatedIdentityType);
        } else if (Role.class.isInstance(updatedIdentityType)) {
            this.getContext().getCache().putRole(updatedIdentityType.getPartition(), (Role)updatedIdentityType);
        } else if (Group.class.isInstance(updatedIdentityType)) {
            this.getContext().getCache().putGroup(updatedIdentityType.getPartition(), (Group)updatedIdentityType);
        }
    }

    private void invalidateCache(IdentityType identityType) {
        if (Agent.class.isInstance(identityType)) {
            this.getContext().getCache().invalidate((Partition)this.getContext().getRealm(), identityType);
        } else {
            this.getContext().getCache().invalidate(this.getContext().getPartition(), identityType);
        }
    }
}

