/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;

public class RoleHandler
extends IdentityTypeHandler<Role> {
    public RoleHandler(JPAIdentityStoreConfiguration config) {
        super(config);
        this.getSortParametersMapping().put(Role.NAME, PropertyType.IDENTITY_NAME);
    }

    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Role fromRole, JPAIdentityStore store) {
        this.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_PARTITION, store.lookupPartitionObject(store.getCurrentPartition()), true);
        this.setModelPropertyValue(toIdentity, PropertyType.IDENTITY_NAME, fromRole.getName(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Role fromIdentityType) {
        return new RoleCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Role fromIdentityType) {
        return new RoleUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Role fromIdentityType) {
        return new RoleDeletedEvent(fromIdentityType);
    }

    @Override
    protected Role doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String name = this.getConfig().getModelPropertyValue(String.class, identity, PropertyType.IDENTITY_NAME);
        SimpleRole role = new SimpleRole(name);
        return role;
    }

    @Override
    public List<Predicate> getPredicate(JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(criteria, store);
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(Role.NAME);
        if (parameterValues != null) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(Role.ROLE_OF)) != null) {
            for (Object object : parameterValues) {
                DefaultRelationshipQuery<Grant> query = new DefaultRelationshipQuery<Grant>(Grant.class, store);
                query.setParameter((QueryParameter)Grant.ASSIGNEE, object);
                List<Grant> resultList = query.getResultList();
                if (!resultList.isEmpty()) {
                    ArrayList<String> relIds = new ArrayList<String>();
                    for (Grant grant : resultList) {
                        relIds.add(grant.getId());
                    }
                    Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getRelationshipIdentityClass());
                    Root fromProject = subquery.from(store.getConfig().getRelationshipIdentityClass());
                    subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).getName()));
                    Join join = fromProject.join(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_RELATIONSHIP).getName());
                    ArrayList<Object> subqueryPredicates = new ArrayList<Object>();
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_DESCRIPTOR).getName()), (Object)Grant.ROLE.getName()));
                    subqueryPredicates.add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_IDENTITY_ID).getName()), (Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName())));
                    subqueryPredicates.add(criteria.getBuilder().in((Expression)join.get(this.getConfig().getModelProperty(PropertyType.RELATIONSHIP_ID).getName())).value(relIds));
                    subquery.where(subqueryPredicates.toArray(new Predicate[subqueryPredicates.size()]));
                    predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
                    continue;
                }
                predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.IDENTITY_ID).getName()), (Object)"-1"));
            }
        }
        return predicates;
    }
}

