/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;

public abstract class LDAPAttributedType
extends LDAPEntry
implements AttributedType {
    private static final long serialVersionUID = 7193133057734386770L;
    private LDAPCustomAttributes customAttributes;
    private String id;

    public LDAPAttributedType(String dnSuffix) {
        super(dnSuffix);
        this.customAttributes = new LDAPCustomAttributes(dnSuffix);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setAttribute(Attribute<? extends Serializable> attribute) {
        this.getCustomAttributes().addAttribute(attribute.getName(), attribute.getValue());
    }

    public void removeAttribute(String name) {
        this.getCustomAttributes().removeAttribute(name);
    }

    public <T extends Serializable> Attribute<T> getAttribute(String name) {
        Attribute attribute = null;
        if (this.getCustomAttributes().getAttributes().containsKey(name)) {
            Serializable value = (Serializable)this.getCustomAttributes().getAttribute(name);
            attribute = new Attribute(name, value);
        }
        return attribute;
    }

    public Collection<Attribute<? extends Serializable>> getAttributes() {
        ArrayList<Attribute<? extends Serializable>> attribs = new ArrayList<Attribute<? extends Serializable>>();
        Map<String, Serializable> customAttributes = this.getCustomAttributes().getAttributes();
        Set<Map.Entry<String, Serializable>> entrySet = customAttributes.entrySet();
        for (Map.Entry<String, Serializable> entry : entrySet) {
            attribs.add((Attribute<? extends Serializable>)new Attribute(entry.getKey(), entry.getValue()));
        }
        return attribs;
    }

    public LDAPCustomAttributes getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(LDAPCustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
    }
}

