/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.LDAPAgent;
import org.picketlink.idm.ldap.internal.LDAPConstants;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPIdentityType;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;

public class LDAPGroupRole
extends LDAPIdentityType {
    private static final long serialVersionUID = 1L;
    private LDAPAgent agent;
    private LDAPGroup group;
    private LDAPRole role;

    public LDAPGroupRole(LDAPAgent agent, LDAPGroup group, LDAPRole role) {
        super(agent.getDN());
        this.agent = agent;
        this.group = group;
        this.role = role;
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add(LDAPConstants.GROUP_OF_NAMES);
        this.getLDAPAttributes().put(oc);
        this.getLDAPAttributes().put("member", this.role.getDN());
        Attribute theAttribute = this.getLDAPAttributes().get("cn");
        if (theAttribute == null) {
            this.getLDAPAttributes().put("cn", this.group.getName());
        } else {
            theAttribute.set(0, this.group.getName());
        }
    }

    @Override
    public String getDN() {
        return "cn=" + this.group.getName() + "," + this.agent.getDN();
    }

    public IdentityType getMember() {
        return this.agent;
    }

    public Group getGroup() {
        return this.group;
    }

    public Role getRole() {
        return this.role;
    }
}

