/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.ldap.internal.LDAPAgent;
import org.picketlink.idm.ldap.internal.LDAPAttributedType;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPGroupRole;
import org.picketlink.idm.ldap.internal.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPIdentityType;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPQuery;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
implements IdentityStore<LDAPIdentityStoreConfiguration> {
    private LDAPIdentityStoreConfiguration configuration;
    private IdentityStoreInvocationContext context;

    public void setup(LDAPIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.configuration = config;
        this.context = context;
        if (this.context.getRealm() == null) {
            this.context.setRealm(new Realm("default"));
        }
    }

    public LDAPIdentityStoreConfiguration getConfig() {
        return this.configuration;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition((Partition)this.getContext().getRealm());
            if (Agent.class.isInstance(attributedType)) {
                Agent newAgent = (Agent)attributedType;
                if (User.class.isInstance(newAgent)) {
                    User newUser = (User)attributedType;
                    this.addUser(newUser);
                    return;
                } else {
                    this.addAgent(newAgent);
                }
                return;
            } else if (Role.class.isInstance(attributedType)) {
                Role newRole = (Role)attributedType;
                this.addRole(newRole);
                return;
            } else {
                if (!Group.class.isInstance(attributedType)) throw this.createUnsupportedIdentityTypeException(identityType.getClass());
                Group newGroup = (Group)attributedType;
                this.addGroup(newGroup);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
            Relationship relationship = (Relationship)attributedType;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                this.addGroupRoleRelationship(groupRole);
                return;
            } else if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                this.addGrantRelationship(grant);
                return;
            } else {
                if (!GroupMembership.class.isInstance(relationship)) throw this.createUnsupportedRelationshipType(relationship.getClass());
                GroupMembership groupMembership = (GroupMembership)relationship;
                this.addGroupMembership(groupMembership);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(AttributedType attributedType) {
        if (!IdentityType.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
        IdentityType identityType = (IdentityType)attributedType;
        if (Agent.class.isInstance(identityType)) {
            if (User.class.isInstance(identityType)) {
                User updatedUser = (User)identityType;
                this.updateUser(updatedUser);
            } else {
                Agent updatedAgent = (Agent)identityType;
                this.updateAgent(updatedAgent);
            }
        } else if (Role.class.isInstance(identityType)) {
            Role updatedRole = (Role)identityType;
            this.updateRole(updatedRole);
        } else {
            if (!Group.class.isInstance(identityType)) throw this.createUnsupportedIdentityTypeException(identityType.getClass());
            Group updatedGroup = (Group)identityType;
            this.updateGroup(updatedGroup);
        }
        this.cacheIdentityType(identityType);
    }

    public void remove(AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            LDAPGroup groupEntry;
            Group parentGroup;
            IdentityType identityType = (IdentityType)attributedType;
            LDAPEntry ldapEntry = (LDAPEntry)this.lookupEntry(identityType);
            String baseDN = ldapEntry.getDnSuffix();
            if (Group.class.isInstance(identityType) && (parentGroup = this.getParentGroup(groupEntry = (LDAPGroup)ldapEntry, false)) != null) {
                LDAPGroup parentGroupEntry = (LDAPGroup)this.lookupEntry(parentGroup);
                this.removeMember(parentGroupEntry, groupEntry);
            }
            RelationshipQuery query = this.getContext().getIdentityManager().createRelationshipQuery(Relationship.class);
            query.setParameter(Relationship.IDENTITY, new Object[]{identityType});
            List relationships = query.getResultList();
            for (Relationship relationship : relationships) {
                this.remove((AttributedType)relationship);
            }
            this.getLDAPManager().removeEntryById(baseDN, identityType.getId());
            this.invalidateCache(identityType);
        } else if (Relationship.class.isInstance(attributedType)) {
            Relationship relationship = (Relationship)attributedType;
            if (GroupRole.class.isInstance(relationship)) {
                GroupRole groupRole = (GroupRole)relationship;
                this.removeGroupRoleRelationship(groupRole);
            } else if (Grant.class.isInstance(relationship)) {
                this.removeGrantRelationship((Grant)relationship);
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                this.removeGroupMembership(groupMembership);
            } else {
                throw this.createUnsupportedRelationshipType(relationship.getClass());
            }
        }
    }

    public Agent getAgent(String loginName) {
        Agent agent = null;
        if (loginName != null && (agent = this.getContext().getCache().lookupAgent(this.getContext().getRealm(), loginName)) == null) {
            LDAPAgent ldapAgent = this.lookupAgent(loginName);
            if (ldapAgent == null) {
                agent = this.getUser(loginName);
            } else {
                agent = new SimpleAgent(ldapAgent.getLoginName());
                agent.setLoginName(ldapAgent.getLoginName());
                this.populateIdentityType(ldapAgent, (IdentityType)agent);
            }
            if (agent != null) {
                this.cacheIdentityType((IdentityType)agent);
            }
        }
        return agent;
    }

    public User getUser(String loginName) {
        User user = null;
        if (loginName != null) {
            LDAPUser ldapUser;
            user = this.getContext().getCache().lookupUser(this.getContext().getRealm(), loginName);
            if (user == null && (ldapUser = this.lookupUser(loginName)) != null) {
                user = new SimpleUser(ldapUser.getLoginName());
                user.setLoginName(ldapUser.getLoginName());
                user.setFirstName(ldapUser.getFirstName());
                user.setLastName(ldapUser.getLastName());
                user.setEmail(ldapUser.getEmail());
                this.populateIdentityType(ldapUser, (IdentityType)user);
            }
            if (user != null) {
                this.cacheIdentityType((IdentityType)user);
            }
        }
        return user;
    }

    public Group getGroup(String groupPath) {
        if (groupPath == null) {
            return null;
        }
        Group group = this.getContext().getCache().lookupGroup(this.getContext().getPartition(), groupPath);
        if (group == null) {
            group = this.getGroup(groupPath, this.getGroupBaseDN(groupPath));
        }
        if (group != null) {
            this.cacheIdentityType((IdentityType)group);
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        Group group = this.getGroup(parent.getPath() + "/" + name);
        if (group.getParentGroup() == null || !group.getParentGroup().getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public Role getRole(String name) {
        LDAPRole ldapRole;
        Role role = null;
        if (name != null && (role = this.getContext().getCache().lookupRole(this.getContext().getPartition(), name)) == null && (ldapRole = this.lookupRole(name)) != null) {
            role = new SimpleRole(ldapRole.getName());
            this.populateIdentityType(ldapRole, (IdentityType)role);
            this.cacheIdentityType((IdentityType)role);
        }
        return role;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        String relationshipFilter;
        LDAPQuery ldapQuery = new LDAPQuery(identityQuery, this);
        StringBuffer searchFilter = ldapQuery.createManagedAttributesFilter();
        if (searchFilter == null) {
            searchFilter = new StringBuffer("(&(objectClass=*))");
        }
        if ((relationshipFilter = ldapQuery.createRelationshipFilter()).isEmpty() && ldapQuery.hasRelationshipParameters()) {
            return Collections.emptyList();
        }
        String idAttribute = this.getIdAttribute(identityQuery.getIdentityType());
        if (idAttribute != null) {
            searchFilter.insert(searchFilter.length() - 1, "(" + idAttribute + "=*)");
        }
        searchFilter.insert(searchFilter.length() - 1, "(!(cn=custom-attributes))");
        searchFilter.insert(searchFilter.length() - 1, relationshipFilter.toString());
        NamingEnumeration<SearchResult> answer = null;
        ArrayList<User> results = new ArrayList<User>();
        try {
            String searchBaseDN = this.getBaseDN(identityQuery.getIdentityType());
            if (identityQuery.getParameter(AttributedType.ID) != null) {
                searchBaseDN = this.getConfig().getBaseDN();
            }
            answer = this.getLDAPManager().search(searchBaseDN, searchFilter.toString());
            while (answer.hasMore()) {
                Object[] values;
                SearchResult sr = answer.next();
                String nameInNamespace = sr.getNameInNamespace();
                String[] names = nameInNamespace.split(",");
                String uid = names[0].split("=")[1];
                User ldapEntry = null;
                if (nameInNamespace.endsWith(this.getConfig().getUserDNSuffix())) {
                    ldapEntry = this.getUser(uid);
                } else if (nameInNamespace.endsWith(this.getConfig().getAgentDNSuffix())) {
                    ldapEntry = this.getAgent(uid);
                } else if (nameInNamespace.endsWith(this.getConfig().getRoleDNSuffix())) {
                    ldapEntry = this.getRole(uid);
                } else if (this.getConfig().isGroupNamespace(nameInNamespace)) {
                    String groupDN = nameInNamespace.substring(nameInNamespace.indexOf(",") + 1);
                    LDAPGroup ldapGroup = new LDAPGroup(groupDN);
                    ldapGroup.setLDAPAttributes(sr.getAttributes());
                    Attributes attributes = this.getConfig().getLdapManager().lookupOperationalAttributes(groupDN, ldapGroup.getBidingName());
                    ldapEntry = this.getGroupById(attributes.get("entryUUID").get().toString());
                } else {
                    throw new IdentityManagementException("Unknown Base DN. IdentityType could not be identified.");
                }
                if (identityQuery.getParameters().containsKey(IdentityType.ENABLED)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.ENABLED);
                    if (!String.valueOf(ldapEntry.isEnabled()).equals(values[0].toString())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                    long providedDateInMillis;
                    if (ldapEntry.getExpirationDate() == null) continue;
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_DATE);
                        long storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis != (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_BEFORE);
                        long storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis > (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_AFTER);
                        long storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis < (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                }
                boolean match = true;
                Set parameters = identityQuery.getParameters(AttributedType.AttributeParameter.class).entrySet();
                for (Map.Entry ldapQueryParameter : parameters) {
                    QueryParameter queryParameter = (QueryParameter)ldapQueryParameter.getKey();
                    Object[] values2 = (Object[])ldapQueryParameter.getValue();
                    match = false;
                    AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                    Attribute customParameterValue = ldapEntry.getAttribute(customParameter.getName());
                    if (ldapEntry.getAttribute(customParameter.getName()) == null) continue;
                    int count = values2.length;
                    for (Object parameterValue : values2) {
                        if (customParameterValue.getValue().getClass().isArray()) {
                            Object[] customParameterValues;
                            for (Object value : customParameterValues = (Object[])customParameterValue.getValue()) {
                                if (!value.equals(parameterValue)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!parameterValue.equals(customParameterValue.getValue())) continue;
                        --count;
                    }
                    match = count <= 0;
                    if (match) continue;
                    break;
                }
                if (!match || ldapEntry == null) continue;
                results.add(ldapEntry);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error during query execution.", (Throwable)e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return results;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw new RuntimeException("Not implemented yet.");
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        ArrayList<Object> results;
        block123: {
            Group group;
            Role role;
            block132: {
                Agent agent;
                block131: {
                    LDAPAgent agentEntry;
                    LDAPRole roleEntry;
                    Class relationshipType;
                    block129: {
                        Group group2;
                        Agent agent2;
                        block130: {
                            block127: {
                                Role role2;
                                IdentityType identityType;
                                block128: {
                                    block124: {
                                        IdentityType ldapEntry;
                                        block126: {
                                            RelationshipQuery grantQuery;
                                            block125: {
                                                results = new ArrayList<Object>();
                                                relationshipType = query.getRelationshipType();
                                                Object[] identityQueryParameterValue = query.getParameter(Relationship.IDENTITY);
                                                if (identityQueryParameterValue == null || identityQueryParameterValue.length <= 0) break block124;
                                                Object identityParameterValue = identityQueryParameterValue[0];
                                                ldapEntry = null;
                                                if (IdentityType.class.isInstance(identityParameterValue)) {
                                                    ldapEntry = this.lookupEntry((IdentityType)identityParameterValue);
                                                } else if (String.class.isInstance(identityParameterValue)) {
                                                    IdentityQuery identityQuery = this.getContext().getIdentityManager().createIdentityQuery(IdentityType.class);
                                                    identityQuery.setParameter(IdentityType.ID, new Object[]{identityParameterValue.toString()});
                                                    List result = identityQuery.getResultList();
                                                    if (!result.isEmpty()) {
                                                        ldapEntry = (IdentityType)result.get(0);
                                                    }
                                                }
                                                if (ldapEntry == null) {
                                                    return results;
                                                }
                                                if (!Agent.class.isInstance(ldapEntry)) break block125;
                                                Agent agent3 = (Agent)ldapEntry;
                                                grantQuery = this.getContext().getIdentityManager().createRelationshipQuery(Grant.class);
                                                grantQuery.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{agent3});
                                                List resultList = grantQuery.getResultList();
                                                for (Grant grant : resultList) {
                                                    results.add(grant);
                                                }
                                                RelationshipQuery groupQuery = this.getContext().getIdentityManager().createRelationshipQuery(GroupMembership.class);
                                                groupQuery.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{agent3});
                                                List resultGroups = groupQuery.getResultList();
                                                for (GroupMembership groups : resultGroups) {
                                                    results.add(groups);
                                                }
                                                RelationshipQuery groupRoleQuery = this.getContext().getIdentityManager().createRelationshipQuery(GroupRole.class);
                                                groupRoleQuery.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{agent3});
                                                List resultGroupRoless = groupRoleQuery.getResultList();
                                                for (GroupRole groupRole : resultGroupRoless) {
                                                    results.add(groupRole);
                                                }
                                                break block123;
                                            }
                                            if (!Role.class.isInstance(ldapEntry)) break block126;
                                            Role role3 = (Role)ldapEntry;
                                            grantQuery = this.getContext().getIdentityManager().createRelationshipQuery(Grant.class);
                                            grantQuery.setParameter((QueryParameter)Grant.ROLE, new Object[]{role3});
                                            List resultList = grantQuery.getResultList();
                                            for (Grant grant : resultList) {
                                                results.add(grant);
                                            }
                                            RelationshipQuery groupRoleQuery = this.getContext().getIdentityManager().createRelationshipQuery(GroupRole.class);
                                            groupRoleQuery.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role3});
                                            List resultGroupRoless = groupRoleQuery.getResultList();
                                            for (GroupRole groupRole : resultGroupRoless) {
                                                results.add(groupRole);
                                            }
                                            break block123;
                                        }
                                        if (!Group.class.isInstance(ldapEntry)) break block123;
                                        Group group3 = (Group)ldapEntry;
                                        RelationshipQuery groupMembershipQuery = this.getContext().getIdentityManager().createRelationshipQuery(GroupMembership.class);
                                        groupMembershipQuery.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group3});
                                        List resultList = groupMembershipQuery.getResultList();
                                        for (GroupMembership groupMembership : resultList) {
                                            results.add(groupMembership);
                                        }
                                        RelationshipQuery groupRoleQuery = this.getContext().getIdentityManager().createRelationshipQuery(GroupRole.class);
                                        groupRoleQuery.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group3});
                                        List resultGroupRoless = groupRoleQuery.getResultList();
                                        for (GroupRole groupRole : resultGroupRoless) {
                                            results.add(groupRole);
                                        }
                                        break block123;
                                    }
                                    if (!Grant.class.equals((Object)relationshipType)) break block127;
                                    identityType = null;
                                    if (query.getParameter((QueryParameter)Grant.ASSIGNEE) != null) {
                                        identityType = (IdentityType)query.getParameter((QueryParameter)Grant.ASSIGNEE)[0];
                                    }
                                    role2 = null;
                                    if (query.getParameter((QueryParameter)Grant.ROLE) != null) {
                                        role2 = (Role)query.getParameter((QueryParameter)Grant.ROLE)[0];
                                    }
                                    if (identityType == null || role2 == null) break block128;
                                    LDAPEntry agentEntry2 = (LDAPEntry)this.lookupEntry(identityType);
                                    LDAPRole roleEntry2 = (LDAPRole)this.lookupEntry(role2);
                                    if (!roleEntry2.isMember(agentEntry2)) break block123;
                                    results.add(new Grant(identityType, role2));
                                    break block123;
                                }
                                if (identityType != null) {
                                    String membersFilter = "";
                                    LDAPEntry ldapEntry = null;
                                    try {
                                        ldapEntry = (LDAPEntry)this.lookupEntry(identityType);
                                        membersFilter = "(member=" + ldapEntry.getDN() + ")";
                                    }
                                    catch (IdentityManagementException ime) {
                                        return results;
                                    }
                                    NamingEnumeration<SearchResult> search = null;
                                    try {
                                        search = this.getLDAPManager().search(this.getConfig().getRoleDNSuffix(), membersFilter.toString());
                                        while (search.hasMoreElements()) {
                                            SearchResult searchResult = search.next();
                                            String entryCN = searchResult.getAttributes().get("cn").get().toString();
                                            results.add(new Grant(identityType, this.getRole(entryCN)));
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new IdentityManagementException((Throwable)e);
                                    }
                                    finally {
                                        if (search != null) {
                                            try {
                                                search.close();
                                            }
                                            catch (NamingException e) {}
                                        }
                                    }
                                }
                                if (role2 != null) {
                                    LDAPEntry ldapEntry = null;
                                    try {
                                        ldapEntry = (LDAPEntry)this.lookupEntry(role2);
                                    }
                                    catch (IdentityManagementException ime) {
                                        return results;
                                    }
                                    NamingEnumeration<?> members = null;
                                    try {
                                        members = ldapEntry.getLDAPAttributes().get("member").getAll();
                                        while (members.hasMoreElements()) {
                                            String userBindingName;
                                            String loginName;
                                            Agent associatedAgent;
                                            String memberDN = (String)members.nextElement();
                                            if (memberDN.trim().isEmpty() || (associatedAgent = this.getAgent(loginName = (userBindingName = memberDN.split(",")[0]).split("=")[1])) == null) continue;
                                            results.add(new Grant((IdentityType)associatedAgent, role2));
                                        }
                                    }
                                    catch (NamingException e) {
                                        throw new IdentityManagementException((Throwable)e);
                                    }
                                    finally {
                                        if (members != null) {
                                            try {
                                                members.close();
                                            }
                                            catch (NamingException e) {}
                                        }
                                    }
                                }
                                break block123;
                            }
                            if (!GroupMembership.class.equals((Object)relationshipType)) break block129;
                            agent2 = null;
                            if (query.getParameter((QueryParameter)GroupMembership.MEMBER) != null) {
                                agent2 = (Agent)query.getParameter((QueryParameter)GroupMembership.MEMBER)[0];
                            }
                            group2 = null;
                            if (query.getParameter((QueryParameter)GroupMembership.GROUP) != null) {
                                group2 = (Group)query.getParameter((QueryParameter)GroupMembership.GROUP)[0];
                            }
                            if (agent2 == null || group2 == null) break block130;
                            LDAPGroup groupEntry = null;
                            LDAPAgent agentEntry3 = null;
                            try {
                                groupEntry = (LDAPGroup)this.lookupEntry(group2);
                                agentEntry3 = (LDAPAgent)this.lookupEntry(agent2);
                            }
                            catch (IdentityManagementException ime) {
                                return results;
                            }
                            boolean isMember = false;
                            if (groupEntry.isMember(agentEntry3)) {
                                isMember = true;
                            } else {
                                List<Group> parentGroups = this.getParentGroups(groupEntry);
                                for (Group parentGroup : parentGroups) {
                                    LDAPGroup parentGroupEntry = (LDAPGroup)this.lookupEntry(parentGroup);
                                    if (!parentGroupEntry.isMember(agentEntry3)) continue;
                                    isMember = true;
                                }
                            }
                            if (!isMember) break block123;
                            results.add(new GroupMembership(agent2, group2));
                            break block123;
                        }
                        if (agent2 != null) {
                            String membersFilter = "";
                            try {
                                LDAPEntry ldapEntry = (LDAPEntry)this.lookupEntry(agent2);
                                membersFilter = "(member=" + ldapEntry.getDN() + ")";
                            }
                            catch (IdentityManagementException ime) {
                                return results;
                            }
                            NamingEnumeration<SearchResult> search = null;
                            try {
                                search = this.getLDAPManager().search(this.getConfig().getBaseDN(), membersFilter.toString());
                                while (search.hasMoreElements()) {
                                    SearchResult searchResult = search.next();
                                    String entryCN = searchResult.getAttributes().get("cn").get().toString();
                                    String nameInNamespace = searchResult.getNameInNamespace();
                                    if (!this.getConfig().isGroupNamespace(nameInNamespace)) continue;
                                    String baseDN = nameInNamespace.substring(nameInNamespace.indexOf(",") + 1);
                                    LDAPGroup ldapGroup = new LDAPGroup(baseDN);
                                    this.populateLDAPEntry(ldapGroup, searchResult);
                                    SimpleGroup simpleGroup = new SimpleGroup(entryCN, this.getParentGroup(ldapGroup, true));
                                    this.populateIdentityType(ldapGroup, (IdentityType)simpleGroup);
                                    results.add(new GroupMembership(agent2, (Group)simpleGroup));
                                }
                            }
                            catch (Exception e) {
                                throw new IdentityManagementException((Throwable)e);
                            }
                            finally {
                                if (search != null) {
                                    try {
                                        search.close();
                                    }
                                    catch (NamingException e) {}
                                }
                            }
                        }
                        if (group2 != null) {
                            LDAPEntry ldapEntry = null;
                            try {
                                ldapEntry = (LDAPEntry)this.lookupEntry(group2);
                            }
                            catch (IdentityManagementException ime) {
                                return results;
                            }
                            NamingEnumeration<?> members = null;
                            try {
                                members = ldapEntry.getLDAPAttributes().get("member").getAll();
                                while (members.hasMoreElements()) {
                                    String memberDN = (String)members.nextElement();
                                    if (!memberDN.contains(this.getConfig().getUserDNSuffix()) && !memberDN.contains(this.getConfig().getAgentDNSuffix()) || memberDN.trim().isEmpty()) continue;
                                    String agentBindingName = memberDN.split(",")[0];
                                    String loginName = agentBindingName.split("=")[1];
                                    results.add(new GroupMembership(this.getAgent(loginName), group2));
                                }
                            }
                            catch (NamingException e) {
                                throw new IdentityManagementException((Throwable)e);
                            }
                            finally {
                                if (members != null) {
                                    try {
                                        members.close();
                                    }
                                    catch (NamingException e) {}
                                }
                            }
                        }
                        break block123;
                    }
                    if (!GroupRole.class.equals((Object)relationshipType)) break block123;
                    agent = null;
                    if (query.getParameter((QueryParameter)GroupRole.ASSIGNEE) != null) {
                        agent = (Agent)query.getParameter((QueryParameter)GroupRole.ASSIGNEE)[0];
                    }
                    role = null;
                    if (query.getParameter((QueryParameter)GroupRole.ROLE) != null) {
                        role = (Role)query.getParameter((QueryParameter)GroupRole.ROLE)[0];
                    }
                    group = null;
                    if (query.getParameter((QueryParameter)GroupRole.GROUP) != null) {
                        group = (Group)query.getParameter((QueryParameter)GroupRole.GROUP)[0];
                    }
                    if (agent == null || group == null || role == null) break block131;
                    LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(group);
                    if (this.hasGroupRole(groupEntry, roleEntry = (LDAPRole)this.lookupEntry(role), agentEntry = (LDAPAgent)this.lookupEntry(agent))) {
                        results.add(new GroupRole((IdentityType)agent, group, role));
                    } else {
                        List<Group> parentGroups = this.getParentGroups(groupEntry);
                        for (Group parentGroup : parentGroups) {
                            LDAPGroup parentGroupEntry = (LDAPGroup)this.lookupEntry(parentGroup);
                            if (!this.hasGroupRole(parentGroupEntry, roleEntry, agentEntry)) continue;
                            results.add(new GroupRole((IdentityType)agent, group, role));
                            break block123;
                        }
                    }
                    break block123;
                }
                if (agent == null || role != null || group != null) break block132;
                LDAPAgent agentEntry = this.lookupAgent(agent);
                if (agentEntry == null) break block123;
                NamingEnumeration<SearchResult> search = this.getLDAPManager().search(agentEntry.getDN(), "(&(objectClass=*)(cn=*)(member=*))");
                try {
                    while (search.hasMore()) {
                        SearchResult next = search.next();
                        String groupName = (String)next.getAttributes().get("cn").get();
                        javax.naming.directory.Attribute members = next.getAttributes().get("member");
                        if (members == null || members.size() <= 0) continue;
                        NamingEnumeration<?> allRoles = members.getAll();
                        while (allRoles.hasMoreElements()) {
                            String roleDN = (String)allRoles.nextElement();
                            String roleName = roleDN.substring(roleDN.indexOf("=") + 1, roleDN.indexOf(","));
                            Role associatedRole = this.getRole(roleName);
                            Group associatedGroup = this.getGroup(groupName);
                            if (associatedRole == null || associatedGroup == null) continue;
                            results.add(new GroupRole((IdentityType)agent, associatedGroup, associatedRole));
                        }
                    }
                }
                catch (Exception e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
            if (role != null) {
                LDAPRole roleEntry = null;
                try {
                    roleEntry = (LDAPRole)this.lookupEntry(role);
                }
                catch (IdentityManagementException ime) {
                    return results;
                }
                if (roleEntry != null) {
                    NamingEnumeration<SearchResult> search = this.getLDAPManager().search(this.getConfig().getUserDNSuffix(), "(&(objectClass=*)(cn=*)(member=" + roleEntry.getDN() + "))");
                    try {
                        while (search.hasMore()) {
                            SearchResult next = search.next();
                            String nameInNamespace = next.getNameInNamespace();
                            String userDN = nameInNamespace.substring(nameInNamespace.indexOf("uid"));
                            String userName = userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
                            String groupName = (String)next.getAttributes().get("cn").get();
                            Role associatedRole = this.getRole(roleEntry.getName());
                            Group associatedGroup = this.getGroup(groupName);
                            Agent associatedAgent = this.getAgent(userName);
                            if (associatedRole == null || associatedGroup == null || associatedAgent == null) continue;
                            results.add(new GroupRole((IdentityType)associatedAgent, associatedGroup, associatedRole));
                        }
                    }
                    catch (Exception e) {
                        throw new IdentityManagementException((Throwable)e);
                    }
                    finally {
                        try {
                            search.close();
                        }
                        catch (NamingException e) {}
                    }
                }
            } else if (group != null) {
                LDAPGroup groupEntry = null;
                try {
                    groupEntry = (LDAPGroup)this.lookupEntry(group);
                }
                catch (IdentityManagementException ime) {
                    return results;
                }
                String filter = "(&(objectClass=*)(" + groupEntry.getBidingName() + ")(" + "member" + "=" + "*))";
                NamingEnumeration<SearchResult> search = this.getLDAPManager().search(this.getConfig().getUserDNSuffix(), filter);
                try {
                    while (search.hasMore()) {
                        SearchResult next = search.next();
                        String nameInNamespace = next.getNameInNamespace();
                        String userDN = nameInNamespace.substring(nameInNamespace.indexOf("uid"));
                        String userName = userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
                        String groupName = (String)next.getAttributes().get("cn").get();
                        javax.naming.directory.Attribute members = next.getAttributes().get("member");
                        if (members == null || members.size() <= 0) continue;
                        NamingEnumeration<?> allRoles = members.getAll();
                        while (allRoles.hasMoreElements()) {
                            String roleDN = (String)allRoles.nextElement();
                            String roleName = roleDN.substring(roleDN.indexOf("=") + 1, roleDN.indexOf(","));
                            Role associatedRole = this.getRole(roleName);
                            Group associatedGroup = this.getGroup(groupName);
                            Agent associatedAgent = this.getAgent(userName);
                            if (associatedRole == null || associatedGroup == null || associatedAgent == null) continue;
                            results.add(new GroupRole((IdentityType)associatedAgent, associatedGroup, associatedRole));
                        }
                    }
                }
                catch (Exception e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    try {
                        search.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        return results;
    }

    private boolean hasGroupRole(LDAPGroup groupEntry, LDAPRole roleEntry, LDAPAgent agentEntry) {
        NamingEnumeration<SearchResult> groupRoleAttributes = this.lookupGroupRoleEntry(agentEntry, groupEntry);
        try {
            if (groupRoleAttributes.hasMore()) {
                LDAPGroupRole groupRoleEntry = new LDAPGroupRole(agentEntry, groupEntry, roleEntry);
                groupRoleEntry.setLDAPAttributes(groupRoleAttributes.next().getAttributes());
                if (groupRoleEntry.isMember(roleEntry)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException((Throwable)e);
        }
        finally {
            try {
                groupRoleAttributes.close();
            }
            catch (NamingException e) {}
        }
        return false;
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        return 0;
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        return null;
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    private void addIdentityType(IdentityType newIdentityType, LDAPIdentityType ldapIdentityType) {
        ldapIdentityType.setEnabled(newIdentityType.isEnabled());
        ldapIdentityType.setCreatedDate(newIdentityType.getCreatedDate());
        ldapIdentityType.setExpirationDate(newIdentityType.getExpirationDate());
        this.getLDAPManager().createSubContext(ldapIdentityType.getDN(), ldapIdentityType.getLDAPAttributes());
        this.getLDAPManager().rebind(this.getCustomAttributesDN(ldapIdentityType.getDN()), ldapIdentityType.getCustomAttributes());
        this.populateOperationalAttributes(ldapIdentityType);
        newIdentityType.setId(ldapIdentityType.getId());
    }

    private LDAPOperationManager getLDAPManager() {
        return this.getConfig().getLdapManager();
    }

    private String getCustomAttributesDN(String parentDN) {
        return "cn=custom-attributes," + parentDN;
    }

    private void updateIdentityType(IdentityType updatedIdentityType, LDAPIdentityType identityTypeEntry) {
        identityTypeEntry.setEnabled(updatedIdentityType.isEnabled());
        identityTypeEntry.setExpirationDate(updatedIdentityType.getExpirationDate());
        Attributes ldapAttributes = identityTypeEntry.getLDAPAttributes();
        NamingEnumeration<? extends javax.naming.directory.Attribute> all = ldapAttributes.getAll();
        Attributes clonedAttributes = (Attributes)identityTypeEntry.getLDAPAttributes().clone();
        while (all.hasMoreElements()) {
            javax.naming.directory.Attribute attribute = (javax.naming.directory.Attribute)all.nextElement();
            if (clonedAttributes.get(attribute.getID()) != null) {
                if (attribute.getID().equalsIgnoreCase("entryUUID") || attribute.getID().equalsIgnoreCase("createTimeStamp")) continue;
                this.getLDAPManager().modifyAttribute(identityTypeEntry.getDN(), attribute);
                continue;
            }
            this.getLDAPManager().addAttribute(identityTypeEntry.getDN(), attribute);
        }
        identityTypeEntry.getCustomAttributes().clear();
        Collection updatedAttributes = updatedIdentityType.getAttributes();
        for (Attribute attribute : updatedAttributes) {
            identityTypeEntry.getCustomAttributes().addAttribute(attribute.getName(), attribute.getValue());
        }
        this.getLDAPManager().rebind(this.getCustomAttributesDN(identityTypeEntry.getDN()), identityTypeEntry.getCustomAttributes());
    }

    private void populateIdentityType(LDAPIdentityType ldapIdentityType, IdentityType identityType) {
        identityType.setId(ldapIdentityType.getId());
        identityType.setEnabled(ldapIdentityType.isEnabled());
        identityType.setCreatedDate(ldapIdentityType.getCreatedDate());
        identityType.setExpirationDate(ldapIdentityType.getExpirationDate());
        identityType.setPartition(ldapIdentityType.getPartition());
        Set<Map.Entry<String, Serializable>> entrySet = ldapIdentityType.getCustomAttributes().getAttributes().entrySet();
        for (Map.Entry<String, Serializable> entry : entrySet) {
            if (entry.getKey().equals("enabled") || entry.getKey().equals("expiryDate")) continue;
            identityType.setAttribute(new Attribute(entry.getKey(), entry.getValue()));
        }
    }

    protected <T extends LDAPIdentityType> T lookupEntryById(Class<T> type, String id) throws IdentityManagementException {
        LDAPIdentityType identityType = null;
        NamingEnumeration<SearchResult> search = this.getLDAPManager().lookupById(this.getConfig().getBaseDN(), id);
        try {
            if (search.hasMore()) {
                SearchResult sr = search.next();
                String nameInNamespace = sr.getNameInNamespace();
                String baseDN = nameInNamespace.substring(nameInNamespace.indexOf(",") + 1);
                identityType = (LDAPIdentityType)type.getConstructor(String.class).newInstance(baseDN);
                this.populateLDAPEntry(identityType, sr);
            }
            if (search.hasMore()) {
                throw new IdentityManagementException("Ambiguous entry found with the given id [" + id + "]");
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error looking up entry.", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating instance for type [" + type.getName() + "].", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        if (identityType == null) {
            throw new IdentityManagementException("No entry found for the given type [" + type.getName() + "] and id [" + id + "]");
        }
        return (T)identityType;
    }

    private <T extends LDAPIdentityType> T populateIdentityTypeEntry(T identityType) {
        String filter = "(&(objectClass=*)(" + identityType.getBidingName() + "))";
        NamingEnumeration<SearchResult> search = this.getLDAPManager().search(identityType.getDnSuffix(), filter);
        try {
            if (search.hasMore()) {
                SearchResult sr = search.next();
                this.populateLDAPEntry(identityType, sr);
            } else {
                identityType = null;
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error looking up entry.", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        return identityType;
    }

    private <T extends LDAPIdentityType> void populateLDAPEntry(T identityType, SearchResult sr) throws NamingException {
        identityType.setLDAPAttributes(sr.getAttributes());
        identityType.setCustomAttributes(this.getCustomAttributes(identityType));
        this.populateOperationalAttributes(identityType);
        identityType.setPartition((Partition)new Realm("default"));
        identityType.setCustomAttributes(this.getCustomAttributes(identityType));
    }

    private <T extends LDAPIdentityType> void populateOperationalAttributes(T identityType) {
        try {
            Attributes operationalAttributes = this.getLDAPManager().lookupOperationalAttributes(identityType.getDnSuffix(), identityType.getBidingName());
            identityType.setId(operationalAttributes.get("entryUUID").get().toString());
            String createdTimeStamp = operationalAttributes.get("createTimeStamp").get().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                identityType.setCreatedDate(sdf.parse(createdTimeStamp));
            }
            catch (ParseException e) {
                throw new IdentityManagementException("Error parsing created date.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error populating operational attributes.", (Throwable)e);
        }
    }

    private LDAPCustomAttributes getCustomAttributes(LDAPAttributedType attributedType) {
        String customDN = this.getCustomAttributesDN(attributedType.getDN());
        LDAPCustomAttributes customAttributes = null;
        try {
            customAttributes = (LDAPCustomAttributes)this.getLDAPManager().lookup(customDN);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (customAttributes == null) {
            this.getLDAPManager().bind(customDN, attributedType.getCustomAttributes());
        }
        return customAttributes;
    }

    protected Group getParentGroup(LDAPGroup childGroup, boolean loadAllHiearchy) {
        block16: {
            SimpleGroup simpleGroup;
            StringBuffer filter = new StringBuffer();
            filter.append("(member=" + childGroup.getDN() + ")");
            NamingEnumeration<SearchResult> answer = null;
            try {
                SearchControls controls = new SearchControls();
                controls.setSearchScope(2);
                answer = this.getLDAPManager().search(this.getConfig().getBaseDN(), filter.toString(), new String[]{"cn"}, controls);
                if (!answer.hasMoreElements()) break block16;
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String cn = (String)attributes.get("cn").get();
                String nameInNamespace = sr.getNameInNamespace();
                String str = "cn=" + cn + ",";
                String baseDN = nameInNamespace.substring(nameInNamespace.indexOf(str) + str.length());
                if (loadAllHiearchy) {
                    Group group = this.getGroup(cn, baseDN);
                    return group;
                }
                LDAPGroup parentEntry = new LDAPGroup(baseDN);
                SimpleGroup parentGroup = new SimpleGroup(cn);
                this.populateLDAPEntry(parentEntry, sr);
                this.populateIdentityType(parentEntry, (IdentityType)parentGroup);
                simpleGroup = parentGroup;
            }
            catch (NamingException e) {
                throw new RuntimeException("Error looking parent group for [" + childGroup.getDN() + "]", e);
            }
            finally {
                if (answer != null) {
                    try {
                        answer.close();
                    }
                    catch (NamingException e) {}
                }
            }
            return simpleGroup;
        }
        return null;
    }

    protected List<Group> getParentGroups(LDAPGroup childGroup) {
        ArrayList<Group> result = new ArrayList<Group>();
        Group parentGroup = this.getParentGroup(childGroup, true);
        if (parentGroup == null) {
            return result;
        }
        result.add(parentGroup);
        result.addAll(this.getParentGroups((LDAPGroup)this.lookupEntry(parentGroup)));
        return result;
    }

    private void addGroup(Group newGroup) {
        LDAPGroup groupEntry = new LDAPGroup(this.getGroupBaseDN(newGroup.getPath()));
        groupEntry.setName(newGroup.getName());
        this.addIdentityType((IdentityType)newGroup, groupEntry);
        if (newGroup.getParentGroup() != null) {
            LDAPGroup parentGroupentry = this.lookupGroup(newGroup.getParentGroup().getPath());
            this.addMember(parentGroupentry, groupEntry);
        }
    }

    private String getGroupBaseDN(String groupPath) {
        String groupMappingDN;
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        if ((groupMappingDN = this.getConfig().getGroupMappingDN(groupPath)) == null) {
            groupMappingDN = this.getConfig().getGroupDNSuffix();
        }
        return groupMappingDN;
    }

    private void addRole(Role newRole) {
        LDAPRole ldapRole = new LDAPRole(this.getConfig().getRoleDNSuffix());
        ldapRole.setName(newRole.getName());
        this.addIdentityType((IdentityType)newRole, ldapRole);
    }

    private void addAgent(Agent newAgent) {
        LDAPAgent ldapAgent = new LDAPAgent(this.getConfig().getAgentDNSuffix());
        ldapAgent.setLoginName(newAgent.getLoginName());
        this.addIdentityType((IdentityType)newAgent, ldapAgent);
    }

    private void addUser(User newUser) {
        LDAPUser ldapUser = new LDAPUser(this.getConfig().getUserDNSuffix());
        ldapUser.setLoginName(newUser.getLoginName());
        ldapUser.setFirstName(newUser.getFirstName());
        ldapUser.setLastName(newUser.getLastName());
        ldapUser.setFullName(ldapUser.getUserCN());
        ldapUser.setEmail(newUser.getEmail());
        this.addIdentityType((IdentityType)newUser, ldapUser);
    }

    private void updateGroup(Group updatedGroup) {
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(updatedGroup);
        this.updateIdentityType((IdentityType)updatedGroup, groupEntry);
    }

    private void updateRole(Role updatedRole) {
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(updatedRole);
        this.updateIdentityType((IdentityType)updatedRole, roleEntry);
    }

    private void updateAgent(Agent updatedAgent) {
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(updatedAgent);
        this.updateIdentityType((IdentityType)updatedAgent, agentEntry);
    }

    private void updateUser(User updatedUser) {
        LDAPUser userEntry = (LDAPUser)this.lookupEntry(updatedUser);
        userEntry.setFirstName(updatedUser.getFirstName());
        userEntry.setLastName(updatedUser.getLastName());
        userEntry.setFullName(userEntry.getUserCN());
        userEntry.setEmail(updatedUser.getEmail());
        this.updateIdentityType((IdentityType)updatedUser, userEntry);
    }

    private String getBaseDN(Class<? extends IdentityType> identityTypeClass) {
        String baseDN = null;
        baseDN = IDMUtil.isUserType(identityTypeClass) ? this.getConfig().getUserDNSuffix() : (IDMUtil.isRoleType(identityTypeClass) ? this.getConfig().getRoleDNSuffix() : (IDMUtil.isGroupType(identityTypeClass) ? this.getConfig().getGroupDNSuffix() : (IDMUtil.isAgentType(identityTypeClass) ? this.getConfig().getAgentDNSuffix() : this.getConfig().getBaseDN())));
        return baseDN;
    }

    private void addGroupRoleRelationship(GroupRole groupRole) {
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(groupRole.getAssignee());
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(groupRole.getGroup());
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(groupRole.getRole());
        LDAPGroupRole groupRoleEntry = new LDAPGroupRole(agentEntry, groupEntry, roleEntry);
        NamingEnumeration<SearchResult> search = this.getLDAPManager().search(agentEntry.getDN(), groupRoleEntry.getBidingName());
        try {
            if (!search.hasMore()) {
                this.getLDAPManager().createSubContext(groupRoleEntry.getDN(), groupRoleEntry.getLDAPAttributes());
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating GroupRole relationship.", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        this.addMember(groupRoleEntry, roleEntry);
    }

    private void addGroupMembership(GroupMembership groupMembership) {
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(groupMembership.getGroup());
        LDAPAgent memberEntry = (LDAPAgent)this.lookupEntry(groupMembership.getMember());
        this.addMember(groupEntry, memberEntry);
    }

    private void addGrantRelationship(Grant grant) {
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(grant.getRole());
        LDAPEntry assigneeEntry = (LDAPEntry)this.lookupEntry(grant.getAssignee());
        this.addMember(roleEntry, assigneeEntry);
    }

    private void addMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.addMember(childEntry);
        this.getLDAPManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    protected <T extends IdentityType> T lookupEntry(T identityType) throws IdentityManagementException {
        LDAPIdentityType identityTypeEntry = null;
        if (Agent.class.isInstance(identityType)) {
            Agent agent = (Agent)identityType;
            identityTypeEntry = User.class.isInstance(agent) ? this.lookupEntryById(LDAPUser.class, agent.getId()) : this.lookupEntryById(LDAPAgent.class, agent.getId());
        } else if (Role.class.isInstance(identityType)) {
            identityTypeEntry = this.lookupEntryById(LDAPRole.class, identityType.getId());
        } else if (Group.class.isInstance(identityType)) {
            identityTypeEntry = this.lookupEntryById(LDAPGroup.class, identityType.getId());
        } else {
            throw new IdentityManagementException("Unsupported type [" + identityType.getClass().getName() + "].");
        }
        return (T)identityTypeEntry;
    }

    private String getIdAttribute(Class<? extends IdentityType> identityTypeClass) {
        String idAttribute = null;
        if (IDMUtil.isAgentType(identityTypeClass)) {
            idAttribute = "uid";
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            idAttribute = "cn";
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            idAttribute = "cn";
        }
        return idAttribute;
    }

    private IdentityManagementException createUnsupportedIdentityTypeException(Class<? extends IdentityType> identityTypeClass) {
        return new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
    }

    private IdentityManagementException createUnsupportedAttributedType(Class<? extends AttributedType> type) {
        return new IdentityManagementException("Unsupported AttributedType [" + type.getName() + "].");
    }

    private IdentityManagementException createUnsupportedRelationshipType(Class<? extends Relationship> type) {
        return new IdentityManagementException("Unsupported Relationship type [" + type.getName() + "].");
    }

    protected LDAPRole lookupRole(String name) {
        return this.populateIdentityTypeEntry(new LDAPRole(name, this.getConfig().getRoleDNSuffix()));
    }

    protected LDAPAgent lookupAgent(String loginName) {
        return this.populateIdentityTypeEntry(new LDAPAgent(loginName, this.getConfig().getAgentDNSuffix()));
    }

    protected LDAPAgent lookupAgent(Agent agent) {
        LDAPAgent storedAgent = null;
        storedAgent = User.class.isInstance(agent) ? this.lookupUser(agent.getLoginName()) : this.lookupAgent(agent.getLoginName());
        return storedAgent;
    }

    protected LDAPGroup lookupGroup(String groupPath) {
        return this.lookupGroup(groupPath, this.getGroupBaseDN(groupPath));
    }

    protected LDAPGroup lookupGroup(String groupPath, String baseDN) {
        String name = null;
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        String[] groupPaths = groupPath.split("/");
        name = groupPaths[groupPaths.length - 1];
        LDAPGroup ldapGroup = new LDAPGroup(name, baseDN);
        ldapGroup.setPath(groupPath);
        return this.populateIdentityTypeEntry(ldapGroup);
    }

    private LDAPUser lookupUser(String loginName) {
        return this.populateIdentityTypeEntry(new LDAPUser(loginName, this.getConfig().getUserDNSuffix()));
    }

    private void removeGroupRoleRelationship(GroupRole groupRole) {
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(groupRole.getGroup());
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(groupRole.getAssignee());
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(groupRole.getRole());
        NamingEnumeration<SearchResult> search = this.lookupGroupRoleEntry(agentEntry, groupEntry);
        try {
            if (search.hasMore()) {
                LDAPGroupRole groupRoleEntry = new LDAPGroupRole(agentEntry, groupEntry, roleEntry);
                this.removeMember(groupRoleEntry, roleEntry);
                String members = groupRoleEntry.getLDAPAttributes().get("member").get().toString();
                if (members.trim().isEmpty()) {
                    this.getLDAPManager().destroySubcontext(search.next().getNameInNamespace());
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error removing GroupRole relationship.", (Throwable)e);
        }
    }

    private void removeGroupMembership(GroupMembership groupMembership) {
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(groupMembership.getGroup());
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(groupMembership.getMember());
        this.removeMember(groupEntry, agentEntry);
    }

    private void removeGrantRelationship(Grant grant) {
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(grant.getRole());
        LDAPEntry agentEntry = (LDAPEntry)this.lookupEntry(grant.getAssignee());
        this.removeMember(roleEntry, agentEntry);
    }

    private NamingEnumeration<SearchResult> lookupGroupRoleEntry(LDAPAgent agentEntry, LDAPGroup groupEntry) {
        return this.getLDAPManager().search(agentEntry.getDN(), groupEntry.getBidingName());
    }

    private void removeMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.removeMember(childEntry);
        this.getLDAPManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private void cacheIdentityType(IdentityType identityType) {
        if (User.class.isInstance(identityType)) {
            this.getContext().getCache().putUser((Realm)identityType.getPartition(), (User)identityType);
        } else if (Agent.class.isInstance(identityType)) {
            this.getContext().getCache().putAgent((Realm)identityType.getPartition(), (Agent)identityType);
        } else if (Role.class.isInstance(identityType)) {
            this.getContext().getCache().putRole(identityType.getPartition(), (Role)identityType);
        } else if (Group.class.isInstance(identityType)) {
            this.getContext().getCache().putGroup(identityType.getPartition(), (Group)identityType);
        }
    }

    private void invalidateCache(IdentityType identityType) {
        if (Agent.class.isInstance(identityType)) {
            this.getContext().getCache().invalidate((Partition)this.getContext().getRealm(), identityType);
        } else {
            this.getContext().getCache().invalidate(this.getContext().getPartition(), identityType);
        }
    }

    private Group getGroupById(String id) {
        if (id == null) {
            return null;
        }
        LDAPGroup ldapGroup = this.lookupEntryById(LDAPGroup.class, id);
        if (ldapGroup != null) {
            Group parentGroup = this.getParentGroup(ldapGroup, false);
            SimpleGroup group = null;
            group = parentGroup != null ? new SimpleGroup(ldapGroup.getName(), this.getGroupById(parentGroup.getId())) : new SimpleGroup(ldapGroup.getName());
            this.populateIdentityType(ldapGroup, (IdentityType)group);
            return group;
        }
        return null;
    }

    private Group getGroup(String groupPath, String baseDN) {
        LDAPGroup ldapGroup;
        if (groupPath != null && (ldapGroup = this.lookupGroup(groupPath, baseDN)) != null) {
            SimpleGroup group = new SimpleGroup(ldapGroup.getName(), this.getParentGroup(ldapGroup, true));
            this.populateIdentityType(ldapGroup, (IdentityType)group);
            return group;
        }
        return null;
    }
}

