/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.password.internal;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.password.PasswordEncoder;

public class SHASaltedPasswordEncoder
implements PasswordEncoder {
    private int strength;

    public SHASaltedPasswordEncoder(int strength) {
        this.strength = strength;
    }

    public String encodePassword(String salt, String rawPassword) {
        MessageDigest messageDigest = this.getMessageDigest();
        byte[] encodedPassword = null;
        try {
            encodedPassword = messageDigest.digest(this.saltPassword(rawPassword, salt).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding password", e);
        }
        return Base64.encodeBytes((byte[])encodedPassword);
    }

    private String saltPassword(String rawPassword, String salt) {
        return rawPassword + salt.toString();
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        String algorithm = "SHA-" + this.strength;
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: " + algorithm);
        }
    }
}

