/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.oauth.server.endpoint;

import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.oauth.OAuthUtils;
import org.picketlink.oauth.client.ClientOAuth;
import org.picketlink.oauth.messages.AuthorizationResponse;
import org.picketlink.oauth.messages.RegistrationResponse;
import org.picketlink.test.oauth.server.endpoint.EndpointTestBase;

public class AuthorizationEndpointTestCase
extends EndpointTestBase {
    private String registrationEndpoint = "http://localhost:11080/oauth/register";
    private String appName = "Sample Application";
    private String appURL = "http://www.example.com";
    private String appIcon = "http://www.example.com/app.ico";
    private String appDescription = "Description of a Sample App";
    private String appRedirectURL = "http://www.example.com/redirect";
    private ClientOAuth client = new ClientOAuth();

    @Test
    public void testEndUserAuthorization() throws Exception {
        long parsedIssuedAt;
        ClientOAuth.RegistrationClient registrationClient = this.client.registrationClient();
        RegistrationResponse registrationResponse = registrationClient.setLocation(this.registrationEndpoint).setAppName(this.appName).setAppURL(this.appURL).setAppDescription(this.appDescription).setAppIcon(this.appIcon).setAppRedirectURL(this.appRedirectURL).build().registerAsJSON();
        String clientID = registrationResponse.getClientID();
        Assert.assertNotNull((Object)clientID);
        String clientSecret = registrationResponse.getClientSecret();
        Assert.assertNotNull((Object)clientSecret);
        if (registrationResponse.getExpiresIn() != 3600L) {
            Assert.fail((String)"expires");
        }
        Assert.assertTrue(((parsedIssuedAt = Long.parseLong(registrationResponse.getIssued())) - new Date().getTime() < 50L ? 1 : 0) != 0);
        String authorizationEndpoint = "http://localhost:11080/oauth/authz";
        String authzRedirectURL = "http://localhost:11080/oauth/redirect";
        String redirectURL = "http://localhost:11080/oauth/redirect";
        ClientOAuth.AuthorizationClient authorizationClient = this.client.authorizationClient();
        AuthorizationResponse authorizationResponse = authorizationClient.setAuthorizationEndpoint(authorizationEndpoint).setClientID(clientID).setAuthCodeRedirectURL(authzRedirectURL).build().execute();
        String msg = authorizationResponse.getResponseMessage();
        System.out.println(msg);
        int index = msg.indexOf("http");
        System.out.println("Received message=" + msg);
        String subString = msg.substring(index + redirectURL.length() + 1);
        Map map = OAuthUtils.decodeForm((String)subString);
        Assert.assertNotNull(map.get("code"));
    }
}

