/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.oauth.server.endpoint;

import java.io.File;
import java.net.URL;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.junit.After;
import org.picketbox.test.ldap.LDAPTestUtil;
import org.picketlink.oauth.PicketLinkOAuthApplication;
import org.picketlink.test.oauth.server.endpoint.EmbeddedWebServerBase;

public class EndpointTestBase
extends EmbeddedWebServerBase {
    protected LDAPTestUtil testUtil = null;

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.testUtil != null) {
            this.testUtil.tearDown();
        }
        Thread.sleep(1000L);
    }

    @Override
    protected void establishUserApps() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl == null) {
            tcl = this.getClass().getClassLoader();
        }
        String WEBAPPDIR = "oauth";
        String CONTEXTPATH = "/*";
        URL warUrl = tcl.getResource("oauth");
        String warUrlString = warUrl.toExternalForm();
        WebAppContext context = this.createWebApp("/*", warUrlString);
        context.setExtraClasspath(warUrlString + "/..");
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("javax.ws.rs.Application", PicketLinkOAuthApplication.class.getName());
        context.addServlet(servletHolder, "/*");
        this.server.setHandler((Handler)context);
        if (this.needLDAP()) {
            try {
                this.deleteApacheDSTmp();
                this.testUtil = new LDAPTestUtil();
                this.testUtil.setup();
                this.testUtil.createBaseDN("jboss", "dc=jboss,dc=org");
                this.testUtil.importLDIF("ldap/users.ldif");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean needLDAP() {
        return false;
    }

    protected void deleteApacheDSTmp() {
        String tempDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir=" + tempDir);
        System.out.println("Going to delete the server-work directory");
        File workDir = new File(tempDir + "/server-work");
        if (workDir != null) {
            this.recursiveDeleteDir(workDir);
        }
    }

    protected boolean recursiveDeleteDir(File dirPath) {
        if (dirPath.exists()) {
            File[] files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.recursiveDeleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        if (dirPath.exists()) {
            return dirPath.delete();
        }
        return true;
    }
}

