/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.oauth.workflow;

import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.oauth.OAuthUtils;
import org.picketlink.oauth.client.ClientOAuth;
import org.picketlink.oauth.messages.AccessTokenResponse;
import org.picketlink.oauth.messages.AuthorizationResponse;
import org.picketlink.oauth.messages.RegistrationResponse;
import org.picketlink.test.oauth.server.endpoint.EndpointTestBase;

public class OAuthWorkflowTestCase
extends EndpointTestBase {
    private String registrationEndpoint = "http://localhost:11080/oauth/register";
    private String appName = "Sample Application";
    private String appURL = "http://www.example.com";
    private String appIcon = "http://www.example.com/app.ico";
    private String appDescription = "Description of a Sample App";
    private String appRedirectURL = "http://www.example.com/redirect";
    private ClientOAuth client = new ClientOAuth();

    @Test
    public void testWorkflow() throws Exception {
        long parsedIssuedAt;
        ClientOAuth.RegistrationClient registration = this.client.registrationClient();
        RegistrationResponse registrationResponse = registration.setLocation(this.registrationEndpoint).setAppName(this.appName).setAppURL(this.appURL).setAppDescription(this.appDescription).setAppIcon(this.appIcon).setAppRedirectURL(this.appRedirectURL).build().execute();
        String clientID = registrationResponse.getClientID();
        Assert.assertNotNull((Object)clientID);
        String clientSecret = registrationResponse.getClientSecret();
        Assert.assertNotNull((Object)clientSecret);
        if (registrationResponse.getExpiresIn() != 3600L) {
            Assert.fail((String)"expires");
        }
        Assert.assertTrue(((parsedIssuedAt = Long.parseLong(registrationResponse.getIssued())) - new Date().getTime() < 50L ? 1 : 0) != 0);
        String authorizationEndpoint = "http://localhost:11080/oauth/authz";
        String authzRedirectURL = "http://localhost:11080/oauth/redirect";
        ClientOAuth.AuthorizationClient authorization = this.client.authorizationClient();
        AuthorizationResponse authorizationResponse = authorization.setAuthorizationEndpoint(authorizationEndpoint).setClientID(clientID).setAuthCodeRedirectURL(authzRedirectURL).build().execute();
        String msg = authorizationResponse.getResponseMessage();
        int index = msg.indexOf("http");
        String subString = msg.substring(index + authzRedirectURL.length() + 1);
        Map map = OAuthUtils.decodeForm((String)subString);
        String authorizationCode = (String)map.get("code");
        Assert.assertNotNull((Object)authorizationCode);
        String tokenEndpoint = "http://localhost:11080/oauth/token";
        String authCodeRedirectURL = "http://localhost:11080/oauth/register";
        ClientOAuth.AccessTokenClient tokenClient = this.client.tokenClient();
        AccessTokenResponse tokenResponse = tokenClient.setTokenEndpoint(tokenEndpoint).setAuthorizationCode(authorizationCode).setAuthCodeRedirectURL(authCodeRedirectURL).setClientID(clientID).setClientSecret(clientSecret).build().execute();
        String accessToken = tokenResponse.getAccessToken();
        long expiresIn = tokenResponse.getExpires();
        Assert.assertNotNull((String)"Validate access token is null?", (Object)accessToken);
        Assert.assertNotNull((String)"Validate expires is null?", (Object)expiresIn);
        String resourceURL = "http://localhost:11080/oauth/resource";
        ClientOAuth.ResourceClient resourceClient = this.client.resourceClient(accessToken).setResourceURL(resourceURL);
        InputStream inputStream = resourceClient.execute();
        String responseBody = OAuthUtils.saveStreamAsString((InputStream)inputStream);
        Assert.assertEquals((Object)"I am a Resource", (Object)responseBody);
    }
}

