/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.server.endpoint;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.picketlink.idm.IdentityManager;
import org.picketlink.oauth.messages.ErrorResponse;
import org.picketlink.oauth.messages.OAuthResponse;
import org.picketlink.oauth.server.endpoint.BaseEndpoint;
import org.picketlink.oauth.server.util.OAuthServerUtil;

@Path(value="/authz")
public class AuthorizationEndpoint
extends BaseEndpoint {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AuthorizationEndpoint.class.getName());

    @GET
    public Response authorize(@Context HttpServletRequest request) {
        if (this.context == null) {
            throw new RuntimeException("Servlet Context has not been injected");
        }
        if (this.identityManager == null) {
            try {
                this.identityManager = OAuthServerUtil.handleIdentityManager((ServletContext)this.context);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Identity Manager setup:", e);
                throw new RuntimeException(e);
            }
            if (this.identityManager == null) {
                throw new RuntimeException("Identity Manager has not been created");
            }
        }
        OAuthResponse response = null;
        try {
            response = OAuthServerUtil.authorizationCodeRequest((HttpServletRequest)request, (IdentityManager)this.identityManager);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "OAuth Server Authorization Processing:", e);
            return Response.serverError().build();
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return Response.status((int)response.getStatusCode()).entity((Object)errorResponse.asJSON()).build();
        }
        String location = response.getLocation();
        return Response.status((int)response.getStatusCode()).location(URI.create(location)).build();
    }
}

