/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.picketlink.oauth.client.ClientOAuth;
import org.picketlink.oauth.client.OAuthClientException;
import org.picketlink.oauth.messages.OAuthRequest;

public class ClientOAuth {
    protected OAuthRequest request;
    protected ObjectMapper objectMapper;

    public AuthorizationClient authorizationClient() {
        this.clear();
        return new AuthorizationClient(this);
    }

    public RegistrationClient registrationClient() {
        this.clear();
        return new RegistrationClient(this);
    }

    public AccessTokenClient tokenClient() {
        this.clear();
        return new AccessTokenClient(this);
    }

    public ResourceClient resourceClient(String accessToken) {
        this.clear();
        return new ResourceClient(this, accessToken);
    }

    private void clear() {
        this.request = null;
        this.objectMapper = null;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        }
        return this.objectMapper;
    }

    private InputStream executePost(String endpointURL, String body, boolean isJSON) throws OAuthClientException {
        InputStream inputStream;
        block5: {
            inputStream = null;
            try {
                URL resUrl = new URL(endpointURL);
                URLConnection urlConnection = resUrl.openConnection();
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setAllowUserInteraction(false);
                    if (isJSON) {
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    } else {
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    httpURLConnection.setRequestProperty("Content-Length", Integer.toString(body.length()));
                    OutputStream ost = httpURLConnection.getOutputStream();
                    PrintWriter pw = new PrintWriter(ost);
                    pw.print(body);
                    pw.flush();
                    pw.close();
                    inputStream = httpURLConnection.getResponseCode() == 400 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                    break block5;
                }
                throw new RuntimeException("Wrong url conn");
            }
            catch (Exception e) {
                throw new OAuthClientException((Throwable)e);
            }
        }
        return inputStream;
    }

    static /* synthetic */ InputStream access$000(ClientOAuth x0, String x1, String x2, boolean x3) throws OAuthClientException {
        return x0.executePost(x1, x2, x3);
    }

    static /* synthetic */ ObjectMapper access$100(ClientOAuth x0) {
        return x0.getObjectMapper();
    }
}

