/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.server.endpoint;

import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.picketlink.idm.IdentityManager;
import org.picketlink.oauth.messages.ErrorResponse;
import org.picketlink.oauth.messages.ResourceAccessRequest;
import org.picketlink.oauth.server.endpoint.BaseEndpoint;
import org.picketlink.oauth.server.util.OAuthServerUtil;

@Path(value="/resource")
public class ResourceEndpoint
extends BaseEndpoint {
    private static final long serialVersionUID = 1L;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/html"})
    public Response authorize(@Context HttpServletRequest request) throws URISyntaxException {
        super.setup();
        ResourceAccessRequest resourceAccessRequest = OAuthServerUtil.parseResourceRequest((HttpServletRequest)request);
        String accessToken = resourceAccessRequest.getAccessToken();
        boolean validateAccessToken = OAuthServerUtil.validateAccessToken((String)accessToken, (IdentityManager)this.identityManager);
        if (validateAccessToken) {
            return Response.ok().entity((Object)"I am a Resource").build();
        }
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatusCode(400);
        errorResponse.setError(ErrorResponse.ErrorResponseCode.invalid_client).setErrorDescription("accessToken not found");
        return Response.status((int)errorResponse.getStatusCode()).entity((Object)errorResponse.asJSON()).build();
    }
}

