/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModelUtil {
    static Set<String> numberPrimitiveTypes = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double"));
    static Set<String> booleanPrimitiveTypes = new HashSet<String>(Arrays.asList("boolean"));
    static Set<Class<?>> booleanTypes = new HashSet<Class>(Arrays.asList(Boolean.class));
    static Set<String> stringPrimitiveTypes = new HashSet<String>(Arrays.asList("char"));
    static Set<Class<?>> stringTypes = new HashSet<Class>(Arrays.asList(String.class));

    public static String getSimpleTypeSignature(Class<?> clazz, List<Class<?>> parameterClasses) {
        if (ModelUtil.isNumericType(clazz)) {
            return "number";
        }
        if (ModelUtil.isBooleanType(clazz)) {
            return "boolean";
        }
        if (ModelUtil.isStringType(clazz)) {
            return "string";
        }
        if (parameterClasses.isEmpty()) {
            return clazz.getCanonicalName();
        }
        String sign = clazz.getCanonicalName() + "<";
        for (int i = 0; i < parameterClasses.size() - 1; ++i) {
            sign = sign + parameterClasses.get(i).getCanonicalName() + ",";
        }
        sign = sign + parameterClasses.get(parameterClasses.size() - 1).getCanonicalName() + ">";
        return sign;
    }

    public static boolean isStringType(Class<?> clazz) {
        return stringPrimitiveTypes.contains(clazz.getName()) || stringTypes.contains(clazz);
    }

    public static boolean isBooleanType(Class<?> clazz) {
        return booleanPrimitiveTypes.contains(clazz.getName()) || booleanTypes.contains(clazz);
    }

    public static boolean isNumericType(Class<?> clazz) {
        return numberPrimitiveTypes.contains(clazz.getName()) || Number.class.isAssignableFrom(clazz);
    }
}

