/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.handler;

import java.util.ArrayList;
import java.util.List;
import org.projectodd.jrapidoc.exception.JrapidocExecutionException;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.handler.ModelHandler;

public class HandlerFactory {
    public static List<ModelHandler> createModelHandlers(List<String> handlerClassesToLoad, ClassLoader loader) throws JrapidocExecutionException {
        try {
            ArrayList<ModelHandler> handlers = new ArrayList<ModelHandler>();
            if (handlerClassesToLoad == null || handlerClassesToLoad.isEmpty()) {
                Logger.debug((String)"No model handler classes found", (String[])new String[0]);
                return handlers;
            }
            for (String clazzToLoad : handlerClassesToLoad) {
                Logger.info((String)"Loading class {0}", (String[])new String[]{clazzToLoad});
                Class<?> handler = loader.loadClass(clazzToLoad);
                Logger.debug((String)"Creating new instance from class {0} as ModelHandler", (String[])new String[]{clazzToLoad});
                handlers.add((ModelHandler)handler.newInstance());
            }
            return handlers;
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e, (String)"Class was not found", (String[])new String[0]);
            throw new JrapidocExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            Logger.error((String)e.getMessage(), (String[])new String[0]);
            throw new JrapidocExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logger.error((String)e.getMessage(), (String[])new String[0]);
            throw new JrapidocExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

