/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.type.provider;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Map;
import org.projectodd.jrapidoc.model.object.type.Type;
import org.projectodd.jrapidoc.model.type.provider.TypeProvider;
import org.projectodd.jrapidoc.model.type.provider.converter.JacksonToJrapidocProcessor;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

public class JacksonJsonProvider
extends TypeProvider {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected JacksonToJrapidocProcessor processor = new JacksonToJrapidocProcessor(this.objectMapper);

    @Override
    public Type createType(java.lang.reflect.Type genericType) {
        JavaType javaType = this.createJavaType(genericType);
        Type loadType = this.processor.loadType(javaType);
        return loadType;
    }

    @Override
    public Map<String, Type> getUsedTypes() {
        return JacksonToJrapidocProcessor.cache;
    }

    private JavaType createJavaType(java.lang.reflect.Type genericType) {
        ArrayType javaType = null;
        if (genericType instanceof Class) {
            if (((Class)genericType).isArray()) {
                javaType = this.objectMapper.getTypeFactory().constructArrayType(((Class)genericType).getComponentType());
            } else {
                ArrayList parameterClasses = new ArrayList();
                for (TypeVariable typeVariable : ((Class)genericType).getTypeParameters()) {
                    parameterClasses.add(JacksonJsonProvider.resolveBound((Class)genericType, typeVariable));
                }
                javaType = this.objectMapper.getTypeFactory().constructParametrizedType((Class)genericType, (Class)genericType, parameterClasses.toArray(new Class[0]));
            }
        } else if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            java.lang.reflect.Type[] genericTypes = paramType.getActualTypeArguments();
            for (int i = 0; i < genericTypes.length; ++i) {
                if (!(genericTypes[i] instanceof TypeVariableImpl)) continue;
                genericTypes[i] = ((TypeVariable)genericTypes[i]).getBounds()[0];
            }
            JavaType[] javaTypes = new JavaType[genericTypes.length];
            for (int i = 0; i < javaTypes.length; ++i) {
                javaTypes[i] = this.createJavaType(genericTypes[i]);
            }
            javaType = this.objectMapper.getTypeFactory().constructParametrizedType((Class)paramType.getRawType(), (Class)paramType.getRawType(), javaTypes);
        } else if (genericType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)genericType;
            java.lang.reflect.Type bound = typeVariable.getBounds()[0];
            javaType = this.createJavaType(bound);
        }
        return javaType;
    }

    protected static Class<?> resolveBound(Class<?> type, TypeVariable typeVariable) {
        java.lang.reflect.Type bound = typeVariable.getBounds()[0];
        if (bound instanceof Class) {
            return (Class)typeVariable.getBounds()[0];
        }
        if (bound instanceof TypeVariable) {
            for (TypeVariable<Class<?>> ancestor : type.getTypeParameters()) {
                if (!ancestor.equals(bound)) continue;
                return JacksonJsonProvider.resolveBound(type, (TypeVariable)bound);
            }
        }
        throw new IllegalStateException("Not yet implemented");
    }
}

