/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.introspector;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.projectodd.jrapidoc.exception.JrapidocExecutionException;
import org.projectodd.jrapidoc.exception.JrapidocFailureException;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.APIModel;
import org.projectodd.jrapidoc.model.generator.ModelGenerator;
import org.projectodd.jrapidoc.model.handler.HandlerException;
import org.projectodd.jrapidoc.model.handler.HandlerFactory;
import org.projectodd.jrapidoc.model.handler.ModelHandler;
import org.projectodd.jrapidoc.plugin.ConfigGroup;
import org.reflections.Reflections;

public abstract class AbstractIntrospector {
    public abstract void run(URL[] var1, List<ConfigGroup> var2, String var3, File var4, List<String> var5, Map<String, String> var6) throws JrapidocFailureException, JrapidocExecutionException;

    protected abstract String getDefaultModelFilename();

    void writeModelToFile(APIModel apiModel, File output) throws JrapidocExecutionException {
        Logger.info((String)"Writing model to file {0} started", (String[])new String[]{output.getAbsolutePath()});
        ModelGenerator.generateModel((APIModel)apiModel, (File)output);
        Logger.info((String)"Writing model to file {0} finished", (String[])new String[]{output.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processHandlers(List<ModelHandler> modelHandlers, APIModel apiModel) throws JrapidocFailureException, JrapidocExecutionException {
        if (modelHandlers == null || modelHandlers.isEmpty()) {
            Logger.debug((String)"No model handlers found", (String[])new String[0]);
            return;
        }
        for (ModelHandler modelHandler : modelHandlers) {
            try {
                Logger.info((String)"", (String[])new String[0]);
                Logger.info((String)"{0} model handler instance started", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
                Logger.info((String)"", (String[])new String[0]);
                modelHandler.handleModel(apiModel);
            }
            catch (HandlerException e) {
                block9: {
                    try {
                        if (e.getBehaviour() == HandlerException.Action.STOP_HANDLER_CURRENT) {
                            Logger.info((String)"Exception occurred in handler {0}, continue with processing next handler", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
                            break block9;
                        }
                        if (e.getBehaviour() == HandlerException.Action.STOP_HANDLERS) {
                            Logger.warn((Throwable)e, (String)"Exception occurred in handler {0}, skipping handlers processing", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
                            break block9;
                        }
                        if (e.getBehaviour() == HandlerException.Action.FAILURE_EXCEPTION) {
                            Logger.error((Throwable)e, (String)"Exception occurred in handler {0}, throwing {1}", (String[])new String[]{modelHandler.getClass().getCanonicalName(), MojoFailureException.class.getCanonicalName()});
                            throw new JrapidocFailureException(e.getMessage(), (Throwable)e);
                        }
                        if (e.getBehaviour() != HandlerException.Action.EXECUTION_EXCEPTION) break block9;
                        Logger.error((Throwable)e, (String)"Exception occurred in handler {0}, throwing {1}", (String[])new String[]{modelHandler.getClass().getCanonicalName(), MojoExecutionException.class.getCanonicalName()});
                        throw new JrapidocExecutionException(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        Logger.info((String)"", (String[])new String[0]);
                        Logger.info((String)"{0} model handler instance finished", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
                        Logger.info((String)"", (String[])new String[0]);
                        throw throwable;
                    }
                }
                Logger.info((String)"", (String[])new String[0]);
                Logger.info((String)"{0} model handler instance finished", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
                Logger.info((String)"", (String[])new String[0]);
                continue;
            }
            Logger.info((String)"", (String[])new String[0]);
            Logger.info((String)"{0} model handler instance finished", (String[])new String[]{modelHandler.getClass().getCanonicalName()});
            Logger.info((String)"", (String[])new String[0]);
        }
    }

    void addCustomInfo(Map<String, String> customInfo, APIModel.APIModelBuilder APIModelBuilder2) {
        if (customInfo != null && !customInfo.isEmpty()) {
            for (String key : customInfo.keySet()) {
                APIModelBuilder2.customInfo(key, customInfo.get(key));
            }
        }
    }

    List<ModelHandler> getModelHandlers(List<String> modelHandlerClasses, ClassLoader loader) throws JrapidocExecutionException {
        return HandlerFactory.createModelHandlers(modelHandlerClasses, (ClassLoader)loader);
    }

    void createOutputDir(File modelOutputDir) throws JrapidocExecutionException {
        if (!modelOutputDir.canWrite() && !modelOutputDir.mkdirs()) {
            Logger.error((String)"Directory {0} could not be created", (String[])new String[]{modelOutputDir.getAbsolutePath()});
            throw new JrapidocExecutionException("Directory could not be created");
        }
    }

    File getOutputFile(File modelTarget) throws JrapidocExecutionException {
        if (modelTarget.getName().endsWith(".json")) {
            return modelTarget;
        }
        return new File(modelTarget, this.getDefaultModelFilename());
    }

    Set<Class<?>> getScannedClasses(List<String> include, List<String> exclude, ClassLoader loader, Class<? extends Annotation> annotatedWith) {
        Reflections ref = this.getUnionOfIncludedPaths(include, loader);
        Set resourceClassesAll = ref.getTypesAnnotatedWith(annotatedWith);
        Logger.debug((String)"Service classes on path: {0}", (String[])new String[]{resourceClassesAll.toString()});
        return this.removeExcludedResourceClasses(exclude, resourceClassesAll);
    }

    URLClassLoader getProjectUrlClassLoader(URL[] urlsForClassloader) {
        return new URLClassLoader(urlsForClassloader, Thread.currentThread().getContextClassLoader());
    }

    Set<Class<?>> removeExcludedResourceClasses(List<String> exclude, Set<Class<?>> resourceClasses) {
        HashSet resourceClassesFiltered = new HashSet(resourceClasses);
        if (exclude == null || exclude.isEmpty()) {
            return resourceClasses;
        }
        for (String excludePath : exclude) {
            for (Class<?> resourceClass : resourceClasses) {
                if (!resourceClass.getCanonicalName().startsWith(excludePath)) continue;
                Logger.debug((String)"Removing class {0} from scan (it is in exclude property)", (String[])new String[]{resourceClass.getCanonicalName()});
                resourceClassesFiltered.remove(resourceClass);
            }
        }
        return resourceClassesFiltered;
    }

    Reflections getUnionOfIncludedPaths(List<String> include, ClassLoader loader) {
        Reflections ref;
        if (include == null || include.isEmpty()) {
            ref = new Reflections(new Object[]{"", loader});
        } else {
            ref = new Reflections(new Object[]{include.remove(0), loader});
            for (String includePath : include) {
                Logger.debug((String)MessageFormat.format("Adding path {0} to scan", includePath), (String[])new String[0]);
                ref.merge(new Reflections(new Object[]{includePath, loader}));
            }
        }
        return ref;
    }

    void checkIncludeConfigNotEmpty(List<String> includes) throws JrapidocExecutionException {
        if (includes == null) {
            Logger.error((String)"\"includes\" element in configuration is null", (String[])new String[0]);
            throw new JrapidocExecutionException("\"includes\" element in configuration is null");
        }
        if (includes.isEmpty()) {
            Logger.error((String)"\"includes\" element in configuration is empty", (String[])new String[0]);
            throw new JrapidocExecutionException("\"includes\" element in configuration is empty");
        }
        for (String include : includes) {
            if (!StringUtils.isEmpty((CharSequence)include)) continue;
            Logger.error((String)"\"include\" element in \"includes\" element is empty", (String[])new String[0]);
            throw new JrapidocExecutionException("\"include\" element in \"includes\" element is empty");
        }
    }

    void setUp(List<ConfigGroup> groups, File modelOutput) throws JrapidocExecutionException {
        this.createOutputDir(modelOutput.getParentFile());
        if (groups == null) {
            Logger.error((String)"\"groups\" element in configuration is null", (String[])new String[0]);
            throw new JrapidocExecutionException("\"groups\" element in configuration is null");
        }
        if (groups.isEmpty()) {
            Logger.error((String)"\"groups\" element in configuration is empty, nothing will be generated", (String[])new String[0]);
            throw new JrapidocExecutionException("\"groups\" element in configuration is empty, nothing will be generated");
        }
        for (ConfigGroup group : groups) {
            if (group == null) {
                Logger.error((String)"\"group\" element in \"groups\" element is null", (String[])new String[0]);
                throw new JrapidocExecutionException("\"group\" element in \"groups\" element is null");
            }
            if (StringUtils.isEmpty((CharSequence)group.getBaseUrl())) {
                Logger.error((String)"\"baseUrl\" element in \"group\" element is null", (String[])new String[0]);
                throw new JrapidocExecutionException("\"baseUrl\" element in \"group\" element is null");
            }
            this.checkIncludeConfigNotEmpty(group.getIncludes());
        }
    }
}

