/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client;

import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.TransactionalAcknowledger;
import org.projectodd.stilts.stomp.client.StompClient;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;

class ClientAcknowledger
implements Acknowledger,
TransactionalAcknowledger {
    private StompClient client;
    private Headers headers;
    private StompFrame.Version version;

    ClientAcknowledger(StompClient client, Headers headers, StompFrame.Version version) {
        this.client = client;
        this.headers = headers;
        this.version = version;
    }

    public void ack() throws Exception {
        this.ack(null);
    }

    public void ack(String transactionId) throws Exception {
        DefaultHeaders ackHeaders = new DefaultHeaders();
        ackHeaders.put((Object)"message-id", (Object)this.headers.get("message-id"));
        ackHeaders.put((Object)"subscription", (Object)this.headers.get("subscription"));
        if (transactionId == null) {
            transactionId = this.headers.get("transaction");
        }
        if (transactionId != null) {
            ackHeaders.put((Object)"transaction", (Object)transactionId);
        }
        this.client.sendFrame(StompFrames.newAckFrame((Headers)ackHeaders));
    }

    public void nack() throws Exception {
        this.nack(null);
    }

    public void nack(String transactionId) throws Exception {
        if (this.version.isBefore(StompFrame.Version.VERSION_1_1)) {
            throw new StompException("Cannot nack prior to STOMP version 1.1.");
        }
        DefaultHeaders nackHeaders = new DefaultHeaders();
        nackHeaders.put((Object)"message-id", (Object)this.headers.get("message-id"));
        nackHeaders.put((Object)"subscription", (Object)this.headers.get("subscription"));
        if (transactionId == null) {
            transactionId = this.headers.get("transaction");
        }
        if (transactionId != null) {
            nackHeaders.put((Object)"transaction", (Object)transactionId);
        }
        this.client.sendFrame(StompFrames.newNackFrame((Headers)nackHeaders));
    }
}

