/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.projectodd.stilts.stomp.client.StompClient;
import org.projectodd.stilts.stomp.client.protocol.ClientContext;
import org.projectodd.stilts.stomp.protocol.StompControlFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;

public class StompDisconnectionNegotiator
implements ChannelDownstreamHandler,
ChannelUpstreamHandler {
    private ClientContext clientContext;
    private String receiptId;
    private ChannelStateEvent closeRequest;

    public StompDisconnectionNegotiator(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        StompControlFrame frame;
        Object message;
        if (this.closeRequest != null && e instanceof MessageEvent && (message = ((MessageEvent)e).getMessage()) instanceof StompControlFrame && (frame = (StompControlFrame)message).getCommand() == StompFrame.Command.RECEIPT && frame.getHeader("receipt-id").equals(this.receiptId)) {
            ctx.sendDownstream((ChannelEvent)this.closeRequest);
            this.clientContext.setConnectionState(StompClient.State.DISCONNECTED);
            return;
        }
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent && !Boolean.TRUE.equals(((ChannelStateEvent)e).getValue())) {
            this.closeRequested(ctx, (ChannelStateEvent)e);
            return;
        }
        ctx.sendDownstream(e);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.closeRequest = e;
        StompFrame closeFrame = StompFrames.newDisconnectFrame();
        this.receiptId = closeFrame.getHeader("receipt");
        Channels.write((Channel)ctx.getChannel(), (Object)closeFrame);
    }
}

