/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.helpers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.client.MessageHandler;

public class MessageAccumulator
implements MessageHandler {
    private static Logger log = Logger.getLogger(MessageAccumulator.class);
    private ArrayList<StompMessage> messages;
    private boolean shouldAck;
    private boolean shouldNack;

    public MessageAccumulator() {
        this(false, false);
    }

    public MessageAccumulator(boolean shouldAck, boolean shouldNack) {
        this.shouldAck = shouldAck;
        this.shouldNack = shouldNack;
        this.messages = new ArrayList();
    }

    public List<String> messageIds() {
        ArrayList<String> messageIds = new ArrayList<String>();
        for (StompMessage each : this.messages) {
            messageIds.add(each.getHeaders().get("message-id"));
        }
        return messageIds;
    }

    @Override
    public void handle(StompMessage message) {
        this.messages.add(message);
        if (this.shouldAck) {
            try {
                message.ack();
            }
            catch (StompException e) {
                log.errorf((Throwable)e, "Cannot ack message: %s", (Object)message);
            }
        } else if (this.shouldNack) {
            try {
                message.nack();
            }
            catch (StompException e) {
                log.errorf((Throwable)e, "Cannot nack message: %s", (Object)message);
            }
        }
    }

    public List<StompMessage> getMessages() {
        return this.messages;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        return this.messages.toString();
    }
}

