/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.projectodd.stilts.stomp.client.protocol.ClientContext;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;

public abstract class AbstractClientHandler
extends SimpleChannelUpstreamHandler {
    private static Logger log = Logger.getLogger(AbstractClientHandler.class);
    private ClientContext clientContext;

    public AbstractClientHandler(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    protected ChannelFuture sendFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        return channelContext.getChannel().write((Object)frame);
    }

    protected ChannelFuture sendError(ChannelHandlerContext channelContext, String message) {
        return this.sendFrame(channelContext, StompFrames.newErrorFrame((String)message, null));
    }

    protected void sendErrorAndClose(ChannelHandlerContext channelContext, String message) {
        ChannelFuture future = this.sendError(channelContext, message);
        future.addListener(ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error((Object)"An error occurred", e.getCause());
    }
}

