/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client.protocol.websockets;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.projectodd.stilts.stomp.client.protocol.websockets.WebSocketHttpResponseDecoder;
import org.projectodd.stilts.stomp.protocol.websocket.Handshake;
import org.projectodd.stilts.stomp.protocol.websocket.WebSocketDisconnectionNegotiator;

public class WebSocketConnectionNegotiator
extends SimpleChannelUpstreamHandler {
    private static final Logger log = Logger.getLogger((String)"stomp.proto.client.websocket");
    private InetSocketAddress serverAddress;
    private boolean useSSL;
    private Handshake handshake;
    private ChannelStateEvent connectedEvent;

    public WebSocketConnectionNegotiator(InetSocketAddress serverAddress, Handshake handshake, boolean useSSL) throws NoSuchAlgorithmException {
        this.serverAddress = serverAddress;
        this.handshake = handshake;
        this.useSSL = useSSL;
    }

    public void channelConnected(ChannelHandlerContext context, ChannelStateEvent e) throws Exception {
        URI uri = new URI((this.useSSL ? "wss" : "ws") + "://" + this.serverAddress.getHostName() + ":" + this.serverAddress.getPort() + "/");
        HttpRequest request = this.handshake.generateRequest(uri);
        this.connectedEvent = e;
        Channel channel = context.getChannel();
        Channels.write((Channel)channel, (Object)request);
    }

    public void messageReceived(ChannelHandlerContext context, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e.getMessage();
            if (this.handshake.isComplete(response)) {
                ChannelPipeline pipeline = context.getPipeline();
                if (pipeline.get(WebSocketHttpResponseDecoder.class) != null) {
                    pipeline.replace(WebSocketHttpResponseDecoder.class, "websockets-decoder", this.handshake.newDecoder());
                } else {
                    pipeline.addFirst("websockets-decoder", this.handshake.newDecoder());
                }
                if (pipeline.get(HttpRequestEncoder.class) != null) {
                    pipeline.replace(HttpRequestEncoder.class, "websockets-encoder", this.handshake.newEncoder());
                } else {
                    pipeline.addAfter("websockets-decoder", "websockets-encoder", this.handshake.newEncoder());
                }
                ChannelHandler[] additionalHandlers = this.handshake.newAdditionalHandlers();
                String currentTail = "websockets-decoder";
                for (ChannelHandler each : additionalHandlers) {
                    String handlerName = "additional-" + each.getClass().getSimpleName();
                    pipeline.addAfter(currentTail, handlerName, each);
                    currentTail = handlerName;
                }
                context.sendUpstream((ChannelEvent)this.connectedEvent);
                pipeline.replace((ChannelHandler)this, "websocket-disconnection-negotiator", (ChannelHandler)new WebSocketDisconnectionNegotiator());
            }
        } else {
            super.messageReceived(context, e);
        }
    }
}

