/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.StompMessages;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrameEncoder;
import org.projectodd.stilts.stomp.protocol.StompFrames;

public class StompFrameEncoderTest {
    private EncoderEmbedder<ChannelBuffer> encoder;

    @Before
    public void setUp() {
        this.encoder = new EncoderEmbedder(new ChannelDownstreamHandler[]{new StompFrameEncoder()});
    }

    @Test
    public void testAckFrame() {
        StompFrame frame = StompFrames.newAckFrame((Headers)new DefaultHeaders());
        frame.setHeader("subscription", "subscription-42");
        frame.setHeader("message-id", "message-84");
        boolean result = this.encoder.offer((Object)frame);
        Assert.assertTrue((boolean)result);
        List<String> lines = this.getFrameLines();
        Assert.assertEquals((Object)"ACK", (Object)lines.get(0));
        this.assertContainsLine("subscription:subscription-42", lines);
        this.assertContainsLine("message-id:message-84", lines);
    }

    @Test
    public void testConnectedFrame() {
        StompFrame frame = StompFrames.newConnectedFrame((String)"session-42", (StompFrame.Version)StompFrame.Version.VERSION_1_1);
        boolean result = this.encoder.offer((Object)frame);
        Assert.assertTrue((boolean)result);
        List<String> lines = this.getFrameLines();
        Assert.assertEquals((Object)"CONNECTED", (Object)lines.get(0));
        this.assertContainsLine("session:session-42", lines);
        this.assertContainsLine("version:1.1", lines);
    }

    @Test
    public void testErrorFrame() {
        StompMessage message = StompMessages.createStompMessage();
        message.getHeaders().put("receipt", "some-frame");
        StompFrame inReplyTo = StompFrames.newSendFrame((StompMessage)message);
        StompFrame frame = StompFrames.newErrorFrame((String)"It broke", (StompFrame)inReplyTo);
        boolean result = this.encoder.offer((Object)frame);
        Assert.assertTrue((boolean)result);
        List<String> lines = this.getFrameLines();
        Assert.assertEquals((Object)"ERROR", (Object)lines.get(0));
        this.assertContainsLine("receipt-id:some-frame", lines);
        this.assertContainsContent("It broke", lines);
    }

    protected void assertContainsLine(String expected, List<String> lines) {
        Assert.assertTrue((lines.indexOf(expected) >= 0 ? 1 : 0) != 0);
    }

    protected void assertContainsContent(String expected, List<String> lines) {
        String actual = lines.get(lines.size() - 1);
        Assert.assertEquals((Object)expected, (Object)actual.substring(0, expected.length()));
        byte[] bytes = actual.getBytes();
        Assert.assertEquals((long)0L, (long)bytes[bytes.length - 1]);
    }

    protected List<String> getFrameLines() {
        ChannelBuffer buffer = (ChannelBuffer)this.encoder.poll();
        Assert.assertNotNull((Object)buffer);
        ArrayList<String> lines = new ArrayList<String>();
        String content = buffer.toString(Charset.forName("UTF-8"));
        StringTokenizer tokenizer = new StringTokenizer(content, "\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return lines;
    }
}

