/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.nio.charset.Charset;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class DebugHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final Logger log = Logger.getLogger(DebugHandler.class);
    private String scope;

    public DebugHandler(String scope) {
        this.scope = scope;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        log.tracef("%s >>outbound>> %s :: %s ** %s", new Object[]{this.scope, ctx.getChannel(), e, e.getClass()});
        this.dump(">>outbound>>", e);
        ctx.sendDownstream(e);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        log.tracef("%s <<inbound<< %s :: %s ** %s", new Object[]{this.scope, ctx.getChannel(), e, e.getClass()});
        this.dump("<<inbound<<", e);
        ctx.sendUpstream(e);
    }

    protected void dump(String direction, ChannelEvent e) {
        if (e instanceof ExceptionEvent) {
            this.dump(direction, (ExceptionEvent)e);
        } else if (e instanceof MessageEvent) {
            this.dump(direction, (MessageEvent)e);
        }
    }

    protected void dump(String direction, ExceptionEvent e) {
        log.errorf(e.getCause(), "%s %s %s :: EXCEPTION", (Object)this.scope, (Object)direction, (Object)e.getChannel());
    }

    protected void dump(String direction, MessageEvent e) {
        Object message = e.getMessage();
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buffer = (ChannelBuffer)message;
            log.tracef("%s %s %s :: MESSAGE+BUFFER %s", new Object[]{this.scope, direction, e.getChannel(), buffer.toString(Charset.forName("UTF-8"))});
        } else if (message instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)message;
            log.tracef("%s %s %s :: MESSAGE+HTTP_RESPONSE %s", new Object[]{this.scope, direction, e.getChannel(), response});
            log.tracef("%s %s %s :: MESSAGE+HTTP_RESPONSE+BUFFER %s", new Object[]{this.scope, direction, e.getChannel(), response.getContent()});
        } else {
            log.tracef("%s %s %s :: MESSAGE %s", new Object[]{this.scope, direction, e.getChannel(), message});
        }
    }
}

