/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import org.jboss.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.projectodd.stilts.stomp.StompMessageFactory;
import org.projectodd.stilts.stomp.protocol.StompContentFrame;
import org.projectodd.stilts.stomp.protocol.StompFrame;

public class StompMessageDecoder
extends OneToOneDecoder {
    private static Logger log = Logger.getLogger(StompMessageDecoder.class);
    private StompMessageFactory messageFactory;

    public StompMessageDecoder(StompMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof StompContentFrame) {
            StompContentFrame frame = (StompContentFrame)msg;
            boolean isError = false;
            if (frame.getCommand() == StompFrame.Command.ERROR) {
                isError = true;
            }
            return this.messageFactory.createMessage(frame.getHeaders(), frame.getContent(), isError);
        }
        return msg;
    }
}

