/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol.longpoll;

import java.nio.charset.Charset;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrameCodec;

public class HttpStompFrameDecoder
extends OneToOneDecoder {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Logger log = Logger.getLogger(HttpStompFrameDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        String contentType;
        if (msg instanceof HttpMessage && (contentType = ((HttpMessage)msg).getHeader("content-type")) != null) {
            int semiLoc = contentType.indexOf(";");
            if (semiLoc > 0) {
                contentType = contentType.substring(0, semiLoc);
            }
            if ((contentType = contentType.trim()).equals("text/stomp")) {
                HttpMessage httpMessage = (HttpMessage)msg;
                ChannelBuffer buffer = httpMessage.getContent();
                StompFrame stompFrame = StompFrameCodec.INSTANCE.decode(buffer);
                return stompFrame;
            }
        }
        return msg;
    }
}

