/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.simple;

import java.util.HashMap;
import java.util.Map;
import org.projectodd.stilts.MessageSink;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomplet.Subscriber;
import org.projectodd.stilts.stomplet.helpers.AbstractStomplet;
import org.projectodd.stilts.stomplet.simple.SubscriberList;

public abstract class SimpleSubscribableStomplet
extends AbstractStomplet
implements MessageSink {
    private Map<String, SubscriberList> destinations = new HashMap<String, SubscriberList>();

    public void send(StompMessage message) throws StompException {
        this.onMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Subscriber subscriber) throws StompException {
        Map<String, SubscriberList> map = this.destinations;
        synchronized (map) {
            SubscriberList destinationSubscribers = this.destinations.get(subscriber.getDestination());
            if (destinationSubscribers == null) {
                destinationSubscribers = new SubscriberList();
                this.destinations.put(subscriber.getDestination(), destinationSubscribers);
            }
            destinationSubscribers.addSubscriber(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnsubscribe(Subscriber subscriber) throws StompException {
        Map<String, SubscriberList> map = this.destinations;
        synchronized (map) {
            SubscriberList destinationSubscribers = this.destinations.get(subscriber.getDestination());
            if (destinationSubscribers != null) {
                destinationSubscribers.removeSubscriber(subscriber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToAllSubscribers(StompMessage message) throws StompException {
        Map<String, SubscriberList> map = this.destinations;
        synchronized (map) {
            SubscriberList destinationSubscribers = this.destinations.get(message.getDestination());
            if (destinationSubscribers != null) {
                destinationSubscribers.sendToAllSubscribers(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToOneSubscriber(StompMessage message) throws StompException {
        Map<String, SubscriberList> map = this.destinations;
        synchronized (map) {
            SubscriberList destinationSubscribers = this.destinations.get(message.getDestination());
            if (destinationSubscribers != null) {
                destinationSubscribers.sendToOneSubscriber(message);
            }
        }
    }
}

