/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.cdi.container;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.container.NoSuchStompletException;
import org.projectodd.stilts.stomplet.container.SimpleStompletContainer;

public class WeldStompletContainer
extends SimpleStompletContainer {
    private ClassLoader classLoader;
    private BeanManager beanManager;

    public WeldStompletContainer(ClassLoader classLoader, BeanManager beanManager) {
        this.classLoader = classLoader;
        this.beanManager = beanManager;
    }

    public void addStomplet(String pattern, String className) throws StompException {
        this.addStomplet(pattern, className, new HashMap<String, String>());
    }

    public void addStomplet(String pattern, String className, Map<String, String> properties) throws StompException {
        try {
            Stomplet stomplet = this.newStomplet(className);
            this.addStomplet(pattern, stomplet, properties);
        }
        catch (ClassNotFoundException e) {
            throw new StompException((Throwable)e);
        }
    }

    protected Stomplet newStomplet(String className) throws ClassNotFoundException, NoSuchStompletException {
        Class<?> stompletImplClass = this.classLoader.loadClass(className);
        Set beans = this.beanManager.getBeans(stompletImplClass, new Annotation[0]);
        if (beans.isEmpty()) {
            throw new NoSuchStompletException(className);
        }
        Bean bean = this.beanManager.resolve(beans);
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        Stomplet stomplet = (Stomplet)this.beanManager.getReference(bean, stompletImplClass, creationalContext);
        return stomplet;
    }
}

