/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Component
extends Resource {
    private String name = null;
    private String description = null;
    private boolean isAssigneeTypeValid = false;

    protected Component(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.name = Field.getString(map.get((Object)"name"));
        this.description = Field.getString(map.get((Object)"description"));
        this.isAssigneeTypeValid = Field.getBoolean(map.get((Object)"isAssigneeTypeValid"));
    }

    public static Component get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Component.getRestUri(id));
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve component " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Component(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAssigneeTypeValid() {
        return this.isAssigneeTypeValid;
    }

    private static String getRestUri(String id) {
        return Component.getBaseUri() + "component/" + (id != null ? id : "");
    }

    public static FluentCreate create(RestClient restclient, String project) {
        FluentCreate fc = new FluentCreate(restclient, project);
        return fc;
    }

    public void delete() throws JiraException {
        try {
            this.restclient.delete(Component.getRestUri(this.id));
        }
        catch (Exception ex) {
            throw new JiraException("Failed to delete component " + this.id, ex);
        }
    }

    public static final class FluentCreate {
        RestClient restclient = null;
        JSONObject req = new JSONObject();

        private FluentCreate(RestClient restclient, String project) {
            this.restclient = restclient;
            this.req.put("project", project);
        }

        public FluentCreate name(String name) {
            this.req.put("name", name);
            return this;
        }

        public FluentCreate description(String description) {
            this.req.put("description", description);
            return this;
        }

        public FluentCreate leadUserName(String leadUserName) {
            this.req.put("leadUserName", leadUserName);
            return this;
        }

        public FluentCreate assigneeType(String assigneeType) {
            this.req.put("assigneeType", assigneeType);
            return this;
        }

        public FluentCreate assigneeTypeValue(boolean assigneeTypeValid) {
            this.req.put("isAssigneeTypeValid", (Object)assigneeTypeValid);
            return this;
        }

        public Component execute() throws JiraException {
            JSON result = null;
            try {
                result = this.restclient.post(Component.getRestUri(null), (JSON)this.req);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to create issue", ex);
            }
            if (!(result instanceof JSONObject && ((JSONObject)result).containsKey("id") && ((JSONObject)result).get("id") instanceof String)) {
                throw new JiraException("Unexpected result on create component");
            }
            return new Component(this.restclient, (JSONObject)result);
        }
    }
}

