/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.ProjectCategory;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.rcarz.jiraclient.Version;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class Project
extends Resource {
    private Map<String, String> avatarUrls = null;
    private String key = null;
    private String name = null;
    private String description = null;
    private User lead = null;
    private String assigneeType = null;
    private List<Component> components = null;
    private List<IssueType> issueTypes = null;
    private List<Version> versions = null;
    private Map<String, String> roles = null;
    private ProjectCategory category = null;
    private String email = null;

    protected Project(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.avatarUrls = Field.getMap(String.class, String.class, map.get((Object)"avatarUrls"));
        this.key = Field.getString(map.get((Object)"key"));
        this.name = Field.getString(map.get((Object)"name"));
        this.description = Field.getString(map.get((Object)"description"));
        this.lead = Field.getResource(User.class, map.get((Object)"lead"), this.restclient);
        this.assigneeType = Field.getString(map.get((Object)"assigneeType"));
        this.components = Field.getResourceArray(Component.class, map.get((Object)"components"), this.restclient);
        this.issueTypes = Field.getResourceArray(IssueType.class, map.containsKey("issueTypes") ? map.get((Object)"issueTypes") : map.get((Object)"issuetypes"), this.restclient);
        this.versions = Field.getResourceArray(Version.class, map.get((Object)"versions"), this.restclient);
        this.roles = Field.getMap(String.class, String.class, map.get((Object)"roles"));
        this.category = Field.getResource(ProjectCategory.class, map.get((Object)"projectCategory"), this.restclient);
        this.email = Field.getString(map.get((Object)"email"));
    }

    public static Project get(RestClient restclient, String key) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Project.getBaseUri() + "project/" + key);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve project " + key, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Project(restclient, (JSONObject)result);
    }

    public static List<Project> getAll(RestClient restclient) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Project.getBaseUri() + "project");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve projects", ex);
        }
        if (!(result instanceof JSONArray)) {
            throw new JiraException("JSON payload is malformed");
        }
        return Field.getResourceArray(Project.class, result, restclient);
    }

    public List<User> getAssignableUsers() throws JiraException {
        JSON result = null;
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("project", this.key);
            URI searchUri = this.restclient.buildURI(Project.getBaseUri() + "user/assignable/search", queryParams);
            result = this.restclient.get(searchUri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve assignable users", ex);
        }
        if (!(result instanceof JSONArray)) {
            throw new JiraException("JSON payload is malformed");
        }
        return Field.getResourceArray(User.class, result, this.restclient);
    }

    public String toString() {
        return this.getName();
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public User getLead() {
        return this.lead;
    }

    public String getAssigneeType() {
        return this.assigneeType;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public List<IssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public ProjectCategory getCategory() {
        return this.category;
    }

    public String getEmail() {
        return this.email;
    }
}

