/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.RestException;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private HttpClient httpClient = null;
    private ICredentials creds = null;
    private URI uri = null;

    public RestClient(HttpClient httpclient, URI uri) {
        this(httpclient, null, uri);
    }

    public RestClient(HttpClient httpclient, ICredentials creds, URI uri) {
        this.httpClient = httpclient;
        this.creds = creds;
        this.uri = uri;
    }

    public URI buildURI(String path) throws URISyntaxException {
        return this.buildURI(path, null);
    }

    public URI buildURI(String path, Map<String, String> params) throws URISyntaxException {
        URIBuilder ub = new URIBuilder(this.uri);
        ub.setPath(ub.getPath() + path);
        if (params != null) {
            for (Map.Entry<String, String> ent : params.entrySet()) {
                ub.addParameter(ent.getKey(), ent.getValue());
            }
        }
        return ub.build();
    }

    private JSON request(HttpRequestBase req) throws RestException, IOException {
        req.addHeader("Accept", "application/json");
        if (this.creds != null) {
            this.creds.authenticate(req);
        }
        HttpResponse resp = this.httpClient.execute(req);
        HttpEntity ent = resp.getEntity();
        StringBuilder result = new StringBuilder();
        if (ent != null) {
            String encoding = null;
            if (ent.getContentEncoding() != null) {
                encoding = ent.getContentEncoding().getValue();
            }
            if (encoding == null) {
                HeaderElement[] contentTypeElements;
                Header contentTypeHeader = resp.getFirstHeader("Content-Type");
                for (HeaderElement he : contentTypeElements = contentTypeHeader.getElements()) {
                    NameValuePair nvp = he.getParameterByName("charset");
                    if (nvp == null) continue;
                    encoding = nvp.getValue();
                }
            }
            InputStreamReader isr = encoding != null ? ("gzip".equals(encoding) ? new InputStreamReader(new GZIPInputStream(ent.getContent())) : new InputStreamReader(ent.getContent(), encoding)) : new InputStreamReader(ent.getContent());
            BufferedReader br = new BufferedReader(isr);
            String line = "";
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            isr.close();
            br.close();
            isr = null;
            br = null;
        }
        EntityUtils.consumeQuietly(ent);
        StatusLine sl = resp.getStatusLine();
        if (sl.getStatusCode() >= 300) {
            throw new RestException(sl.getReasonPhrase(), sl.getStatusCode(), result.toString(), resp.getAllHeaders());
        }
        return result.length() > 0 ? JSONSerializer.toJSON(result.toString()) : null;
    }

    private JSON request(HttpEntityEnclosingRequestBase req, String payload) throws RestException, IOException {
        if (payload != null) {
            StringEntity ent = null;
            ent = new StringEntity(payload, "UTF-8");
            ent.setContentType("application/json");
            req.addHeader("Content-Type", "application/json");
            req.setEntity(ent);
        }
        return this.request(req);
    }

    private JSON request(HttpEntityEnclosingRequestBase req, File file) throws RestException, IOException {
        if (file != null) {
            File fileUpload = file;
            req.setHeader("X-Atlassian-Token", "nocheck");
            MultipartEntity ent = new MultipartEntity();
            ent.addPart("file", new FileBody(fileUpload));
            req.setEntity(ent);
        }
        return this.request(req);
    }

    private JSON request(HttpEntityEnclosingRequestBase req, Issue.NewAttachment ... attachments) throws RestException, IOException {
        if (attachments != null) {
            req.setHeader("X-Atlassian-Token", "nocheck");
            MultipartEntity ent = new MultipartEntity();
            for (Issue.NewAttachment attachment : attachments) {
                String filename = attachment.getFilename();
                Object content = attachment.getContent();
                if (content instanceof byte[]) {
                    ent.addPart("file", new ByteArrayBody((byte[])content, filename));
                    continue;
                }
                if (content instanceof InputStream) {
                    ent.addPart("file", new InputStreamBody((InputStream)content, filename));
                    continue;
                }
                if (content instanceof File) {
                    ent.addPart("file", new FileBody((File)content, filename));
                    continue;
                }
                if (content == null) {
                    throw new IllegalArgumentException("Missing content for the file " + filename);
                }
                throw new IllegalArgumentException("Expected file type byte[], java.io.InputStream or java.io.File but provided " + content.getClass().getName() + " for the file " + filename);
            }
            req.setEntity(ent);
        }
        return this.request(req);
    }

    private JSON request(HttpEntityEnclosingRequestBase req, JSON payload) throws RestException, IOException {
        return this.request(req, payload != null ? payload.toString() : null);
    }

    public JSON delete(URI uri) throws RestException, IOException {
        return this.request(new HttpDelete(uri));
    }

    public JSON delete(String path) throws RestException, IOException, URISyntaxException {
        return this.delete(this.buildURI(path));
    }

    public JSON get(URI uri) throws RestException, IOException {
        return this.request(new HttpGet(uri));
    }

    public JSON get(String path, Map<String, String> params) throws RestException, IOException, URISyntaxException {
        return this.get(this.buildURI(path, params));
    }

    public JSON get(String path) throws RestException, IOException, URISyntaxException {
        return this.get(path, null);
    }

    public JSON post(URI uri, JSON payload) throws RestException, IOException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(uri), payload);
    }

    public JSON post(URI uri, String payload) throws RestException, IOException {
        String quoted = null;
        if (payload != null && !payload.equals(new JSONObject())) {
            quoted = String.format("\"%s\"", payload);
        }
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(uri), quoted);
    }

    public JSON post(String path, JSON payload) throws RestException, IOException, URISyntaxException {
        return this.post(this.buildURI(path), payload);
    }

    public JSON post(String path) throws RestException, IOException, URISyntaxException {
        return this.post(this.buildURI(path), (JSON)new JSONObject());
    }

    public JSON post(String path, File file) throws RestException, IOException, URISyntaxException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(this.buildURI(path)), file);
    }

    public JSON post(String path, Issue.NewAttachment ... attachments) throws RestException, IOException, URISyntaxException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(this.buildURI(path)), attachments);
    }

    public JSON put(URI uri, JSON payload) throws RestException, IOException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPut(uri), payload);
    }

    public JSON put(String path, JSON payload) throws RestException, IOException, URISyntaxException {
        return this.put(this.buildURI(path), payload);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

