/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.rcarz.jiraclient.agile.User;
import net.sf.json.JSONObject;

public class Worklog
extends AgileResource {
    private User author;
    private String comment;
    private Date created;
    private Date updated;
    private User updateAuthor;
    private Date started;
    private String timeSpent;
    private long timeSpentSeconds;

    public Worklog(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    @Override
    void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.author = this.getSubResource(User.class, json, "author");
        this.comment = Field.getString(json.get("comment"));
        this.created = Field.getDateTime(json.get("created"));
        this.updated = Field.getDateTime(json.get("updated"));
        this.updateAuthor = this.getSubResource(User.class, json, "updateAuthor");
        this.started = Field.getDateTime(json.get("started"));
        this.timeSpent = Field.getString(json.get("timeSpent"));
        this.timeSpentSeconds = Field.getLong(json.get("timeSpentSeconds"));
    }

    @Override
    public String toString() {
        return String.format("%s{id=%s, comment='%s'}", this.getClass().getSimpleName(), this.getId(), this.getComment());
    }

    public User getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public User getUpdateAuthor() {
        return this.updateAuthor;
    }

    public Date getStarted() {
        return this.started;
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }
}

