/*
 * Decompiled with CFR 0.152.
 */
package org.qetools.task_generator;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.text.lookup.StringLookup;

public class PropertiesLookup
implements StringLookup {
    private Properties props;

    public PropertiesLookup(List<File> propertyFiles) {
        this.props = new Properties();
        propertyFiles.forEach(file -> {
            try {
                this.props.load(new FileReader((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load properties from '" + file.getAbsolutePath() + "'", e);
            }
        });
    }

    public PropertiesLookup(Properties props) {
        this.props = props;
    }

    @Override
    public String lookup(String key) {
        return System.getProperty(key, (String)this.props.get(key));
    }
}

