/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.rcarz.jiraclient.Attachment;
import net.rcarz.jiraclient.ChangeLog;
import net.rcarz.jiraclient.Comment;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.IssueLink;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.RemoteLink;
import net.rcarz.jiraclient.Resolution;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.Security;
import net.rcarz.jiraclient.Status;
import net.rcarz.jiraclient.TimeTracking;
import net.rcarz.jiraclient.Transition;
import net.rcarz.jiraclient.User;
import net.rcarz.jiraclient.Version;
import net.rcarz.jiraclient.Votes;
import net.rcarz.jiraclient.Watches;
import net.rcarz.jiraclient.WorkLog;
import net.rcarz.utils.WorklogUtils;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class Issue
extends Resource {
    private String key = null;
    private Map fields = null;
    private User assignee = null;
    private List<Attachment> attachments = null;
    private ChangeLog changeLog = null;
    private List<Comment> comments = null;
    private List<Component> components = null;
    private String description = null;
    private Date dueDate = null;
    private List<Version> fixVersions = null;
    private List<IssueLink> issueLinks = null;
    private IssueType issueType = null;
    private List<String> labels = null;
    private Issue parent = null;
    private Priority priority = null;
    private Project project = null;
    private User reporter = null;
    private Resolution resolution = null;
    private Date resolutionDate = null;
    private Status status = null;
    private List<Issue> subtasks = null;
    private String summary = null;
    private TimeTracking timeTracking = null;
    private List<Version> versions = null;
    private Votes votes = null;
    private Watches watches = null;
    private List<WorkLog> workLogs = null;
    private Integer timeEstimate = null;
    private Integer timeSpent = null;
    private Date createdDate = null;
    private Date updatedDate = null;
    private Security security = null;

    public static int count(RestClient restclient, String jql) throws JiraException {
        String j = jql;
        JSON result = null;
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("jql", j);
            queryParams.put("maxResults", "1");
            URI searchUri = restclient.buildURI(Issue.getBaseUri() + "search", queryParams);
            result = restclient.get(searchUri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to search issues", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        Map map = (Map)((Object)result);
        return Field.getInteger(map.get("total"));
    }

    protected Issue(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.id = Field.getString(map.get((Object)"id"));
        this.self = Field.getString(map.get((Object)"self"));
        this.key = Field.getString(map.get((Object)"key"));
        this.fields = (Map)map.get((Object)"fields");
        if (this.fields == null) {
            return;
        }
        this.assignee = Field.getResource(User.class, this.fields.get("assignee"), this.restclient);
        this.attachments = Field.getResourceArray(Attachment.class, this.fields.get("attachment"), this.restclient);
        this.changeLog = Field.getResource(ChangeLog.class, map.get((Object)"changelog"), this.restclient);
        this.comments = Field.getComments(this.fields.get("comment"), this.restclient, this.key);
        this.components = Field.getResourceArray(Component.class, this.fields.get("components"), this.restclient);
        this.description = Field.getString(this.fields.get("description"));
        this.dueDate = Field.getDate(this.fields.get("duedate"));
        this.fixVersions = Field.getResourceArray(Version.class, this.fields.get("fixVersions"), this.restclient);
        this.issueLinks = Field.getResourceArray(IssueLink.class, this.fields.get("issuelinks"), this.restclient);
        this.issueType = Field.getResource(IssueType.class, this.fields.get("issuetype"), this.restclient);
        this.labels = Field.getStringArray(this.fields.get("labels"));
        this.parent = Field.getResource(Issue.class, this.fields.get("parent"), this.restclient);
        this.priority = Field.getResource(Priority.class, this.fields.get("priority"), this.restclient);
        this.project = Field.getResource(Project.class, this.fields.get("project"), this.restclient);
        this.reporter = Field.getResource(User.class, this.fields.get("reporter"), this.restclient);
        this.resolution = Field.getResource(Resolution.class, this.fields.get("resolution"), this.restclient);
        this.resolutionDate = Field.getDateTime(this.fields.get("resolutiondate"));
        this.status = Field.getResource(Status.class, this.fields.get("status"), this.restclient);
        this.subtasks = Field.getResourceArray(Issue.class, this.fields.get("subtasks"), this.restclient);
        this.summary = Field.getString(this.fields.get("summary"));
        this.timeTracking = Field.getTimeTracking(this.fields.get("timetracking"));
        this.versions = Field.getResourceArray(Version.class, this.fields.get("versions"), this.restclient);
        this.votes = Field.getResource(Votes.class, this.fields.get("votes"), this.restclient);
        this.watches = Field.getResource(Watches.class, this.fields.get("watches"), this.restclient);
        this.workLogs = Field.getWorkLogs(this.fields.get("worklog"), this.restclient);
        this.timeEstimate = Field.getInteger(this.fields.get("timeestimate"));
        this.timeSpent = Field.getInteger(this.fields.get("timespent"));
        this.createdDate = Field.getDateTime(this.fields.get("created"));
        this.updatedDate = Field.getDateTime(this.fields.get("updated"));
        this.security = Field.getResource(Security.class, this.fields.get("security"), this.restclient);
    }

    private static String getRestUri(String key) {
        return Issue.getBaseUri() + "issue/" + (key != null ? key : "");
    }

    public static JSONObject getCreateMetadata(RestClient restclient, String project, String issueType) throws JiraException {
        String pval = project;
        String itval = issueType;
        JSON result = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("expand", "projects.issuetypes.fields");
            params.put("projectKeys", pval);
            params.put("issuetypeNames", itval);
            URI createuri = restclient.buildURI(Issue.getBaseUri() + "issue/createmeta", params);
            result = restclient.get(createuri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue metadata", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey("projects") || !(jo.get("projects") instanceof JSONArray)) {
            throw new JiraException("Create metadata is malformed");
        }
        List<Project> projects = Field.getResourceArray(Project.class, (JSONArray)jo.get("projects"), restclient);
        if (projects.isEmpty() || projects.get(0).getIssueTypes().isEmpty()) {
            throw new JiraException("Project '" + project + "'  or issue type '" + issueType + "' missing from create metadata. Do you have enough permissions?");
        }
        return projects.get(0).getIssueTypes().get(0).getFields();
    }

    private JSONObject getEditMetadata() throws JiraException {
        JSON result = null;
        try {
            result = this.restclient.get(Issue.getRestUri(this.key) + "/editmeta");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue metadata", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey("fields") || !(jo.get("fields") instanceof JSONObject)) {
            throw new JiraException("Edit metadata is malformed");
        }
        return (JSONObject)jo.get("fields");
    }

    public List<Transition> getTransitions() throws JiraException {
        JSON result = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("expand", "transitions.fields");
            URI transuri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/transitions", params);
            result = this.restclient.get(transuri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve transitions", ex);
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey("transitions") || !(jo.get("transitions") instanceof JSONArray)) {
            throw new JiraException("Transition metadata is missing.");
        }
        JSONArray transitions = (JSONArray)jo.get("transitions");
        ArrayList<Transition> trans = new ArrayList<Transition>();
        for (Object obj : transitions) {
            JSONObject ob = (JSONObject)obj;
            trans.add(new Transition(this.restclient, ob));
        }
        return trans;
    }

    public void addAttachment(File file) throws JiraException {
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/attachments", file);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add attachment to issue " + this.key, ex);
        }
    }

    public void addRemoteLink(String url, String title, String summary) throws JiraException {
        this.remoteLink().url(url).title(title).summary(summary).create();
    }

    public FluentRemoteLink remoteLink() {
        return new FluentRemoteLink(this.restclient, this.getKey());
    }

    public void addAttachments(NewAttachment ... attachments) throws JiraException {
        if (attachments == null) {
            throw new NullPointerException("attachments may not be null");
        }
        if (attachments.length == 0) {
            return;
        }
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/attachments", attachments);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add attachment to issue " + this.key, ex);
        }
    }

    public void removeAttachment(String attachmentId) throws JiraException {
        if (attachmentId == null) {
            throw new NullPointerException("attachmentId may not be null");
        }
        try {
            this.restclient.delete(Issue.getBaseUri() + "attachment/" + attachmentId);
        }
        catch (Exception ex) {
            throw new JiraException("Failed remove attachment " + attachmentId, ex);
        }
    }

    public Comment addComment(String body) throws JiraException {
        return this.addComment(body, null, null);
    }

    public Comment addComment(String body, String visType, String visName) throws JiraException {
        JSONObject req = new JSONObject();
        req.put("body", body);
        if (visType != null && visName != null) {
            JSONObject vis = new JSONObject();
            vis.put("type", visType);
            vis.put("value", visName);
            req.put("visibility", vis);
        }
        JSON result = null;
        try {
            result = this.restclient.post(Issue.getRestUri(this.key) + "/comment", (JSON)req);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add comment to issue " + this.key, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Comment(this.restclient, (JSONObject)result, this.key);
    }

    public WorkLog addWorkLog(String comment, DateTime startDate, long timeSpentSeconds) throws JiraException {
        try {
            if (comment == null) {
                throw new IllegalArgumentException("Invalid comment.");
            }
            if (startDate == null) {
                throw new IllegalArgumentException("Invalid start time.");
            }
            if (timeSpentSeconds < 60L) {
                throw new IllegalArgumentException("Time spent cannot be lower than 1 minute.");
            }
            JSONObject req = new JSONObject();
            req.put("comment", comment);
            req.put("started", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").print(startDate.getMillis()));
            req.put("timeSpent", WorklogUtils.formatDurationFromSeconds(timeSpentSeconds));
            JSON result = this.restclient.post(Issue.getRestUri(this.key) + "/worklog", (JSON)req);
            JSONObject jo = (JSONObject)result;
            return new WorkLog(this.restclient, jo);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add worklog to issue " + this.key, ex);
        }
    }

    public void link(String issue, String type) throws JiraException {
        this.link(issue, type, null, null, null);
    }

    public void link(String issue, String type, String body) throws JiraException {
        this.link(issue, type, body, null, null);
    }

    public void link(String issue, String type, String body, String visType, String visName) throws JiraException {
        JSONObject req = new JSONObject();
        JSONObject t = new JSONObject();
        t.put("name", type);
        req.put("type", t);
        JSONObject inward = new JSONObject();
        inward.put("key", this.key);
        req.put("inwardIssue", inward);
        JSONObject outward = new JSONObject();
        outward.put("key", issue);
        req.put("outwardIssue", outward);
        if (body != null) {
            JSONObject comment = new JSONObject();
            comment.put("body", body);
            if (visType != null && visName != null) {
                JSONObject vis = new JSONObject();
                vis.put("type", visType);
                vis.put("value", visName);
                comment.put("visibility", vis);
            }
            req.put("comment", comment);
        }
        try {
            this.restclient.post(Issue.getBaseUri() + "issueLink", (JSON)req);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to link issue " + this.key + " with issue " + issue, ex);
        }
    }

    public static FluentCreate create(RestClient restclient, String project, String issueType) throws JiraException {
        FluentCreate fc = new FluentCreate(restclient, Issue.getCreateMetadata(restclient, project, issueType));
        return fc.field("project", project).field("issuetype", issueType);
    }

    public FluentCreate createSubtask() throws JiraException {
        return Issue.create(this.restclient, this.getProject().getKey(), "Sub-task").field("parent", this.getKey());
    }

    private static JSONObject realGet(RestClient restclient, String key, Map<String, String> queryParams) throws JiraException {
        JSON result = null;
        try {
            URI uri = restclient.buildURI(Issue.getBaseUri() + "issue/" + key, queryParams);
            result = restclient.get(uri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue " + key, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return (JSONObject)result;
    }

    public static Issue get(RestClient restclient, String key) throws JiraException {
        return new Issue(restclient, Issue.realGet(restclient, key, new HashMap<String, String>()));
    }

    public static Issue get(RestClient restclient, String key, String includedFields) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("fields", includedFields);
        return new Issue(restclient, Issue.realGet(restclient, key, queryParams));
    }

    public static Issue get(RestClient restclient, String key, String includedFields, String expand) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("fields", includedFields);
        if (expand != null) {
            queryParams.put("expand", expand);
        }
        return new Issue(restclient, Issue.realGet(restclient, key, queryParams));
    }

    public static SearchResult search(RestClient restclient, String jql, String includedFields, String expandFields, Integer maxResults, Integer startAt) throws JiraException {
        return new SearchResult(restclient, jql, includedFields, expandFields, maxResults, startAt);
    }

    private static URI createSearchURI(RestClient restclient, String jql, String includedFields, String expandFields, Integer maxResults, Integer startAt) throws URISyntaxException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("jql", jql);
        if (maxResults != null) {
            queryParams.put("maxResults", String.valueOf(maxResults));
        }
        if (includedFields != null) {
            queryParams.put("fields", includedFields);
        }
        if (expandFields != null) {
            queryParams.put("expand", expandFields);
        }
        if (startAt != null) {
            queryParams.put("startAt", String.valueOf(startAt));
        }
        URI searchUri = restclient.buildURI(Issue.getBaseUri() + "search", queryParams);
        return searchUri;
    }

    public void refresh() throws JiraException {
        JSONObject result = Issue.realGet(this.restclient, this.key, new HashMap<String, String>());
        this.deserialise(result);
    }

    public void refresh(String includedFields) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("fields", includedFields);
        JSONObject result = Issue.realGet(this.restclient, this.key, queryParams);
        this.deserialise(result);
    }

    public Object getField(String name) {
        return this.fields != null ? this.fields.get(name) : null;
    }

    public FluentTransition transition() throws JiraException {
        return new FluentTransition(this.getTransitions());
    }

    public FluentUpdate update() throws JiraException {
        return new FluentUpdate(this.getEditMetadata());
    }

    public void vote() throws JiraException {
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/votes");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to vote on issue " + this.key, ex);
        }
    }

    public void unvote() throws JiraException {
        try {
            this.restclient.delete(Issue.getRestUri(this.key) + "/votes");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to unvote on issue " + this.key, ex);
        }
    }

    public void addWatcher(String username) throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/watchers");
            this.restclient.post(uri, username);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to add watcher (" + username + ") to issue " + this.key, ex);
        }
    }

    public void deleteWatcher(String username) throws JiraException {
        try {
            String u = username;
            HashMap<String, String> connectionParams = new HashMap<String, String>();
            connectionParams.put("username", u);
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/watchers", connectionParams);
            this.restclient.delete(uri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to remove watch (" + username + ") from issue " + this.key, ex);
        }
    }

    public String toString() {
        return this.getKey();
    }

    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    public String getKey() {
        return this.key;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public List<Version> getFixVersions() {
        return this.fixVersions;
    }

    public List<IssueLink> getIssueLinks() {
        return this.issueLinks;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Issue getParent() {
        return this.parent;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Project getProject() {
        return this.project;
    }

    public User getReporter() {
        return this.reporter;
    }

    public List<RemoteLink> getRemoteLinks() throws JiraException {
        JSONArray obj;
        try {
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/remotelink");
            JSON json = this.restclient.get(uri);
            obj = (JSONArray)json;
        }
        catch (Exception ex) {
            throw new JiraException("Failed to get remote links for issue " + this.key, ex);
        }
        return Field.getRemoteLinks(obj, this.restclient);
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Issue> getSubtasks() {
        return this.subtasks;
    }

    public String getSummary() {
        return this.summary;
    }

    public TimeTracking getTimeTracking() {
        return this.timeTracking;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Votes getVotes() {
        return this.votes;
    }

    public Watches getWatches() {
        return this.watches;
    }

    public List<WorkLog> getWorkLogs() {
        return this.workLogs;
    }

    public List<WorkLog> getAllWorkLogs() throws JiraException {
        JSONObject obj;
        try {
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/worklog");
            JSON json = this.restclient.get(uri);
            obj = (JSONObject)json;
        }
        catch (Exception ex) {
            throw new JiraException("Failed to get worklog for issue " + this.key, ex);
        }
        return Field.getWorkLogs(obj, this.restclient);
    }

    public Integer getTimeSpent() {
        return this.timeSpent;
    }

    public Integer getTimeEstimate() {
        return this.timeEstimate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public Security getSecurity() {
        return this.security;
    }

    public boolean delete(final boolean deleteSubtasks) throws JiraException {
        boolean result;
        try {
            URI uri = this.restclient.buildURI(Issue.getBaseUri() + "issue/" + this.key, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("deleteSubtasks", String.valueOf(deleteSubtasks));
                }
            });
            result = this.restclient.delete(uri) == null;
        }
        catch (Exception ex) {
            throw new JiraException("Failed to delete issue " + this.key, ex);
        }
        return result;
    }

    public static final class NewAttachment {
        private final String filename;
        private final Object content;

        public NewAttachment(File content) {
            this(content.getName(), content);
        }

        public NewAttachment(String filename, File content) {
            this.filename = NewAttachment.requireFilename(filename);
            this.content = NewAttachment.requireContent(content);
        }

        public NewAttachment(String filename, InputStream content) {
            this.filename = NewAttachment.requireFilename(filename);
            this.content = NewAttachment.requireContent(content);
        }

        public NewAttachment(String filename, byte[] content) {
            this.filename = NewAttachment.requireFilename(filename);
            this.content = NewAttachment.requireContent(content);
        }

        String getFilename() {
            return this.filename;
        }

        Object getContent() {
            return this.content;
        }

        private static String requireFilename(String filename) {
            if (filename == null) {
                throw new NullPointerException("filename may not be null");
            }
            if (filename.length() == 0) {
                throw new IllegalArgumentException("filename may not be empty");
            }
            return filename;
        }

        private static Object requireContent(Object content) {
            if (content == null) {
                throw new NullPointerException("content may not be null");
            }
            return content;
        }
    }

    public static class SearchResult {
        public int start = 0;
        public int max = 0;
        public int total = 0;
        public List<Issue> issues = null;
        private IssueIterator issueIterator;

        public SearchResult(RestClient restclient, String jql, String includedFields, String expandFields, Integer maxResults, Integer startAt) throws JiraException {
            this.issueIterator = new IssueIterator(restclient, jql, includedFields, expandFields, maxResults, startAt);
            this.issueIterator.hasNext();
            this.max = this.issueIterator.maxResults;
            this.start = this.issueIterator.startAt;
            this.issues = this.issueIterator.issues;
            this.total = this.issueIterator.total;
        }

        public Iterator<Issue> iterator() {
            return this.issueIterator;
        }
    }

    private static class IssueIterator
    implements Iterator<Issue> {
        private Iterator<Issue> currentPage;
        private RestClient restclient;
        private Issue nextIssue;
        private Integer maxResults = -1;
        private String jql;
        private String includedFields;
        private String expandFields;
        private Integer startAt;
        private List<Issue> issues;
        private int total;

        public IssueIterator(RestClient restclient, String jql, String includedFields, String expandFields, Integer maxResults, Integer startAt) throws JiraException {
            this.restclient = restclient;
            this.jql = jql;
            this.includedFields = includedFields;
            this.expandFields = expandFields;
            this.maxResults = maxResults;
            this.startAt = startAt;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIssue != null) {
                return true;
            }
            try {
                this.nextIssue = this.getNextIssue();
            }
            catch (JiraException e) {
                throw new RuntimeException(e);
            }
            return this.nextIssue != null;
        }

        @Override
        public Issue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Issue result = this.nextIssue;
            this.nextIssue = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() not support for class " + this.getClass().getName());
        }

        private Issue getNextIssue() throws JiraException {
            if (this.currentPage == null) {
                this.currentPage = this.getNextIssues().iterator();
                if (this.currentPage == null || !this.currentPage.hasNext()) {
                    return null;
                }
                return this.currentPage.next();
            }
            if (!this.currentPage.hasNext()) {
                this.currentPage = this.getNextIssues().iterator();
            }
            if (this.currentPage.hasNext()) {
                return this.currentPage.next();
            }
            return null;
        }

        private List<Issue> getNextIssues() throws JiraException {
            if (this.issues == null && this.startAt == null) {
                this.startAt = 0;
            } else if (this.issues != null) {
                this.startAt = this.startAt + this.issues.size();
            }
            JSON result = null;
            try {
                URI searchUri = Issue.createSearchURI(this.restclient, this.jql, this.includedFields, this.expandFields, this.maxResults, this.startAt);
                result = this.restclient.get(searchUri);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to search issues", ex);
            }
            if (!(result instanceof JSONObject)) {
                throw new JiraException("JSON payload is malformed");
            }
            Map map = (Map)((Object)result);
            this.startAt = Field.getInteger(map.get("startAt"));
            this.maxResults = Field.getInteger(map.get("maxResults"));
            this.total = Field.getInteger(map.get("total"));
            this.issues = Field.getResourceArray(Issue.class, map.get("issues"), this.restclient);
            return this.issues;
        }
    }

    public final class FluentTransition {
        Map<String, Object> fields = new HashMap<String, Object>();
        List<Transition> transitions = null;

        private FluentTransition(List<Transition> transitions) {
            this.transitions = transitions;
        }

        private Transition getTransition(String id, boolean isName) throws JiraException {
            Transition result = null;
            for (Transition transition : this.transitions) {
                if ((!isName || !id.equals(transition.getName())) && (isName || !id.equals(transition.getId()))) continue;
                result = transition;
            }
            if (result == null) {
                String allTransitionNames = Arrays.toString(this.transitions.toArray());
                throw new JiraException("Transition '" + id + "' was not found. Known transitions are:" + allTransitionNames);
            }
            return result;
        }

        private void realExecute(Transition trans) throws JiraException {
            if (trans == null || trans.getFields() == null) {
                throw new JiraException("Transition is missing fields");
            }
            JSONObject fieldmap = new JSONObject();
            for (Map.Entry<String, Object> ent : this.fields.entrySet()) {
                fieldmap.put(ent.getKey(), ent.getValue());
            }
            JSONObject req = new JSONObject();
            if (fieldmap.size() > 0) {
                req.put("fields", fieldmap);
            }
            JSONObject t = new JSONObject();
            t.put("id", Field.getString(trans.getId()));
            req.put("transition", t);
            try {
                Issue.this.restclient.post(Issue.getRestUri(Issue.this.key) + "/transitions", (JSON)req);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to transition issue " + Issue.this.key, ex);
            }
        }

        public void execute(int id) throws JiraException {
            this.realExecute(this.getTransition(Integer.toString(id), false));
        }

        public void execute(Transition transition) throws JiraException {
            this.realExecute(transition);
        }

        public void execute(String name) throws JiraException {
            this.realExecute(this.getTransition(name, true));
        }

        public FluentTransition field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }
    }

    public final class FluentUpdate {
        Map<String, Object> fields = new HashMap<String, Object>();
        Map<String, List> fieldOpers = new HashMap<String, List>();
        JSONObject editmeta = null;

        private FluentUpdate(JSONObject editmeta) {
            this.editmeta = editmeta;
        }

        public void execute() throws JiraException {
            Object newval;
            JSONObject fieldmap = new JSONObject();
            JSONObject updatemap = new JSONObject();
            if (this.fields.size() == 0 && this.fieldOpers.size() == 0) {
                throw new JiraException("No fields were given for update");
            }
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                newval = Field.toJson(entry.getKey(), entry.getValue(), this.editmeta);
                fieldmap.put(entry.getKey(), newval);
            }
            for (Map.Entry<String, Object> entry : this.fieldOpers.entrySet()) {
                newval = Field.toJson(entry.getKey(), entry.getValue(), this.editmeta);
                updatemap.put(entry.getKey(), newval);
            }
            JSONObject req = new JSONObject();
            if (fieldmap.size() > 0) {
                req.put("fields", fieldmap);
            }
            if (updatemap.size() > 0) {
                req.put("update", updatemap);
            }
            try {
                Issue.this.restclient.put(Issue.getRestUri(Issue.this.key), (JSON)req);
            }
            catch (Exception exception) {
                throw new JiraException("Failed to update issue " + Issue.this.key, exception);
            }
        }

        public FluentUpdate field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }

        private FluentUpdate fieldOperation(String oper, String name, Object value) {
            if (!this.fieldOpers.containsKey(name)) {
                this.fieldOpers.put(name, new ArrayList());
            }
            this.fieldOpers.get(name).add(new Field.Operation(oper, value));
            return this;
        }

        public FluentUpdate fieldAdd(String name, Object value) {
            return this.fieldOperation("add", name, value);
        }

        public FluentUpdate fieldRemove(String name, Object value) {
            return this.fieldOperation("remove", name, value);
        }
    }

    public static final class FluentRemoteLink {
        private final RestClient restclient;
        private final String key;
        private final JSONObject request;
        private final JSONObject object;

        private FluentRemoteLink(RestClient restclient, String key) {
            this.restclient = restclient;
            this.key = key;
            this.request = new JSONObject();
            this.object = new JSONObject();
        }

        public FluentRemoteLink globalId(String globalId) {
            this.request.put("globalId", globalId);
            this.url(globalId);
            return this;
        }

        public FluentRemoteLink url(String url) {
            this.object.put("url", url);
            return this;
        }

        public FluentRemoteLink title(String title) {
            this.object.put("title", title);
            return this;
        }

        public FluentRemoteLink icon(String url, String title) {
            JSONObject icon = new JSONObject();
            icon.put("url16x16", url);
            icon.put("title", title);
            this.object.put("icon", icon);
            return this;
        }

        public FluentRemoteLink status(boolean resolved, String iconUrl, String title, String statusUrl) {
            JSONObject status = new JSONObject();
            status.put("resolved", Boolean.toString(resolved));
            JSONObject icon = new JSONObject();
            icon.put("title", title);
            if (iconUrl != null) {
                icon.put("url16x16", iconUrl);
            }
            if (statusUrl != null) {
                icon.put("link", statusUrl);
            }
            status.put("icon", icon);
            this.object.put("status", status);
            return this;
        }

        public FluentRemoteLink summary(String summary) {
            this.object.put("summary", summary);
            return this;
        }

        public FluentRemoteLink relationship(String relationship) {
            this.request.put("relationship", relationship);
            return this;
        }

        public FluentRemoteLink application(String type, String name) {
            JSONObject application = new JSONObject();
            if (type != null) {
                application.put("type", type);
            }
            application.put("name", name);
            this.request.put("application", application);
            return this;
        }

        public void create() throws JiraException {
            try {
                this.request.put("object", this.object);
                this.restclient.post(Issue.getRestUri(this.key) + "/remotelink", (JSON)this.request);
            }
            catch (Exception ex) {
                throw new JiraException("Failed add remote link to issue " + this.key, ex);
            }
        }
    }

    public static final class FluentCreate {
        Map<String, Object> fields = new HashMap<String, Object>();
        RestClient restclient = null;
        JSONObject createmeta = null;

        private FluentCreate(RestClient restclient, JSONObject createmeta) {
            this.restclient = restclient;
            this.createmeta = createmeta;
        }

        public Issue execute() throws JiraException {
            return this.executeCreate(null);
        }

        public Issue execute(String includedFields) throws JiraException {
            return this.executeCreate(includedFields);
        }

        private Issue executeCreate(String includedFields) throws JiraException {
            JSONObject fieldmap = new JSONObject();
            if (this.fields.size() == 0) {
                throw new JiraException("No fields were given for create");
            }
            for (Map.Entry<String, Object> ent : this.fields.entrySet()) {
                Object newval = Field.toJson(ent.getKey(), ent.getValue(), this.createmeta);
                fieldmap.put(ent.getKey(), newval);
            }
            JSONObject req = new JSONObject();
            req.put("fields", fieldmap);
            JSON result = null;
            try {
                result = this.restclient.post(Issue.getRestUri(null), (JSON)req);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to create issue", ex);
            }
            if (!(result instanceof JSONObject && ((JSONObject)result).containsKey("key") && ((JSONObject)result).get("key") instanceof String)) {
                throw new JiraException("Unexpected result on create issue");
            }
            if (includedFields != null) {
                return Issue.get(this.restclient, (String)((JSONObject)result).get("key"), includedFields);
            }
            return Issue.get(this.restclient, (String)((JSONObject)result).get("key"));
        }

        public FluentCreate field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }
    }
}

