/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.ArrayList;
import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.IssueHistoryItem;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class IssueHistory
extends Resource {
    private static final long serialVersionUID = 1L;
    private User user;
    private ArrayList<IssueHistoryItem> changes;
    private Date created;

    protected IssueHistory(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(restclient, json);
        }
    }

    public IssueHistory(IssueHistory record, ArrayList<IssueHistoryItem> changes) {
        super(record.restclient);
        this.user = record.user;
        this.id = record.id;
        this.self = record.self;
        this.created = record.created;
        this.changes = changes;
    }

    private void deserialise(RestClient restclient, JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.user = new User(restclient, (JSONObject)map.get((Object)"author"));
        this.created = Field.getDateTime(map.get((Object)"created"));
        JSONArray items = JSONArray.fromObject(map.get((Object)"items"));
        this.changes = new ArrayList(items.size());
        for (int i = 0; i < items.size(); ++i) {
            JSONObject p = items.getJSONObject(i);
            this.changes.add(new IssueHistoryItem(restclient, p));
        }
    }

    public User getUser() {
        return this.user;
    }

    public ArrayList<IssueHistoryItem> getChanges() {
        return this.changes;
    }

    public Date getCreated() {
        return this.created;
    }
}

