/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class IssueType
extends Resource {
    private String description = null;
    private String iconUrl = null;
    private String name = null;
    private boolean subtask = false;
    private JSONObject fields = null;

    protected IssueType(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.description = Field.getString(map.get((Object)"description"));
        this.iconUrl = Field.getString(map.get((Object)"iconUrl"));
        this.name = Field.getString(map.get((Object)"name"));
        this.subtask = Field.getBoolean(map.get((Object)"subtask"));
        if (map.containsKey("fields") && map.get((Object)"fields") instanceof JSONObject) {
            this.fields = (JSONObject)map.get((Object)"fields");
        }
    }

    public static IssueType get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(IssueType.getBaseUri() + "issuetype/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue type " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new IssueType(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public boolean isSubtask() {
        return this.subtask;
    }

    public JSONObject getFields() {
        return this.fields;
    }
}

