/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class LinkType
extends Resource {
    private String name = null;
    private String inward = null;
    private String outward = null;

    protected LinkType(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.name = Field.getString(map.get((Object)"name"));
        this.inward = Field.getString(map.get((Object)"inward"));
        this.outward = Field.getString(map.get((Object)"outward"));
    }

    public static LinkType get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(LinkType.getBaseUri() + "issueLinkType/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue link type " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new LinkType(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getInward() {
        return this.inward;
    }

    public String getOutward() {
        return this.outward;
    }
}

