/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.greenhopper;

import java.util.ArrayList;
import java.util.List;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.greenhopper.Epic;
import net.rcarz.jiraclient.greenhopper.EpicStats;
import net.rcarz.jiraclient.greenhopper.EstimateStatistic;
import net.rcarz.jiraclient.greenhopper.EstimateSum;
import net.rcarz.jiraclient.greenhopper.GreenHopperResource;
import net.rcarz.jiraclient.greenhopper.Marker;
import net.rcarz.jiraclient.greenhopper.RapidView;
import net.rcarz.jiraclient.greenhopper.RapidViewProject;
import net.rcarz.jiraclient.greenhopper.Sprint;
import net.rcarz.jiraclient.greenhopper.SprintIssue;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public final class GreenHopperField {
    public static final String DATE_TIME_FORMAT = "d/MMM/yy h:m a";
    public static final String NO_DATE = "None";

    private GreenHopperField() {
    }

    public static DateTime getDateTime(Object dt) {
        if (dt == null || ((String)dt).equals(NO_DATE)) {
            return null;
        }
        return DateTime.parse((String)dt, DateTimeFormat.forPattern(DATE_TIME_FORMAT));
    }

    public static EpicStats getEpicStats(Object es) {
        EpicStats result = null;
        if (es instanceof JSONObject && !((JSONObject)es).isNullObject()) {
            result = new EpicStats((JSONObject)es);
        }
        return result;
    }

    public static EstimateStatistic getEstimateStatistic(Object es) {
        EstimateStatistic result = null;
        if (es instanceof JSONObject && !((JSONObject)es).isNullObject()) {
            result = new EstimateStatistic((JSONObject)es);
        }
        return result;
    }

    public static EstimateSum getEstimateSum(Object es) {
        EstimateSum result = null;
        if (es instanceof JSONObject && !((JSONObject)es).isNullObject()) {
            result = new EstimateSum((JSONObject)es);
        }
        return result;
    }

    public static List<Integer> getIntegerArray(Object ia) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (ia instanceof JSONArray) {
            for (Object v : (JSONArray)ia) {
                results.add((Integer)v);
            }
        }
        return results;
    }

    public static <T extends GreenHopperResource> T getResource(Class<T> type, Object r, RestClient restclient) {
        GreenHopperResource result = null;
        if (r instanceof JSONObject && !((JSONObject)r).isNullObject()) {
            if (type == Epic.class) {
                result = new Epic(restclient, (JSONObject)r);
            } else if (type == Marker.class) {
                result = new Marker(restclient, (JSONObject)r);
            } else if (type == RapidView.class) {
                result = new RapidView(restclient, (JSONObject)r);
            } else if (type == RapidViewProject.class) {
                result = new RapidViewProject(restclient, (JSONObject)r);
            } else if (type == Sprint.class) {
                result = new Sprint(restclient, (JSONObject)r);
            } else if (type == SprintIssue.class) {
                result = new SprintIssue(restclient, (JSONObject)r);
            }
        }
        return (T)result;
    }

    public static <T extends GreenHopperResource> List<T> getResourceArray(Class<T> type, Object ra, RestClient restclient) {
        ArrayList<T> results = new ArrayList<T>();
        if (ra instanceof JSONArray) {
            for (Object v : (JSONArray)ra) {
                T item = GreenHopperField.getResource(type, v, restclient);
                if (item == null) continue;
                results.add(item);
            }
        }
        return results;
    }

    public static List<String> getStringArray(Object ia) {
        ArrayList<String> results = new ArrayList<String>();
        if (ia instanceof JSONArray) {
            for (Object v : (JSONArray)ia) {
                results.add((String)v);
            }
        }
        return results;
    }
}

