/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.test;

import java.util.Iterator;
import junit.framework.Assert;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.util.JSONUtils;

public class JSONAssert
extends Assert {
    public static void assertEquals(JSON expected, JSON actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONArray expected, JSONArray actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONArray expected, String actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONFunction expected, String actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONNull expected, String actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONObject expected, JSONObject actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(JSONObject expected, String actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, JSON expected, JSON actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual was null");
        }
        if (expected == actual || expected.equals(actual)) {
            return;
        }
        if (expected instanceof JSONArray) {
            if (actual instanceof JSONArray) {
                JSONAssert.assertEquals(header, (JSONArray)expected, (JSONArray)actual);
            } else {
                Assert.fail(header + "actual is not a JSONArray");
            }
        } else if (expected instanceof JSONObject) {
            if (actual instanceof JSONObject) {
                JSONAssert.assertEquals(header, (JSONObject)expected, (JSONObject)actual);
            } else {
                Assert.fail(header + "actual is not a JSONObject");
            }
        } else if (expected instanceof JSONNull) {
            if (actual instanceof JSONNull) {
                return;
            }
            Assert.fail(header + "actual is not a JSONNull");
        }
    }

    public static void assertEquals(String expected, JSONArray actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, JSONArray expected, JSONArray actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected array was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual array was null");
        }
        if (expected == actual || expected.equals(actual)) {
            return;
        }
        if (actual.size() != expected.size()) {
            Assert.fail(header + "arrays sizes differed, expected.length()=" + expected.size() + " actual.length()=" + actual.size());
        }
        int max = expected.size();
        for (int i = 0; i < max; ++i) {
            Object o1 = expected.get(i);
            Object o2 = actual.get(i);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                Assert.fail(header + "arrays first differed at element [" + i + "];");
            } else if (JSONNull.getInstance().equals(o2)) {
                Assert.fail(header + "arrays first differed at element [" + i + "];");
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONArray e = (JSONArray)o1;
                JSONArray a = (JSONArray)o2;
                JSONAssert.assertEquals(header + "arrays first differed at element " + i + ";", e, a);
                continue;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                JSONAssert.assertEquals(header + "arrays first differed at element [" + i + "];", (String)o1, (JSONFunction)o2);
                continue;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                JSONAssert.assertEquals(header + "arrays first differed at element [" + i + "];", (JSONFunction)o1, (String)o2);
                continue;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                JSONAssert.assertEquals(header + "arrays first differed at element [" + i + "];", (JSONObject)o1, (JSONObject)o2);
                continue;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONAssert.assertEquals(header + "arrays first differed at element [" + i + "];", (JSONArray)o1, (JSONArray)o2);
                continue;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                Assert.assertEquals(header + "arrays first differed at element [" + i + "];", (JSONFunction)o1, (JSONFunction)o2);
                continue;
            }
            if (o1 instanceof String) {
                Assert.assertEquals(header + "arrays first differed at element [" + i + "];", (String)o1, String.valueOf(o2));
                continue;
            }
            if (o2 instanceof String) {
                Assert.assertEquals(header + "arrays first differed at element [" + i + "];", String.valueOf(o1), (String)o2);
                continue;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (m1 != null && m1 != IdentityObjectMorpher.getInstance()) {
                Assert.assertEquals(header + "arrays first differed at element [" + i + "];", o1, JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2));
                continue;
            }
            if (m2 != null && m2 != IdentityObjectMorpher.getInstance()) {
                Assert.assertEquals(header + "arrays first differed at element [" + i + "];", JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1), o2);
                continue;
            }
            Assert.assertEquals(header + "arrays first differed at element [" + i + "];", o1, o2);
        }
    }

    public static void assertEquals(String message, JSONArray expected, String actual) {
        try {
            JSONAssert.assertEquals(message, expected, JSONArray.fromObject(actual));
        }
        catch (JSONException e) {
            String header = message == null ? "" : message + ": ";
            Assert.fail(header + "actual is not a JSONArray");
        }
    }

    public static void assertEquals(String expected, JSONFunction actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, JSONFunction expected, String actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected function was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual string was null");
        }
        try {
            Assert.assertEquals(header, expected, JSONFunction.parse(actual));
        }
        catch (JSONException jsone) {
            Assert.fail(header + "'" + actual + "' is not a function");
        }
    }

    public static void assertEquals(String expected, JSONNull actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, JSONNull expected, String actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (actual == null) {
            Assert.fail(header + "actual string was null");
        } else if (expected == null) {
            Assert.assertEquals(header, "null", actual);
        } else {
            Assert.assertEquals(header, expected.toString(), actual);
        }
    }

    public static void assertEquals(String expected, JSONObject actual) {
        JSONAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, JSONObject expected, JSONObject actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected object was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual object was null");
        }
        if (expected == actual) {
            return;
        }
        if (expected.isNullObject()) {
            if (actual.isNullObject()) {
                return;
            }
            Assert.fail(header + "actual is not a null JSONObject");
        } else if (actual.isNullObject()) {
            Assert.fail(header + "actual is a null JSONObject");
        }
        Assert.assertEquals(header + "names sizes differed, expected.names().length()=" + expected.names().size() + " actual.names().length()=" + actual.names().size(), expected.names().size(), actual.names().size());
        Iterator keys = expected.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object o1 = expected.opt(key);
            Object o2 = actual.opt(key);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                Assert.fail(header + "objects differed at key [" + key + "];");
            } else if (JSONNull.getInstance().equals(o2)) {
                Assert.fail(header + "objects differed at key [" + key + "];");
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                JSONAssert.assertEquals(header + "objects differed at key [" + key + "];", (String)o1, (JSONFunction)o2);
                continue;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                JSONAssert.assertEquals(header + "objects differed at key [" + key + "];", (JSONFunction)o1, (String)o2);
                continue;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                JSONAssert.assertEquals(header + "objects differed at key [" + key + "];", (JSONObject)o1, (JSONObject)o2);
                continue;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONAssert.assertEquals(header + "objects differed at key [" + key + "];", (JSONArray)o1, (JSONArray)o2);
                continue;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                Assert.assertEquals(header + "objects differed at key [" + key + "];", (JSONFunction)o1, (JSONFunction)o2);
                continue;
            }
            if (o1 instanceof String) {
                Assert.assertEquals(header + "objects differed at key [" + key + "];", (String)o1, String.valueOf(o2));
                continue;
            }
            if (o2 instanceof String) {
                Assert.assertEquals(header + "objects differed at key [" + key + "];", String.valueOf(o1), (String)o2);
                continue;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (m1 != null && m1 != IdentityObjectMorpher.getInstance()) {
                Assert.assertEquals(header + "objects differed at key [" + key + "];", o1, JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2));
                continue;
            }
            if (m2 != null && m2 != IdentityObjectMorpher.getInstance()) {
                Assert.assertEquals(header + "objects differed at key [" + key + "];", JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1), o2);
                continue;
            }
            Assert.assertEquals(header + "objects differed at key [" + key + "];", o1, o2);
        }
    }

    public static void assertEquals(String message, JSONObject expected, String actual) {
        try {
            JSONAssert.assertEquals(message, expected, JSONObject.fromObject(actual));
        }
        catch (JSONException e) {
            String header = message == null ? "" : message + ": ";
            Assert.fail(header + "actual is not a JSONObject");
        }
    }

    public static void assertEquals(String message, String expected, JSONArray actual) {
        try {
            JSONAssert.assertEquals(message, JSONArray.fromObject(expected), actual);
        }
        catch (JSONException e) {
            String header = message == null ? "" : message + ": ";
            Assert.fail(header + "expected is not a JSONArray");
        }
    }

    public static void assertEquals(String message, String expected, JSONFunction actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected string was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual function was null");
        }
        try {
            Assert.assertEquals(header, JSONFunction.parse(expected), actual);
        }
        catch (JSONException jsone) {
            Assert.fail(header + "'" + expected + "' is not a function");
        }
    }

    public static void assertEquals(String message, String expected, JSONNull actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected was null");
        } else if (actual == null) {
            Assert.assertEquals(header, expected, "null");
        } else {
            Assert.assertEquals(header, expected, actual.toString());
        }
    }

    public static void assertEquals(String message, String expected, JSONObject actual) {
        try {
            JSONAssert.assertEquals(message, JSONObject.fromObject(expected), actual);
        }
        catch (JSONException e) {
            String header = message == null ? "" : message + ": ";
            Assert.fail(header + "expected is not a JSONObject");
        }
    }

    public static void assertJsonEquals(String expected, String actual) {
        JSONAssert.assertJsonEquals(null, expected, actual);
    }

    public static void assertJsonEquals(String message, String expected, String actual) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (expected == null) {
            Assert.fail(header + "expected was null");
        }
        if (actual == null) {
            Assert.fail(header + "actual was null");
        }
        JSON json1 = null;
        JSON json2 = null;
        try {
            json1 = JSONSerializer.toJSON(expected);
        }
        catch (JSONException jsone) {
            Assert.fail(header + "expected is not a valid JSON string");
        }
        try {
            json2 = JSONSerializer.toJSON(actual);
        }
        catch (JSONException jsone) {
            Assert.fail(header + "actual is not a valid JSON string");
        }
        JSONAssert.assertEquals(header, json1, json2);
    }

    public static void assertNotNull(JSON json) {
        JSONAssert.assertNotNull(null, json);
    }

    public static void assertNotNull(String message, JSON json) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (json instanceof JSONObject) {
            Assert.assertFalse(header + "Object is null", ((JSONObject)json).isNullObject());
        } else if (JSONNull.getInstance().equals(json)) {
            Assert.fail(header + "Object is null");
        }
    }

    public static void assertNull(JSON json) {
        JSONAssert.assertNull(null, json);
    }

    public static void assertNull(String message, JSON json) {
        String header;
        String string = header = message == null ? "" : message + ": ";
        if (json instanceof JSONObject) {
            Assert.assertTrue(header + "Object is not null", ((JSONObject)json).isNullObject());
        } else if (!JSONNull.getInstance().equals(json)) {
            Assert.fail(header + "Object is not null");
        }
    }
}

