/*
 * Decompiled with CFR 0.152.
 */
package org.qetools.task_generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.text.StringSubstitutor;
import org.qetools.task_generator.PropertiesLookup;
import org.qetools.task_generator.Template;
import org.qetools.task_generator.Utils;
import org.qetools.task_generator.api.JiraClient;
import org.qetools.task_generator.api.JiraIssue;
import org.qetools.task_generator.core.Epic;
import org.qetools.task_generator.core.Task;
import org.qetools.task_generator.jql.WithSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class TaskGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TaskGenerator.class);
    private JiraClient jira;
    private File propertyFile;
    private StringSubstitutor variableResolver;

    public TaskGenerator(JiraClient jiraClient) throws FileNotFoundException, IOException {
        this(jiraClient, null);
    }

    public TaskGenerator(JiraClient jiraClient, File propertyFile) throws FileNotFoundException, IOException {
        this.jira = jiraClient;
        this.propertyFile = propertyFile;
    }

    public void generate(File yamlFile) {
        Template template = TaskGenerator.loadYamlFile(yamlFile);
        this.initializeJiraClient(template, yamlFile);
        template.getEpics().forEach(epic -> this.createEpic((Epic)epic));
        template.getTasks().forEach(task -> this.createTask((Task)task, null));
    }

    protected void initializeJiraClient(Template template, File yamlFile) {
        ArrayList<File> propertyFiles = new ArrayList<File>();
        if (this.propertyFile != null) {
            propertyFiles.add(this.propertyFile);
        }
        template.getPropertyFiles().forEach(path -> propertyFiles.add(Utils.getRelativeFile(yamlFile, path)));
        this.variableResolver = new StringSubstitutor(new PropertiesLookup(propertyFiles));
        String jiraUrl = this.variableResolver.getStringLookup().lookup("JIRA_URL");
        String jiraUsername = this.variableResolver.getStringLookup().lookup("JIRA_USERNAME");
        String jiraPassword = this.variableResolver.getStringLookup().lookup("JIRA_PASSWORD");
        String jiraAccessToken = this.variableResolver.getStringLookup().lookup("JIRA_ACCESS_TOKEN");
        String jiraPasswordBase64 = this.variableResolver.getStringLookup().lookup("JIRA_PASSWORD_BASE64");
        this.jira.setUrl(jiraUrl);
        if (jiraPassword == null && jiraPasswordBase64 != null) {
            jiraPassword = new String(Base64.getDecoder().decode(jiraPasswordBase64), Charset.forName("UTF-8"));
        }
        this.jira.setAccessToken(jiraAccessToken);
        this.jira.setCredentials(jiraUsername, jiraPassword);
        this.jira.initialize();
    }

    protected void createEpic(Epic epic) {
        this.resolve(epic);
        LOG.info("Create epic '{}'", (Object)epic.getSummary());
        epic.setIssueType("Epic");
        Optional<JiraIssue> issue = Optional.ofNullable(this.jira.get(WithSummary.withSummary(epic.getSummary())));
        if (issue.isPresent()) {
            LOG.info("\tEpic already exists, key = {}", (Object)issue.get().getField("key"));
            epic.setKey(issue.get().getField("key"));
        } else {
            JiraIssue createdIssue = this.jira.create(this.fields(epic));
            LOG.info("\tEpic created, key = {}", (Object)createdIssue.getField("key"));
            epic.setKey(createdIssue.getField("key"));
        }
        epic.getTasks().forEach(task -> this.createTask((Task)task, epic));
        epic.getSubtasks().forEach(subtask -> this.createSubtask((Task)subtask, epic));
    }

    protected void createTask(Task task, Epic epic) {
        this.resolve(task);
        LOG.info("Create task '{}'", (Object)task.getSummary());
        task.setIssueType("Task");
        task.setEpic(epic);
        this.setMissingFields(task, epic);
        Optional<JiraIssue> issue = Optional.ofNullable(this.jira.get(WithSummary.withSummary(task.getSummary())));
        if (issue.isPresent()) {
            LOG.info("\tTask already exists, key = {}", (Object)issue.get().getField("key"));
            task.setKey(issue.get().getField("key"));
        } else {
            JiraIssue createdIssue = this.jira.create(this.fields(task));
            LOG.info("\tTask created, key = {}", (Object)createdIssue.getField("key"));
            task.setKey(createdIssue.getField("key"));
        }
        task.getSubtasks().forEach(subtask -> this.createSubtask((Task)subtask, task));
    }

    protected void createSubtask(Task subtask, Task task) {
        this.resolve(subtask);
        LOG.info("Create sub-task '{}'", (Object)subtask.getSummary());
        subtask.setIssueType("Sub-task");
        subtask.setParent(task);
        this.setMissingFields(subtask, task);
        Optional<JiraIssue> issue = Optional.ofNullable(this.jira.get(WithSummary.withSummary(subtask.getSummary())));
        if (issue.isPresent()) {
            LOG.info("\tSub-task already exists, key = {}", (Object)issue.get().getField("key"));
        } else {
            JiraIssue createdIssue = this.jira.create(this.fields(subtask));
            LOG.info("\tSub-task created, key = {}", (Object)createdIssue.getField("key"));
            subtask.setKey(createdIssue.getField("key"));
        }
    }

    protected Map<String, String> fields(Task task) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("issuetype", this.variableResolver.replace(task.getIssueType()));
        fields.put("project", this.variableResolver.getStringLookup().lookup("JIRA_PROJECT"));
        fields.put("summary", this.variableResolver.replace(task.getSummary()));
        fields.put("description", this.variableResolver.replace(task.getDescription()));
        fields.put("assignee", this.variableResolver.replace(task.getAssignee()));
        fields.put("fixVersion", this.variableResolver.replace(task.getFixVersion()));
        if (!task.getComponents().isEmpty()) {
            fields.put("components", this.variableResolver.replace(task.getComponents()));
        } else {
            fields.put("components", this.variableResolver.replace(task.getComponent()));
        }
        if (task.getSecurity() != null) {
            fields.put("security", this.variableResolver.replace(task.getSecurity()));
        }
        if (task.getEpic() != null) {
            fields.put("epic", this.variableResolver.replace(task.getEpic().getKey()));
        }
        if (task.getParent() != null) {
            fields.put("parent", this.variableResolver.replace(task.getParent().getKey()));
        }
        if (task instanceof Epic) {
            Epic epic = (Epic)task;
            if (epic.getName() != null) {
                fields.put("name", epic.getName());
            } else {
                fields.put("name", epic.getSummary());
            }
        }
        return fields;
    }

    protected Task resolve(Task task) {
        task.setSummary(this.variableResolver.replace(task.getSummary()));
        task.setAssignee(this.variableResolver.replace(task.getAssignee()));
        task.setFixVersion(this.variableResolver.replace(task.getFixVersion()));
        task.setComponent(this.variableResolver.replace(task.getComponent()));
        task.setComponents(task.getComponents());
        return task;
    }

    protected Task setMissingFields(Task child, Task parent) {
        if (parent == null) {
            return child;
        }
        if (child.getAssignee() == null) {
            child.setAssignee(parent.getAssignee());
        }
        if (child.getFixVersion() == null) {
            child.setFixVersion(parent.getFixVersion());
        }
        if (child.getComponent() == null) {
            child.setComponent(parent.getComponent());
        }
        if (child.getComponents().isEmpty()) {
            child.setComponents(parent.getComponents());
        }
        if (child.getSecurity() == null) {
            child.setSecurity(parent.getSecurity());
        }
        return child;
    }

    private static Template loadYamlFile(File yamlFile) {
        Constructor constructor = new Constructor(Template.class);
        Yaml yaml = new Yaml(constructor);
        FileInputStream input = null;
        try {
            input = new FileInputStream(yamlFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        Template template = yaml.loadAs(input, Template.class);
        return template;
    }
}

