/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;

public class Attachment
extends Resource {
    private User author = null;
    private String filename = null;
    private Date created = null;
    private int size = 0;
    private String mimeType = null;
    private String content = null;

    protected Attachment(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.author = Field.getResource(User.class, map.get((Object)"author"), this.restclient);
        this.filename = Field.getString(map.get((Object)"filename"));
        this.created = Field.getDate(map.get((Object)"created"));
        this.size = Field.getInteger(map.get((Object)"size"));
        this.mimeType = Field.getString(map.get((Object)"mimeType"));
        this.content = Field.getString(map.get((Object)"content"));
    }

    public static Attachment get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Attachment.getBaseUri() + "attachment/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve attachment " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Attachment(restclient, (JSONObject)result);
    }

    public byte[] download() throws JiraException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            HttpGet get = new HttpGet(this.content);
            HttpResponse response = this.restclient.getHttpClient().execute(get);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream inputStream = entity.getContent();
                int next = inputStream.read();
                while (next > -1) {
                    bos.write(next);
                    next = inputStream.read();
                }
                bos.flush();
            }
        }
        catch (IOException e) {
            throw new JiraException(String.format("Failed downloading attachment from %s: %s", this.content, e.getMessage()));
        }
        return bos.toByteArray();
    }

    public String toString() {
        return this.getContentUrl();
    }

    public User getAuthor() {
        return this.author;
    }

    public Date getCreatedDate() {
        return this.created;
    }

    public String getContentUrl() {
        return this.content;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getSize() {
        return this.size;
    }
}

