/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.net.URI;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Filter
extends Resource {
    private String name;
    private String jql;
    private boolean favourite;

    public Filter(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.id = Field.getString(map.get((Object)"id"));
        this.self = Field.getString(map.get((Object)"self"));
        this.name = Field.getString(map.get((Object)"name"));
        this.jql = Field.getString(map.get((Object)"jql"));
        this.favourite = Field.getBoolean(map.get((Object)"favourite"));
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public String getJql() {
        return this.jql;
    }

    public String getName() {
        return this.name;
    }

    public static Filter get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            URI uri = restclient.buildURI(Filter.getBaseUri() + "filter/" + id);
            result = restclient.get(uri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve filter with id " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Filter(restclient, (JSONObject)result);
    }

    public String toString() {
        return "Filter{favourite=" + this.favourite + ", name='" + this.name + '\'' + ", jql='" + this.jql + '\'' + '}';
    }
}

