/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.ArrayList;
import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Watches
extends Resource {
    private String name = null;
    private int watchCount = 0;
    private boolean isWatching = false;
    private List<User> watchers = new ArrayList<User>();

    protected Watches(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.watchCount = Field.getInteger(map.get((Object)"watchCount"));
        this.isWatching = Field.getBoolean(map.get((Object)"isWatching"));
        this.watchers = Field.getResourceArray(User.class, map.get((Object)"watchers"), null);
    }

    public static Watches get(RestClient restclient, String issue) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Watches.getBaseUri() + "issue/" + issue + "/watchers");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve watches for issue " + issue, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Watches(restclient, (JSONObject)result);
    }

    public String toString() {
        return Integer.toString(this.getWatchCount());
    }

    public int getWatchCount() {
        return this.watchCount;
    }

    public boolean isWatching() {
        return this.isWatching;
    }

    public List<User> getWatchers() {
        return this.watchers;
    }
}

