/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class WorkLog
extends Resource {
    private User author = null;
    private String comment = null;
    private Date created = null;
    private Date updated = null;
    private User updateAuthor = null;
    private Date started = null;
    private String timeSpent = null;
    private int timeSpentSeconds = 0;

    protected WorkLog(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get((Object)"self"));
        this.id = Field.getString(map.get((Object)"id"));
        this.author = Field.getResource(User.class, map.get((Object)"author"), this.restclient);
        this.comment = Field.getString(map.get((Object)"comment"));
        this.created = Field.getDateTime(map.get((Object)"created"));
        this.updated = Field.getDateTime(map.get((Object)"updated"));
        this.updateAuthor = Field.getResource(User.class, map.get((Object)"updateAuthor"), this.restclient);
        this.started = Field.getDateTime(map.get((Object)"started"));
        this.timeSpent = Field.getString(map.get((Object)"timeSpent"));
        this.timeSpentSeconds = Field.getInteger(map.get((Object)"timeSpentSeconds"));
    }

    public static WorkLog get(RestClient restclient, String issue, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(WorkLog.getBaseUri() + "issue/" + issue + "/worklog/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve work log " + id + " on issue " + issue, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new WorkLog(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.created + " by " + this.author;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreatedDate() {
        return this.created;
    }

    public User getUpdateAuthor() {
        return this.updateAuthor;
    }

    public Date getUpdatedDate() {
        return this.updated;
    }

    public Date getStarted() {
        return this.started;
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public int getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }
}

